package org.apache.camel.component.netty4;

import org.apache.camel.Exchange;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.util.DoubleMap;

/**
 * Source code generated by org.apache.camel:apt
 */
@SuppressWarnings("unchecked")
public final class NettyConverterLoader implements TypeConverterLoader {

    public NettyConverterLoader() {
    }

    @Override
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        addTypeConverter(registry, byte[].class, io.netty.buffer.ByteBuf.class, false,
            (type, exchange, value) -> org.apache.camel.component.netty4.NettyConverter.toByteArray((io.netty.buffer.ByteBuf) value, exchange));
        addTypeConverter(registry, io.netty.buffer.ByteBuf.class, byte[].class, false,
            (type, exchange, value) -> org.apache.camel.component.netty4.NettyConverter.toByteBuffer((byte[]) value));
        addTypeConverter(registry, io.netty.buffer.ByteBuf.class, java.lang.String.class, false,
            (type, exchange, value) -> org.apache.camel.component.netty4.NettyConverter.toByteBuffer((java.lang.String) value, exchange));
        addTypeConverter(registry, java.io.InputStream.class, io.netty.buffer.ByteBuf.class, false,
            (type, exchange, value) -> org.apache.camel.component.netty4.NettyConverter.toInputStream((io.netty.buffer.ByteBuf) value, exchange));
        addTypeConverter(registry, java.io.ObjectInput.class, io.netty.buffer.ByteBuf.class, false,
            (type, exchange, value) -> org.apache.camel.component.netty4.NettyConverter.toObjectInput((io.netty.buffer.ByteBuf) value, exchange));
        addTypeConverter(registry, java.lang.String.class, io.netty.buffer.ByteBuf.class, false,
            (type, exchange, value) -> org.apache.camel.component.netty4.NettyConverter.toString((io.netty.buffer.ByteBuf) value, exchange));
        addTypeConverter(registry, javax.xml.transform.dom.DOMSource.class, io.netty.buffer.ByteBuf.class, false,
            (type, exchange, value) -> org.apache.camel.component.netty4.NettyConverter.toDOMSource((io.netty.buffer.ByteBuf) value, exchange));
        addTypeConverter(registry, javax.xml.transform.sax.SAXSource.class, io.netty.buffer.ByteBuf.class, false,
            (type, exchange, value) -> org.apache.camel.component.netty4.NettyConverter.toSAXSource((io.netty.buffer.ByteBuf) value, exchange));
        addTypeConverter(registry, javax.xml.transform.stax.StAXSource.class, io.netty.buffer.ByteBuf.class, false,
            (type, exchange, value) -> org.apache.camel.component.netty4.NettyConverter.toStAXSource((io.netty.buffer.ByteBuf) value, exchange));
        addTypeConverter(registry, javax.xml.transform.stream.StreamSource.class, io.netty.buffer.ByteBuf.class, false,
            (type, exchange, value) -> org.apache.camel.component.netty4.NettyConverter.toStreamSource((io.netty.buffer.ByteBuf) value, exchange));
        addTypeConverter(registry, org.w3c.dom.Document.class, io.netty.buffer.ByteBuf.class, false,
            (type, exchange, value) -> org.apache.camel.component.netty4.NettyConverter.toDocument((io.netty.buffer.ByteBuf) value, exchange));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) { 
        registry.addTypeConverter(toType, fromType, new SimpleTypeConverter(allowNull, method));
    }

}
