/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Map;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedWireTapMBean;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.WireTapProcessor;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.util.URISupport;

@ManagedResource(description="Managed WireTapProcessor")
public class ManagedWireTapProcessor
extends ManagedProcessor
implements ManagedWireTapMBean {
    private final WireTapProcessor processor;
    private String uri;
    private boolean sanitize;

    public ManagedWireTapProcessor(CamelContext context, WireTapProcessor processor, ProcessorDefinition<?> definition) {
        super(context, (Processor)processor, definition);
        this.processor = processor;
    }

    @Override
    public void init(ManagementStrategy strategy) {
        super.init(strategy);
        this.sanitize = strategy.getManagementAgent().getMask() != null ? strategy.getManagementAgent().getMask() : false;
        this.uri = this.sanitize ? URISupport.sanitizeUri((String)this.processor.getUri()) : this.processor.getUri();
    }

    @Override
    public void reset() {
        super.reset();
        if (this.processor.getEndpointUtilizationStatistics() != null) {
            this.processor.getEndpointUtilizationStatistics().clear();
        }
    }

    @Override
    public Boolean getSupportExtendedInformation() {
        return true;
    }

    public WireTapProcessor getProcessor() {
        return this.processor;
    }

    public String getUri() {
        return this.uri;
    }

    public Integer getCacheSize() {
        return this.processor.getCacheSize();
    }

    public Boolean isIgnoreInvalidEndpoint() {
        return this.processor.isIgnoreInvalidEndpoint();
    }

    public Boolean isCopy() {
        return this.processor.isCopy();
    }

    public Boolean isDynamicUri() {
        return this.processor.isDynamicUri();
    }

    public Integer getTaskSize() {
        return this.processor.getPendingExchangesSize();
    }

    public TabularData extendedInformation() {
        try {
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.endpointsUtilizationTabularType());
            EndpointUtilizationStatistics stats = this.processor.getEndpointUtilizationStatistics();
            if (stats != null) {
                for (Map.Entry entry : stats.getStatistics().entrySet()) {
                    Long hits;
                    CompositeType ct = CamelOpenMBeanTypes.endpointsUtilizationCompositeType();
                    String url = (String)entry.getKey();
                    if (this.sanitize) {
                        url = URISupport.sanitizeUri((String)url);
                    }
                    if ((hits = (Long)entry.getValue()) == null) {
                        hits = 0L;
                    }
                    CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"url", "hits"}, new Object[]{url, hits});
                    answer.put(data);
                }
            }
            return answer;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }
}

