/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms.requestor;

import java.math.BigInteger;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.camel.Message;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.requestor.DeferredRequestReplyMap;
import org.apache.camel.component.jms.requestor.FutureHandler;
import org.apache.camel.component.jms.requestor.MessageSelectorProvider;
import org.apache.camel.component.jms.requestor.PersistentReplyToFutureHandler;
import org.apache.camel.component.jms.requestor.Requestor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer102;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.transaction.PlatformTransactionManager;

public class PersistentReplyToRequestor
extends Requestor {
    private String replyToSelectorValue;

    public PersistentReplyToRequestor(JmsConfiguration configuration, ScheduledExecutorService executorService) {
        super(configuration, executorService);
    }

    protected FutureHandler createFutureHandler(String correlationID) {
        boolean dynamicSelector;
        boolean bl = dynamicSelector = this.getConfiguration().getReplyToDestinationSelectorName() == null;
        if (dynamicSelector) {
            return new PersistentReplyToFutureHandler(this, correlationID);
        }
        return new FutureHandler();
    }

    protected FutureHandler createFutureHandler(DeferredRequestReplyMap.DeferredMessageSentCallback callback) {
        boolean dynamicSelector;
        boolean bl = dynamicSelector = this.getConfiguration().getReplyToDestinationSelectorName() == null;
        if (dynamicSelector) {
            return new PersistentReplyToFutureHandler(this, callback);
        }
        return new FutureHandler();
    }

    public AbstractMessageListenerContainer createListenerContainer() {
        PlatformTransactionManager tm;
        TaskExecutor taskExecutor;
        JmsConfiguration config = this.getConfiguration();
        String replyToSelectorName = this.getConfiguration().getReplyToDestinationSelectorName();
        Object container = config.isUseVersion102() ? (replyToSelectorName != null ? new DefaultMessageListenerContainer102() : new CamelDefaultMessageListenerContainer102()) : (replyToSelectorName != null ? new DefaultMessageListenerContainer() : new CamelDefaultMessageListenerContainer());
        container.setConnectionFactory(config.getListenerConnectionFactory());
        DestinationResolver resolver = config.getDestinationResolver();
        if (resolver == null) {
            resolver = container.getDestinationResolver();
        }
        container.setDestinationResolver((DestinationResolver)new DestinationResolverDelegate(resolver));
        container.setDestinationName(this.getConfiguration().getReplyTo());
        if (replyToSelectorName != null) {
            this.replyToSelectorValue = "ID:" + new BigInteger(192, new Random()).toString(16);
            container.setMessageSelector(replyToSelectorName + "='" + this.replyToSelectorValue + "'");
        } else {
            ((MessageSelectorComposer)container).addCorrelationID("ID:" + new BigInteger(192, new Random()).toString(16));
        }
        container.setAutoStartup(true);
        container.setMessageListener((Object)this);
        container.setPubSubDomain(false);
        container.setSubscriptionDurable(false);
        ExceptionListener exceptionListener = config.getExceptionListener();
        if (exceptionListener != null) {
            container.setExceptionListener(exceptionListener);
        }
        container.setSessionTransacted(config.isTransacted());
        if (config.isTransacted()) {
            container.setSessionAcknowledgeMode(0);
        } else if (config.getAcknowledgementMode() >= 0) {
            container.setSessionAcknowledgeMode(config.getAcknowledgementMode());
        } else if (config.getAcknowledgementModeName() != null) {
            container.setSessionAcknowledgeModeName(config.getAcknowledgementModeName());
        }
        container.setConcurrentConsumers(1);
        container.setCacheLevel(2);
        if (config.getReceiveTimeout() >= 0L) {
            container.setReceiveTimeout(config.getReceiveTimeout());
        }
        if (config.getRecoveryInterval() >= 0L) {
            container.setRecoveryInterval(config.getRecoveryInterval());
        }
        if ((taskExecutor = config.getTaskExecutor()) != null) {
            container.setTaskExecutor(taskExecutor);
        }
        if ((tm = config.getTransactionManager()) != null) {
            container.setTransactionManager(tm);
        } else if (config.isTransacted()) {
            throw new IllegalArgumentException("Property transacted is enabled but a transactionManager was not injected!");
        }
        if (config.getTransactionName() != null) {
            container.setTransactionName(config.getTransactionName());
        }
        if (config.getTransactionTimeout() >= 0) {
            container.setTransactionTimeout(config.getTransactionTimeout());
        }
        return container;
    }

    public void setReplyToSelectorHeader(Message in, javax.jms.Message jmsIn) throws JMSException {
        String replyToSelectorName = this.getConfiguration().getReplyToDestinationSelectorName();
        if (this.replyToSelectorValue != null) {
            in.setHeader(replyToSelectorName, (Object)this.replyToSelectorValue);
            jmsIn.setStringProperty(replyToSelectorName, this.replyToSelectorValue);
        }
    }

    public static class CamelDefaultMessageListenerContainer
    extends DefaultMessageListenerContainer
    implements MessageSelectorComposer {
        MessageSelectorProvider provider = new MessageSelectorProvider();

        public void addCorrelationID(String id) {
            this.provider.addCorrelationID(id);
        }

        public void removeCorrelationID(String id) {
            this.provider.removeCorrelationID(id);
        }

        public void setMessageSelector(String messageSelector) {
            throw new UnsupportedOperationException();
        }

        public String getMessageSelector() {
            return this.provider.get();
        }
    }

    public static class CamelDefaultMessageListenerContainer102
    extends DefaultMessageListenerContainer102
    implements MessageSelectorComposer {
        MessageSelectorProvider provider = new MessageSelectorProvider();

        public void addCorrelationID(String id) {
            this.provider.addCorrelationID(id);
        }

        public void removeCorrelationID(String id) {
            this.provider.removeCorrelationID(id);
        }

        public void setMessageSelector(String messageSelector) {
            throw new UnsupportedOperationException();
        }

        public String getMessageSelector() {
            return this.provider.get();
        }
    }

    public static interface MessageSelectorComposer {
        public void addCorrelationID(String var1);

        public void removeCorrelationID(String var1);
    }

    public class DestinationResolverDelegate
    implements DestinationResolver {
        private DestinationResolver delegate;
        private Destination destination;

        public DestinationResolverDelegate(DestinationResolver delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Destination resolveDestinationName(Session session, String destinationName, boolean pubSubDomain) throws JMSException {
            Requestor requestor = PersistentReplyToRequestor.this.getOutterInstance();
            synchronized (requestor) {
                try {
                    if (this.destination == null) {
                        this.destination = this.delegate.resolveDestinationName(session, destinationName, pubSubDomain);
                        PersistentReplyToRequestor.this.setReplyTo(this.destination);
                    }
                }
                finally {
                    ((Object)((Object)PersistentReplyToRequestor.this.getOutterInstance())).notifyAll();
                }
            }
            return this.destination;
        }
    }
}

