/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.discovery.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.activemq.transport.discovery.http.HTTPDiscoveryAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryRegistryServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(HTTPDiscoveryAgent.class);
    long maxKeepAge = 3600000L;
    ConcurrentMap<String, ConcurrentMap<String, Long>> serviceGroups = new ConcurrentHashMap<String, ConcurrentMap<String, Long>>();

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String group = req.getPathInfo();
        String service = req.getHeader("service");
        LOG.debug("Registering: group=" + group + ", service=" + service);
        ConcurrentMap<String, Long> services = this.getServiceGroup(group);
        services.put(service, System.currentTimeMillis());
    }

    private ConcurrentMap<String, Long> getServiceGroup(String group) {
        return this.serviceGroups.computeIfAbsent(group, k -> new ConcurrentHashMap());
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            long freshness = 30000L;
            String p = req.getParameter("freshness");
            if (p != null) {
                freshness = Long.parseLong(p);
            }
            String group = req.getPathInfo();
            LOG.debug("group=" + group);
            ConcurrentMap<String, Long> services = this.getServiceGroup(group);
            PrintWriter writer = resp.getWriter();
            long now = System.currentTimeMillis();
            long dropTime = now - this.maxKeepAge;
            long minimumTime = now - freshness;
            ArrayList dropList = new ArrayList();
            for (Map.Entry entry : services.entrySet()) {
                if ((Long)entry.getValue() > minimumTime) {
                    writer.println((String)entry.getKey());
                    continue;
                }
                if ((Long)entry.getValue() >= dropTime) continue;
                dropList.add(entry.getKey());
            }
            for (String service : dropList) {
                services.remove(service);
            }
        }
        catch (Exception e) {
            resp.sendError(500, "Error occured: " + e);
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String group = req.getPathInfo();
        String service = req.getHeader("service");
        LOG.debug("Unregistering: group=" + group + ", service=" + service);
        ConcurrentMap<String, Long> services = this.getServiceGroup(group);
        services.remove(service);
    }
}

