/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.stomp;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompConversionException;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.messaging.support.MessageHeaderInitializer;
import org.springframework.util.InvalidMimeTypeException;
import org.springframework.util.MultiValueMap;

public class StompDecoder {
    static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    static final byte[] HEARTBEAT_PAYLOAD = new byte[]{10};
    private static final Log logger = LogFactory.getLog(StompDecoder.class);
    private MessageHeaderInitializer headerInitializer;

    public void setHeaderInitializer(MessageHeaderInitializer headerInitializer) {
        this.headerInitializer = headerInitializer;
    }

    public MessageHeaderInitializer getHeaderInitializer() {
        return this.headerInitializer;
    }

    public List<Message<byte[]>> decode(ByteBuffer buffer) {
        return this.decode(buffer, null);
    }

    public List<Message<byte[]>> decode(ByteBuffer buffer, MultiValueMap<String, String> partialMessageHeaders) {
        Message<byte[]> message;
        ArrayList<Message<byte[]>> messages = new ArrayList<Message<byte[]>>();
        while (buffer.hasRemaining() && (message = this.decodeMessage(buffer, partialMessageHeaders)) != null) {
            messages.add(message);
        }
        return messages;
    }

    private Message<byte[]> decodeMessage(ByteBuffer buffer, MultiValueMap<String, String> headers) {
        Message<byte[]> decodedMessage = null;
        this.skipLeadingEol(buffer);
        buffer.mark();
        String command = this.readCommand(buffer);
        if (command.length() > 0) {
            StompCommand stompCommand;
            StompHeaderAccessor headerAccessor = null;
            byte[] payload = null;
            if (buffer.remaining() > 0) {
                stompCommand = StompCommand.valueOf(command);
                headerAccessor = StompHeaderAccessor.create(stompCommand);
                this.initHeaders(headerAccessor);
                this.readHeaders(buffer, headerAccessor);
                payload = this.readPayload(buffer, headerAccessor);
            }
            if (payload != null) {
                if (payload.length > 0 && (stompCommand = headerAccessor.getCommand()) != null && !stompCommand.isBodyAllowed()) {
                    throw new StompConversionException((Object)((Object)stompCommand) + " shouldn't have a payload: length=" + payload.length + ", headers=" + headers);
                }
                headerAccessor.updateSimpMessageHeadersFromStompHeaders();
                headerAccessor.setLeaveMutable(true);
                decodedMessage = MessageBuilder.createMessage(payload, headerAccessor.getMessageHeaders());
                if (logger.isTraceEnabled()) {
                    logger.trace("Decoded " + headerAccessor.getDetailedLogMessage(payload));
                }
            } else {
                String name;
                MultiValueMap map;
                logger.trace("Incomplete frame, resetting input buffer...");
                if (headers != null && headerAccessor != null && (map = (MultiValueMap)headerAccessor.getHeader(name = "nativeHeaders")) != null) {
                    headers.putAll(map);
                }
                buffer.reset();
            }
        } else {
            StompHeaderAccessor headerAccessor = StompHeaderAccessor.createForHeartbeat();
            this.initHeaders(headerAccessor);
            headerAccessor.setLeaveMutable(true);
            decodedMessage = MessageBuilder.createMessage(HEARTBEAT_PAYLOAD, headerAccessor.getMessageHeaders());
            if (logger.isTraceEnabled()) {
                logger.trace("Decoded " + headerAccessor.getDetailedLogMessage(null));
            }
        }
        return decodedMessage;
    }

    private void initHeaders(StompHeaderAccessor headerAccessor) {
        MessageHeaderInitializer initializer = this.getHeaderInitializer();
        if (initializer != null) {
            initializer.initHeaders(headerAccessor);
        }
    }

    protected void skipLeadingEol(ByteBuffer buffer) {
        while (this.tryConsumeEndOfLine(buffer)) {
        }
    }

    private String readCommand(ByteBuffer buffer) {
        ByteArrayOutputStream command = new ByteArrayOutputStream(256);
        while (buffer.remaining() > 0 && !this.tryConsumeEndOfLine(buffer)) {
            command.write(buffer.get());
        }
        return new String(command.toByteArray(), UTF8_CHARSET);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readHeaders(ByteBuffer buffer, StompHeaderAccessor headerAccessor) {
        while (true) {
            ByteArrayOutputStream headerStream = new ByteArrayOutputStream(256);
            boolean headerComplete = false;
            while (buffer.hasRemaining()) {
                if (this.tryConsumeEndOfLine(buffer)) {
                    headerComplete = true;
                    break;
                }
                headerStream.write(buffer.get());
            }
            if (headerStream.size() <= 0 || !headerComplete) return;
            String header = new String(headerStream.toByteArray(), UTF8_CHARSET);
            int colonIndex = header.indexOf(58);
            if (colonIndex <= 0) {
                if (buffer.remaining() <= 0) continue;
                throw new StompConversionException("Illegal header: '" + header + "'. A header must be of the form <name>:[<value>].");
            }
            String headerName = this.unescape(header.substring(0, colonIndex));
            String headerValue = this.unescape(header.substring(colonIndex + 1));
            try {
                headerAccessor.addNativeHeader(headerName, headerValue);
                continue;
            }
            catch (InvalidMimeTypeException ex) {
                if (buffer.remaining() > 0) throw ex;
                continue;
            }
            break;
        }
    }

    private String unescape(String inString) {
        StringBuilder sb = new StringBuilder(inString.length());
        int pos = 0;
        int index = inString.indexOf(92);
        while (index >= 0) {
            sb.append(inString.substring(pos, index));
            if (index + 1 >= inString.length()) {
                throw new StompConversionException("Illegal escape sequence at index " + index + ": " + inString);
            }
            char c = inString.charAt(index + 1);
            if (c == 'r') {
                sb.append('\r');
            } else if (c == 'n') {
                sb.append('\n');
            } else if (c == 'c') {
                sb.append(':');
            } else if (c == '\\') {
                sb.append('\\');
            } else {
                throw new StompConversionException("Illegal escape sequence at index " + index + ": " + inString);
            }
            pos = index + 2;
            index = inString.indexOf(92, pos);
        }
        sb.append(inString.substring(pos));
        return sb.toString();
    }

    private byte[] readPayload(ByteBuffer buffer, StompHeaderAccessor headerAccessor) {
        Integer contentLength;
        try {
            contentLength = headerAccessor.getContentLength();
        }
        catch (NumberFormatException ex) {
            if (logger.isWarnEnabled()) {
                logger.warn("Ignoring invalid content-length: '" + headerAccessor);
            }
            contentLength = null;
        }
        if (contentLength != null && contentLength >= 0) {
            if (buffer.remaining() > contentLength) {
                byte[] payload = new byte[contentLength.intValue()];
                buffer.get(payload);
                if (buffer.get() != 0) {
                    throw new StompConversionException("Frame must be terminated with a null octet");
                }
                return payload;
            }
            return null;
        }
        ByteArrayOutputStream payload = new ByteArrayOutputStream(256);
        while (buffer.remaining() > 0) {
            byte b = buffer.get();
            if (b == 0) {
                return payload.toByteArray();
            }
            payload.write(b);
        }
        return null;
    }

    private boolean tryConsumeEndOfLine(ByteBuffer buffer) {
        if (buffer.remaining() > 0) {
            byte b = buffer.get();
            if (b == 10) {
                return true;
            }
            if (b == 13) {
                if (buffer.remaining() > 0 && buffer.get() == 10) {
                    return true;
                }
                throw new StompConversionException("'\\r' must be followed by '\\n'");
            }
            buffer.position(buffer.position() - 1);
        }
        return false;
    }
}

