/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jms.pool;

import java.io.Serializable;
import java.util.Hashtable;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.spi.ObjectFactory;
import javax.transaction.TransactionManager;
import org.apache.activemq.jms.pool.ConnectionPool;
import org.apache.activemq.jms.pool.IntrospectionSupport;
import org.apache.activemq.jms.pool.PooledConnectionFactory;
import org.apache.activemq.jms.pool.XaConnectionPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XaPooledConnectionFactory
extends PooledConnectionFactory
implements ObjectFactory,
Serializable,
QueueConnectionFactory,
TopicConnectionFactory {
    private static final transient Logger LOG = LoggerFactory.getLogger(XaPooledConnectionFactory.class);
    private TransactionManager transactionManager;
    private boolean tmFromJndi = false;
    private String tmJndiName = "java:/TransactionManager";

    public TransactionManager getTransactionManager() {
        block3: {
            if (this.transactionManager == null && this.tmFromJndi) {
                try {
                    this.transactionManager = (TransactionManager)new InitialContext().lookup(this.getTmJndiName());
                }
                catch (Throwable ignored) {
                    if (!LOG.isTraceEnabled()) break block3;
                    LOG.trace("exception on tmFromJndi: " + this.getTmJndiName(), ignored);
                }
            }
        }
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    protected ConnectionPool createConnectionPool(Connection connection) {
        return new XaConnectionPool(connection, this.getTransactionManager());
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        this.setTmFromJndi(true);
        this.configFromJndiConf(obj);
        if (environment != null) {
            IntrospectionSupport.setProperties(this, environment);
        }
        return this;
    }

    private void configFromJndiConf(Object rootContextName) {
        block4: {
            if (rootContextName instanceof String) {
                String name = (String)rootContextName;
                name = name.substring(0, name.lastIndexOf(47)) + "/conf" + name.substring(name.lastIndexOf(47));
                try {
                    InitialContext ctx = new InitialContext();
                    NamingEnumeration<Binding> bindings = ctx.listBindings(name);
                    while (bindings.hasMore()) {
                        Binding bd = bindings.next();
                        IntrospectionSupport.setProperty(this, bd.getName(), bd.getObject());
                    }
                }
                catch (Exception ignored) {
                    if (!LOG.isTraceEnabled()) break block4;
                    LOG.trace("exception on config from jndi: " + name, (Throwable)ignored);
                }
            }
        }
    }

    public String getTmJndiName() {
        return this.tmJndiName;
    }

    public void setTmJndiName(String tmJndiName) {
        this.tmJndiName = tmJndiName;
    }

    public boolean isTmFromJndi() {
        return this.tmFromJndi;
    }

    public void setTmFromJndi(boolean tmFromJndi) {
        this.tmFromJndi = tmFromJndi;
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return (QueueConnection)this.createConnection();
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        return (QueueConnection)this.createConnection(userName, password);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return (TopicConnection)this.createConnection();
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        return (TopicConnection)this.createConnection(userName, password);
    }
}

