/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.StorageIOException;
import org.netbeans.mdr.persistence.StoragePersistentDataException;
import org.netbeans.mdr.persistence.StorageTransientDataException;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.CachedPage;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.FileHeader;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.IntrusiveList;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.LogFile;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.PageID;

public class FileCache {
    private RandomAccessFile[] files;
    private int[] fileSize;
    private FileHeader header;
    private LogFile log;
    private boolean inXact;
    private static int pageSize;
    private static ArrayList pages;
    private static HashMap pageHash;
    private static IntrusiveList freePages;
    private static HashSet instances;
    private HashMap heldForLog;
    private long newTimeStamp;
    private static int hits;
    private static int misses;
    private static int extensions;
    private static int pagesFlushed;
    private int logFlushes;
    private static int flushFailure;
    private static int commitFailure;
    private ArrayList toNotify;
    static final /* synthetic */ boolean $assertionsDisabled;

    static int checkForForcedFailure(String property, int count) {
        if (count == -1) {
            Integer failCount = Integer.getInteger(property);
            int n = count = failCount == null ? 0 : failCount;
        }
        if (count > 0 && --count == 0) {
            System.exit(1);
        }
        return count;
    }

    private static void addPages(int numToAdd) {
        for (int i = 0; i < numToAdd; ++i) {
            CachedPage page = new CachedPage(pageSize);
            pages.add(page);
            freePages.addLast(page);
        }
    }

    void holdForLog(CachedPage page) {
        page.heldForLog = true;
        this.heldForLog.put(page.key, page);
    }

    void logWasFlushed() {
        Iterator itr = this.heldForLog.values().iterator();
        while (itr.hasNext()) {
            CachedPage page = (CachedPage)itr.next();
            page.heldForLog = false;
            if (page.getPinCount() != 0) continue;
            freePages.addFirst(page);
        }
        this.heldForLog.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileCache(String[] fileNames, String baseName) throws StorageException {
        block13: {
            this.logFlushes = 0;
            boolean failure = true;
            try {
                block14: {
                    try {
                        int i;
                        this.files = new RandomAccessFile[fileNames.length];
                        this.fileSize = new int[fileNames.length];
                        for (i = 0; i < fileNames.length; ++i) {
                            this.files[i] = new RandomAccessFile(fileNames[i], "rw");
                        }
                        FileHeader tmpHeader = new FileHeader(this.files[0]);
                        this.log = new LogFile(this, baseName, 2048, fileNames.length, tmpHeader.fileId);
                        for (i = 0; i < fileNames.length; ++i) {
                            this.fileSize[i] = (int)this.files[i].length();
                            FileHeader hdr = new FileHeader(this.files[i]);
                            if (i == 0) {
                                this.header = hdr;
                                continue;
                            }
                            if (hdr.equals(this.header)) continue;
                            throw new StoragePersistentDataException("Files are not consistent");
                        }
                        this.heldForLog = new HashMap();
                        failure = false;
                        instances.add(this);
                        Object var8_8 = null;
                        if (!failure) break block13;
                        if (this.files == null) break block14;
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        if (failure) {
                            if (this.files != null) {
                                for (int i = 0; i < this.files.length; ++i) {
                                    if (this.files[i] == null) continue;
                                    this.files[i].close();
                                }
                            }
                            if (this.log != null) {
                                this.log.close();
                            }
                        }
                        throw throwable;
                    }
                    for (int i = 0; i < this.files.length; ++i) {
                        if (this.files[i] == null) continue;
                        this.files[i].close();
                    }
                }
                if (this.log != null) {
                    this.log.close();
                }
            }
            catch (IOException ex) {
                throw new StorageIOException(ex);
            }
        }
    }

    RandomAccessFile[] getFiles() {
        return this.files;
    }

    public synchronized void abort() throws StorageException {
        this.closeFiles();
    }

    public synchronized void close() throws StorageException {
        this.commit();
        Iterator itr = pages.iterator();
        while (itr.hasNext()) {
            CachedPage page = (CachedPage)itr.next();
            if (page.getOwner() != this) continue;
            if (pages.size() > 128) {
                itr.remove();
                freePages.remove(page);
                continue;
            }
            freePages.addLast(page);
            page.reInit(null, null);
        }
        Iterator it = pageHash.keySet().iterator();
        while (it.hasNext()) {
            HashKey entry = (HashKey)it.next();
            if (entry.owner != this) continue;
            it.remove();
        }
        this.closeFiles();
    }

    private void closeFiles() throws StorageException {
        try {
            for (int i = 0; i < this.files.length; ++i) {
                this.files[i].close();
            }
            this.log.close();
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
        finally {
            instances.remove(this);
        }
    }

    public synchronized void commit() throws StorageException {
        commitFailure = FileCache.checkForForcedFailure("org.netbeans.mdr.persistence.btreeimpl.btreestorage.FileCache.commitFailure", commitFailure);
        if (this.toNotify != null) {
            Iterator itr = this.toNotify.iterator();
            while (itr.hasNext()) {
                NotifyOnCommit obj = (NotifyOnCommit)itr.next();
                obj.prepareToCommit();
            }
        }
        if (this.inXact) {
            for (int i = 0; i < this.files.length; ++i) {
                CachedPage first = this.getPage(i, 0);
                this.setWritable(first);
                FileHeader.updateTime(first, this.newTimeStamp);
                first.unpin();
            }
            this.log.flush();
            Iterator itr = pages.iterator();
            while (itr.hasNext()) {
                CachedPage page = (CachedPage)itr.next();
                if (!page.isDirty || page.getOwner() != this) continue;
                FileCache.flushOne(page);
            }
            this.log.commit();
            this.header.timeStamp = this.newTimeStamp;
            this.inXact = false;
        }
    }

    private static void flushOne(CachedPage page) throws StorageException {
        try {
            flushFailure = FileCache.checkForForcedFailure("org.netbeans.mdr.persistence.btreeimpl.btreestorage.FileCache.flushFailure", flushFailure);
            FileCache owner = page.getOwner();
            if (!$assertionsDisabled && owner == null) {
                throw new AssertionError();
            }
            if (!instances.contains(owner)) {
                return;
            }
            RandomAccessFile file = owner.files[page.key.fileIndex];
            file.seek(page.key.offset);
            file.write(page.contents);
            page.isDirty = false;
            ++pagesFlushed;
            if (page.key.offset >= owner.fileSize[page.key.fileIndex]) {
                owner.fileSize[page.key.fileIndex] = page.key.offset + pageSize;
            }
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
    }

    public synchronized void unpin(CachedPage[] pages) throws StorageException {
        for (int i = 0; i < pages.length; ++i) {
            this.unpin(pages[i]);
        }
    }

    public synchronized void unpin(CachedPage page) throws StorageException {
        if (page.getPinCount() <= 0) {
            throw new StorageTransientDataException("Attempt to unpin page which is not pinned");
        }
        if (page.innerUnpin() == 0 && !page.heldForLog) {
            freePages.addFirst(page);
        }
    }

    public synchronized CachedPage[] getPages(int fileidx, int first, int size) throws StorageException {
        CachedPage[] retval = new CachedPage[size];
        for (int i = 0; i < size; ++i) {
            retval[i] = FileCache.getPage(this, new PageID(fileidx, pageSize * (first + i)), false);
        }
        return retval;
    }

    public synchronized CachedPage getPage(int fileidx, int pageNum) throws StorageException {
        return FileCache.getPage(this, new PageID(fileidx, pageNum * pageSize), false);
    }

    synchronized CachedPage getPage(PageID page) throws StorageException {
        return FileCache.getPage(this, page, false);
    }

    private static CachedPage getPage(FileCache instance, PageID id, boolean fromCacheOnly) throws StorageException {
        HashKey key = new HashKey(instance, id);
        CachedPage page = (CachedPage)pageHash.get(key);
        if (page != null) {
            if (page.pin(instance) == 0 && !page.heldForLog) {
                freePages.remove(page);
            }
            ++hits;
            return page;
        }
        if (fromCacheOnly) {
            return null;
        }
        CachedPage free = (CachedPage)freePages.removeLast();
        if (free == null) {
            Iterator it = instances.iterator();
            while (it.hasNext()) {
                FileCache cache = (FileCache)it.next();
                if (cache.heldForLog.isEmpty()) continue;
                cache.log.flush();
                ++cache.logFlushes;
            }
            free = (CachedPage)freePages.removeLast();
        }
        if (free == null) {
            int increment = (pages.size() + 1) / 2;
            FileCache.addPages(increment);
            ++extensions;
            free = (CachedPage)freePages.removeLast();
        }
        if (free.isDirty) {
            FileCache.flushOne(free);
        }
        if (free.key != null && free.getOwner() != null) {
            pageHash.remove(new HashKey(free.getOwner(), free.key));
        }
        free.reInit(instance, id);
        pageHash.put(key, free);
        if (id.offset >= instance.fileSize[id.fileIndex]) {
            Arrays.fill(free.contents, (byte)0);
        } else {
            try {
                instance.files[id.fileIndex].seek(id.offset);
                instance.files[id.fileIndex].readFully(free.contents);
            }
            catch (IOException ex) {
                throw new StorageIOException(ex);
            }
        }
        free.pin(instance);
        ++misses;
        return free;
    }

    public synchronized void setWritable(CachedPage page) throws StorageException {
        if (page.isDirty) {
            return;
        }
        if (!this.inXact) {
            this.newTimeStamp = System.currentTimeMillis();
            this.log.begin(this.files, this.header.timeStamp, this.newTimeStamp);
            this.inXact = true;
        }
        this.log.addPageToLog(page);
        page.isDirty = true;
    }

    public synchronized void setWritable(CachedPage[] pages) throws StorageException {
        for (int i = 0; i < pages.length; ++i) {
            this.setWritable(pages[i]);
        }
    }

    public void dumpCache(PrintStream strm) {
        strm.println("Cached files:");
        for (int i = 0; i < this.files.length; ++i) {
            strm.println(Integer.toString(i) + ": " + this.files[i].toString() + " size: " + this.fileSize[i]);
        }
        strm.println("");
        strm.println(Integer.toString(pages.size()) + " pages");
        Iterator itr = pages.iterator();
        int num = 0;
        while (itr.hasNext()) {
            strm.println(Integer.toString(num++) + ":");
            strm.print(((CachedPage)itr.next()).toString());
        }
    }

    public void showStats(PrintStream strm) {
        this.showStats(new PrintWriter(strm));
    }

    public void showStats(PrintWriter strm) {
        int pinned = 0;
        int dirty = 0;
        int held = 0;
        for (int i = 0; i < pages.size(); ++i) {
            CachedPage pg = (CachedPage)pages.get(i);
            if (pg.getPinCount() > 0) {
                ++pinned;
            }
            if (pg.isDirty) {
                ++dirty;
            }
            if (!pg.heldForLog) continue;
            ++held;
        }
        strm.println("Page counts: total = " + pages.size() + " pinned = " + pinned + " dirty = " + dirty + " held = " + held);
        strm.println("Cache hits: " + hits + " misses: " + misses + " hit rate: " + 100.0 * (double)hits / (double)(hits + misses));
        strm.println(pagesFlushed + " pages written");
        strm.println("Log file flushed to free pages " + this.logFlushes + " times");
        strm.println("Cache made bigger " + extensions + " times");
        strm.flush();
    }

    int getPageSize() {
        return pageSize;
    }

    public synchronized void addNotifier(NotifyOnCommit notified) {
        if (this.toNotify == null) {
            this.toNotify = new ArrayList();
        }
        this.toNotify.add(notified);
    }

    static {
        $assertionsDisabled = !FileCache.class.desiredAssertionStatus();
        instances = new HashSet();
        hits = 0;
        misses = 0;
        extensions = 0;
        pagesFlushed = 0;
        flushFailure = -1;
        commitFailure = -1;
        pages = new ArrayList(128);
        pageHash = new HashMap();
        freePages = new IntrusiveList();
        pageSize = 2048;
        FileCache.addPages(128);
    }

    public static interface NotifyOnCommit {
        public void prepareToCommit() throws StorageException;
    }

    private static class HashKey {
        public final FileCache owner;
        public final PageID id;

        public HashKey(FileCache owner, PageID id) {
            this.owner = owner;
            this.id = id;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof HashKey && ((HashKey)o).owner == this.owner && ((HashKey)o).id.equals(this.id);
        }

        public int hashCode() {
            return this.owner.hashCode() + 31 * this.id.hashCode();
        }
    }
}

