/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.uml14;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.configuration.Filters;
import org.andromda.core.metafacade.MetafacadeBase;
import org.andromda.core.metafacade.MetafacadeFactory;
import org.andromda.core.metafacade.ModelAccessFacade;
import org.andromda.metafacades.uml.EntityMetafacadeUtils;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.andromda.metafacades.uml.PackageFacade;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.omg.uml.UmlPackage;
import org.omg.uml.foundation.core.ModelElement;

public class UMLModelAccessFacade
implements ModelAccessFacade {
    private static final Logger logger = Logger.getLogger(UMLModelAccessFacade.class);
    private UmlPackage model;
    protected Filters modelPackages;

    public void setModel(Object model) {
        ExceptionUtils.checkNull((String)"model", (Object)model);
        ExceptionUtils.checkAssignable(UmlPackage.class, (String)"modelElement", model.getClass());
        this.model = (UmlPackage)model;
        EntityMetafacadeUtils.clearForeignKeyConstraintNameCache();
    }

    public UmlPackage getModel() {
        return this.model;
    }

    public String getName(Object modelElement) {
        ExceptionUtils.checkNull((String)"modelElement", (Object)modelElement);
        ExceptionUtils.checkAssignable(ModelElementFacade.class, (String)"modelElement", modelElement.getClass());
        return ((ModelElementFacade)modelElement).getName();
    }

    public String getPackageName(Object modelElement) {
        String name;
        ExceptionUtils.checkNull((String)"modelElement", (Object)modelElement);
        ExceptionUtils.checkAssignable(ModelElementFacade.class, (String)"modelElement", modelElement.getClass());
        ModelElementFacade modelElementFacade = (ModelElementFacade)modelElement;
        StringBuilder packageName = new StringBuilder(modelElementFacade.getPackageName(true));
        if (modelElement instanceof PackageFacade && StringUtils.isNotBlank((String)(name = modelElementFacade.getName()))) {
            packageName.append("::");
            packageName.append(name);
        }
        return packageName.toString();
    }

    public Collection<String> getStereotypeNames(Object modelElement) {
        Collection<String> stereotypeNames = new ArrayList<String>();
        if (modelElement instanceof ModelElement) {
            ModelElement element = (ModelElement)modelElement;
            Collection stereotypes = element.getStereotype();
            for (ModelElement stereotype : stereotypes) {
                stereotypeNames.add(stereotype.getName());
            }
        } else if (modelElement instanceof ModelElementFacade) {
            stereotypeNames = ((ModelElementFacade)modelElement).getStereotypeNames();
        }
        return stereotypeNames;
    }

    public Collection<MetafacadeBase> findByStereotype(String stereotype) {
        String methodName = "UMLModelAccessFacade.findByStereotype";
        ArrayList<MetafacadeBase> metafacades = new ArrayList<MetafacadeBase>();
        if (StringUtils.isNotBlank((String)(stereotype = StringUtils.trimToEmpty((String)stereotype)))) {
            if (this.model != null) {
                Collection underlyingElements = this.model.getCore().getModelElement().refAllOfType();
                if (underlyingElements != null && !underlyingElements.isEmpty()) {
                    for (ModelElement element : underlyingElements) {
                        Collection<String> stereotypeNames = this.getStereotypeNames(element);
                        if (stereotypeNames == null || !stereotypeNames.contains(stereotype)) continue;
                        metafacades.add(MetafacadeFactory.getInstance().createMetafacade((Object)element));
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("completed UMLModelAccessFacade.findByStereotype with " + metafacades.size() + " modelElements"));
                }
            }
            this.filterMetafacades(metafacades);
        }
        return metafacades;
    }

    public Collection<MetafacadeBase> getModelElements() {
        Collection<Object> metafacades = Collections.emptyList();
        if (this.model != null) {
            metafacades = MetafacadeFactory.getInstance().createMetafacades(this.model.getCore().getModelElement().refAllOfType());
            this.filterMetafacades(metafacades);
        }
        return metafacades;
    }

    public void setPackageFilter(Filters modelPackages) {
        this.modelPackages = modelPackages;
    }

    private void filterMetafacades(Collection metafacades) {
        if (this.modelPackages != null && !this.modelPackages.isEmpty()) {
            CollectionUtils.filter((Collection)metafacades, (Predicate)new Predicate(){

                public boolean evaluate(Object metafacade) {
                    boolean valid = false;
                    if (metafacade instanceof MetafacadeBase) {
                        String name;
                        ModelElementFacade modelElementFacade = (ModelElementFacade)metafacade;
                        StringBuilder packageName = new StringBuilder(modelElementFacade.getPackageName(true));
                        if (metafacade instanceof PackageFacade && StringUtils.isNotBlank((String)(name = modelElementFacade.getName()))) {
                            packageName.append("::");
                            packageName.append(name);
                        }
                        valid = UMLModelAccessFacade.this.modelPackages.isApply(packageName.toString());
                    }
                    return valid;
                }
            });
        }
    }
}

