/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.uml14;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.andromda.metafacades.uml.ActivityGraphFacade;
import org.andromda.metafacades.uml.CallEventFacade;
import org.andromda.metafacades.uml.EventFacade;
import org.andromda.metafacades.uml.FrontEndAction;
import org.andromda.metafacades.uml.FrontEndActivityGraph;
import org.andromda.metafacades.uml.FrontEndControllerOperation;
import org.andromda.metafacades.uml.FrontEndEvent;
import org.andromda.metafacades.uml.FrontEndExceptionHandler;
import org.andromda.metafacades.uml.FrontEndUseCase;
import org.andromda.metafacades.uml.FrontEndView;
import org.andromda.metafacades.uml.OperationFacade;
import org.andromda.metafacades.uml.ServiceOperation;
import org.andromda.metafacades.uml.StateMachineFacade;
import org.andromda.metafacades.uml.TransitionFacade;
import org.andromda.metafacades.uml.UseCaseFacade;
import org.andromda.metafacades.uml14.FrontEndActionStateLogic;
import org.andromda.utils.StringUtilsHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

public class FrontEndActionStateLogicImpl
extends FrontEndActionStateLogic {
    private static final long serialVersionUID = 34L;

    public FrontEndActionStateLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    @Override
    protected boolean handleIsServerSide() {
        return !(this.THIS() instanceof FrontEndView);
    }

    @Override
    protected String handleGetActionMethodName() {
        return '_' + StringUtilsHelper.lowerCamelCaseName((String)this.getName());
    }

    @Override
    protected boolean handleIsContainedInFrontEndUseCase() {
        return this.getStateMachine() instanceof FrontEndActivityGraph;
    }

    protected TransitionFacade handleGetForward() {
        TransitionFacade forward = null;
        Iterator<TransitionFacade> iterator = this.getOutgoings().iterator();
        while (iterator.hasNext() && forward == null) {
            TransitionFacade transition = iterator.next();
            if (transition instanceof FrontEndExceptionHandler) continue;
            forward = transition;
        }
        return forward;
    }

    @Override
    protected List<OperationFacade> handleGetServiceCalls() {
        ArrayList<OperationFacade> serviceCallsList = new ArrayList<OperationFacade>();
        Collection<EventFacade> deferrableEvents = this.getDeferrableEvents();
        for (EventFacade event : deferrableEvents) {
            if (event instanceof CallEventFacade) {
                serviceCallsList.addAll(((CallEventFacade)event).getOperations());
                continue;
            }
            if (!(event instanceof FrontEndEvent)) continue;
            serviceCallsList.addAll(((FrontEndEvent)event).getControllerCalls());
        }
        CollectionUtils.filter(serviceCallsList, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                OperationFacade operation = (OperationFacade)object;
                return operation instanceof ServiceOperation;
            }
        });
        return serviceCallsList;
    }

    @Override
    protected List<OperationFacade> handleGetControllerCalls() {
        ArrayList<OperationFacade> controllerCallsList = new ArrayList<OperationFacade>();
        Collection<EventFacade> deferrableEvents = this.getDeferrableEvents();
        for (EventFacade event : deferrableEvents) {
            FrontEndControllerOperation callObject;
            if (event instanceof CallEventFacade) {
                OperationFacade operationObject = ((CallEventFacade)event).getOperation();
                if (operationObject == null) continue;
                controllerCallsList.add(operationObject);
                continue;
            }
            if (!(event instanceof FrontEndEvent) || (callObject = ((FrontEndEvent)event).getControllerCall()) == null) continue;
            controllerCallsList.add((OperationFacade)callObject);
        }
        CollectionUtils.filter(controllerCallsList, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                OperationFacade operation = (OperationFacade)object;
                return operation instanceof FrontEndControllerOperation;
            }
        });
        return controllerCallsList;
    }

    @Override
    protected List<FrontEndExceptionHandler> handleGetExceptions() {
        LinkedHashSet<FrontEndExceptionHandler> exceptions = new LinkedHashSet<FrontEndExceptionHandler>();
        Collection<TransitionFacade> outgoing = this.getOutgoings();
        for (TransitionFacade transition : outgoing) {
            if (!(transition instanceof FrontEndExceptionHandler)) continue;
            exceptions.add((FrontEndExceptionHandler)transition);
        }
        return new ArrayList<FrontEndExceptionHandler>(exceptions);
    }

    @Override
    protected List<FrontEndAction> handleGetContainerActions() {
        ActivityGraphFacade activityGraph;
        UseCaseFacade useCase;
        LinkedHashSet<FrontEndAction> actionSet = new LinkedHashSet<FrontEndAction>();
        StateMachineFacade stateMachineFacade = this.getStateMachine();
        if (stateMachineFacade instanceof ActivityGraphFacade && (useCase = (activityGraph = (ActivityGraphFacade)stateMachineFacade).getUseCase()) instanceof FrontEndUseCase) {
            List actions = ((FrontEndUseCase)useCase).getActions();
            for (FrontEndAction action : actions) {
                if (!action.getActionStates().contains((Object)this)) continue;
                actionSet.add(action);
            }
        }
        return new ArrayList<FrontEndAction>(actionSet);
    }
}

