/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.uml14;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.andromda.metafacades.uml.AssociationEndFacade;
import org.andromda.metafacades.uml.AttributeFacade;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.DependencyFacade;
import org.andromda.metafacades.uml.FilteredCollection;
import org.andromda.metafacades.uml.GeneralizableElementFacade;
import org.andromda.metafacades.uml.MetafacadeUtils;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.andromda.metafacades.uml.NameMasker;
import org.andromda.metafacades.uml.OperationFacade;
import org.andromda.metafacades.uml.TypeMappings;
import org.andromda.metafacades.uml.UMLMetafacadeUtils;
import org.andromda.metafacades.uml.UMLProfile;
import org.andromda.metafacades.uml14.ClassifierFacadeLogic;
import org.andromda.metafacades.uml14.UML14MetafacadeUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.omg.uml.foundation.core.Abstraction;
import org.omg.uml.foundation.core.AssociationClass;
import org.omg.uml.foundation.core.Attribute;
import org.omg.uml.foundation.core.Classifier;
import org.omg.uml.foundation.core.DataType;
import org.omg.uml.foundation.core.Interface;
import org.omg.uml.foundation.core.Namespace;
import org.omg.uml.foundation.core.Operation;

public class ClassifierFacadeLogicImpl
extends ClassifierFacadeLogic {
    private static final long serialVersionUID = 34L;
    private static final Logger logger = Logger.getLogger(ClassifierFacadeLogicImpl.class);

    public ClassifierFacadeLogicImpl(Classifier metaObject, String context) {
        super(metaObject, context);
    }

    @Override
    protected String handleGetName() {
        String nameMask = String.valueOf(this.getConfiguredProperty("classifierNameMask"));
        return NameMasker.mask((String)super.handleGetName(), (String)nameMask);
    }

    @Override
    protected List<Operation> handleGetOperations() {
        return new FilteredCollection(this.metaObject.getFeature()){
            private static final long serialVersionUID = 34L;

            public boolean evaluate(Object object) {
                return object instanceof Operation;
            }
        };
    }

    @Override
    protected Collection<Operation> handleGetImplementationOperations() {
        LinkedHashSet<Operation> operations = new LinkedHashSet<Operation>();
        operations.addAll((Collection<Operation>)new FilteredCollection(this.metaObject.getFeature()){
            private static final long serialVersionUID = 34L;

            public boolean evaluate(Object object) {
                return object instanceof Operation;
            }
        });
        if (!this.isInterface()) {
            Collection<ClassifierFacade> interfaces = this.getInterfaceAbstractions();
            for (ClassifierFacade interfaceElement : interfaces) {
                operations.addAll(ClassifierFacadeLogicImpl.resolveInterfaceOperationsRecursively(interfaceElement));
            }
        }
        return operations;
    }

    private static Collection<Operation> resolveInterfaceOperationsRecursively(ClassifierFacade interfaceClassifier) {
        LinkedHashSet<Operation> operations = new LinkedHashSet<Operation>(interfaceClassifier.getOperations());
        Collection generalizations = interfaceClassifier.getGeneralizations();
        for (ClassifierFacade parent : generalizations) {
            if (!parent.isInterface()) continue;
            operations.addAll(ClassifierFacadeLogicImpl.resolveInterfaceOperationsRecursively(parent));
        }
        return operations;
    }

    @Override
    protected List handleGetAssociationEnds() {
        ArrayList associationEnds;
        Collection participantAssociation = UML14MetafacadeUtils.getCorePackage().getAParticipantAssociation().getAssociation(this.metaObject);
        if (participantAssociation instanceof List) {
            associationEnds = (ArrayList)participantAssociation;
        } else {
            associationEnds = new ArrayList();
            associationEnds.addAll(participantAssociation);
        }
        return associationEnds;
    }

    protected Namespace getOwner() {
        return this.metaObject.getNamespace();
    }

    @Override
    protected boolean handleIsPrimitive() {
        return this.getWrapperMappings() != null && this.getWrapperMappings().getMappings().containsFrom(this.getFullyQualifiedName());
    }

    @Override
    protected boolean handleIsWrappedPrimitive() {
        return this.getWrapperMappings() != null && (this.getWrapperMappings().getMappings().containsTo(this.getFullyQualifiedName()) || this.getWrapperMappings().getMappings().containsTo(this.getName()));
    }

    @Override
    protected boolean handleIsArrayType() {
        return this.getFullyQualifiedName(true).endsWith(this.getArraySuffix());
    }

    @Override
    protected String handleGetWrapperName() {
        String wrapperName = null;
        if (this.getWrapperMappings() != null && this.getWrapperMappings().getMappings().containsFrom(this.getFullyQualifiedName())) {
            wrapperName = this.getWrapperMappings().getTo(this.getFullyQualifiedName());
        }
        return wrapperName;
    }

    protected TypeMappings getWrapperMappings() {
        String propertyName = "wrapperMappingsUri";
        Object property = this.getConfiguredProperty("wrapperMappingsUri");
        TypeMappings mappings = null;
        if (property instanceof String) {
            String uri = (String)property;
            try {
                mappings = TypeMappings.getInstance((String)uri);
                this.setProperty("wrapperMappingsUri", mappings);
            }
            catch (Throwable throwable) {
                String errMsg = "Error getting 'wrapperMappingsUri' --> '" + uri + '\'';
                logger.error((Object)errMsg, throwable);
            }
        } else {
            mappings = (TypeMappings)property;
        }
        return mappings;
    }

    @Override
    protected boolean handleIsCollectionType() {
        return UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.COLLECTION_TYPE_NAME);
    }

    @Override
    protected boolean handleIsListType() {
        return UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.LIST_TYPE_NAME);
    }

    @Override
    protected boolean handleIsSetType() {
        return UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.SET_TYPE_NAME);
    }

    @Override
    protected boolean handleIsBooleanType() {
        return UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.BOOLEAN_TYPE_NAME);
    }

    @Override
    protected boolean handleIsCharacterType() {
        String characterType = UMLProfile.CHARACTER_TYPE_NAME;
        String charType = characterType.substring(characterType.indexOf(58) + 1).substring(0, 4).toLowerCase();
        return UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)charType) || UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)characterType);
    }

    @Override
    protected boolean handleIsDateType() {
        return UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.DATE_TYPE_NAME);
    }

    @Override
    protected boolean handleIsDoubleType() {
        return UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.DOUBLE_TYPE_NAME);
    }

    @Override
    protected boolean handleIsFloatType() {
        return UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.FLOAT_TYPE_NAME);
    }

    @Override
    protected boolean handleIsIntegerType() {
        String integerType = UMLProfile.INTEGER_TYPE_NAME;
        String intType = integerType.substring(integerType.indexOf(58) + 1).substring(0, 3).toLowerCase();
        return UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)intType) || UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)integerType);
    }

    @Override
    protected boolean handleIsLongType() {
        return UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.LONG_TYPE_NAME);
    }

    @Override
    protected boolean handleIsTimeType() {
        return UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.TIME_TYPE_NAME);
    }

    @Override
    protected boolean handleIsFileType() {
        return UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.FILE_TYPE_NAME);
    }

    @Override
    protected boolean handleIsBlobType() {
        return UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.BLOB_TYPE_NAME);
    }

    @Override
    protected boolean handleIsClobType() {
        return UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.CLOB_TYPE_NAME);
    }

    @Override
    public boolean handleIsMapType() {
        return UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.MAP_TYPE_NAME);
    }

    @Override
    protected boolean handleIsStringType() {
        return "String".equals(this.getFullyQualifiedName()) || "java.lang.String".equals(this.getFullyQualifiedName()) || UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.STRING_TYPE_NAME);
    }

    @Override
    protected List<Attribute> handleGetAttributes() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(this.metaObject.getFeature());
        Iterator iterator = attributes.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof Attribute) continue;
            iterator.remove();
        }
        return attributes;
    }

    @Override
    protected List<AttributeFacade> handleGetAttributes(boolean follow) {
        ArrayList<AttributeFacade> attributes = new ArrayList<AttributeFacade>(this.getAttributes());
        for (ClassifierFacade superClass = (ClassifierFacade)this.getGeneralization(); superClass != null && follow; superClass = (ClassifierFacade)superClass.getGeneralization()) {
            for (AttributeFacade superAttribute : superClass.getAttributes()) {
                boolean present = false;
                for (AttributeFacade attribute : this.getAttributes()) {
                    if (!attribute.getName().equals(superAttribute.getName())) continue;
                    present = true;
                    break;
                }
                if (present) continue;
                attributes.add(superAttribute);
            }
        }
        return attributes;
    }

    @Override
    protected List handleGetProperties() {
        ArrayList<AttributeFacade> properties = new ArrayList<AttributeFacade>(this.getAttributes());
        properties.addAll(this.getNavigableConnectingEnds());
        return properties;
    }

    @Override
    public Collection handleGetAllProperties() {
        return this.getProperties(true);
    }

    @Override
    public Collection handleGetAllRequiredConstructorParameters() {
        ArrayList allRequiredConstructorParameters = new ArrayList();
        allRequiredConstructorParameters.addAll(this.getRequiredConstructorParameters());
        Collection<GeneralizableElementFacade> generalizations = this.getGeneralizations();
        for (GeneralizableElementFacade parent : generalizations) {
            if (!(parent instanceof ClassifierFacade)) continue;
            allRequiredConstructorParameters.addAll(((ClassifierFacade)parent).getAllRequiredConstructorParameters());
        }
        return allRequiredConstructorParameters;
    }

    @Override
    public Collection handleGetRequiredConstructorParameters() {
        ArrayList<Object> requiredConstructorParameters = new ArrayList<Object>();
        List properties = this.getProperties();
        for (Object property : properties) {
            AssociationEndFacade associationEnd;
            if (property instanceof AttributeFacade) {
                AttributeFacade attribute = (AttributeFacade)property;
                if (attribute.isDerived() || !attribute.isRequired() && !attribute.isReadOnly()) continue;
                requiredConstructorParameters.add(attribute);
                continue;
            }
            if (!(property instanceof AssociationEndFacade) || (associationEnd = (AssociationEndFacade)property).isDerived() || !associationEnd.isRequired() && !associationEnd.isReadOnly()) continue;
            requiredConstructorParameters.add(associationEnd);
        }
        return requiredConstructorParameters;
    }

    @Override
    protected List handleGetProperties(boolean follow) {
        ArrayList<Object> properties = new ArrayList<Object>(this.getAttributes(follow));
        properties.addAll(this.getNavigableConnectingEnds());
        if (follow) {
            for (ClassifierFacade superClass = (ClassifierFacade)this.getGeneralization(); superClass != null && follow; superClass = (ClassifierFacade)superClass.getGeneralization()) {
                for (AssociationEndFacade superAssociationEnd : superClass.getNavigableConnectingEnds()) {
                    boolean present = false;
                    for (AssociationEndFacade associationEnd : this.getAssociationEnds()) {
                        if (!associationEnd.getName().equals(superAssociationEnd.getName())) continue;
                        present = true;
                        break;
                    }
                    if (present) continue;
                    properties.add(superAssociationEnd);
                }
            }
        }
        return properties;
    }

    @Override
    protected String handleGetOperationCallFromAttributes() {
        StringBuilder call = new StringBuilder();
        String separator = "";
        call.append('(');
        for (AttributeFacade attribute : this.getAttributes()) {
            call.append(separator);
            String typeName = attribute.getType().getFullyQualifiedName();
            call.append(typeName);
            call.append(' ');
            call.append(attribute.getName());
            separator = ", ";
        }
        call.append(')');
        return call.toString();
    }

    @Override
    protected boolean handleIsAbstract() {
        return this.metaObject.isAbstract();
    }

    @Override
    protected Collection<AttributeFacade> handleGetStaticAttributes() {
        return new FilteredCollection(this.getAttributes()){
            private static final long serialVersionUID = 34L;

            public boolean evaluate(Object object) {
                return ((AttributeFacade)object).isStatic();
            }
        };
    }

    @Override
    protected Collection<ClassifierFacade> handleGetInterfaceAbstractions() {
        LinkedHashSet<ClassifierFacade> interfaceAbstractions = new LinkedHashSet<ClassifierFacade>();
        if (this.getAbstractions() != null) {
            for (DependencyFacade dependencyFacade : this.getAbstractions()) {
                ClassifierFacade classifier;
                ModelElementFacade element = dependencyFacade.getTargetElement();
                if (!(element instanceof ClassifierFacade) || !(classifier = (ClassifierFacade)element).isInterface()) continue;
                interfaceAbstractions.add(classifier);
            }
        }
        return interfaceAbstractions;
    }

    @Override
    protected String handleGetImplementedInterfaceList() {
        String interfaceList;
        Collection<ClassifierFacade> interfaces = this.getInterfaceAbstractions();
        if (interfaces.isEmpty()) {
            interfaceList = "";
        } else {
            StringBuilder list = new StringBuilder();
            Iterator<ClassifierFacade> iterator = interfaces.iterator();
            while (iterator.hasNext()) {
                ModelElementFacade element = (ModelElementFacade)iterator.next();
                list.append(element.getBindedFullyQualifiedName((ModelElementFacade)this));
                if (!iterator.hasNext()) continue;
                list.append(", ");
            }
            interfaceList = list.toString();
        }
        return interfaceList;
    }

    @Override
    protected Collection<AttributeFacade> handleGetInstanceAttributes() {
        return new FilteredCollection(this.getAttributes()){
            private static final long serialVersionUID = 34L;

            public boolean evaluate(Object object) {
                return !((AttributeFacade)object).isStatic();
            }
        };
    }

    @Override
    protected Collection<ClassifierFacade> handleGetAbstractions() {
        return new FilteredCollection(this.metaObject.getClientDependency()){
            private static final long serialVersionUID = 34L;

            public boolean evaluate(Object object) {
                return object instanceof Abstraction;
            }
        };
    }

    @Override
    protected boolean handleIsDataType() {
        return DataType.class.isAssignableFrom(this.metaObject.getClass());
    }

    @Override
    protected boolean handleIsInterface() {
        return Interface.class.isAssignableFrom(this.metaObject.getClass());
    }

    protected ClassifierFacade handleGetNonArray() {
        ClassifierFacade nonArrayType = (ClassifierFacade)this.THIS();
        if (this.getFullyQualifiedName().contains(this.getArraySuffix())) {
            nonArrayType = (ClassifierFacade)this.getRootPackage().findModelElement(StringUtils.replace((String)this.getFullyQualifiedName(true), (String)this.getArraySuffix(), (String)""));
        }
        return nonArrayType;
    }

    protected ClassifierFacade handleGetArray() {
        ClassifierFacade arrayType = (ClassifierFacade)this.THIS();
        String name = this.getFullyQualifiedName(true);
        if (!name.contains(this.getArraySuffix())) {
            name = name + this.getArraySuffix();
            arrayType = (ClassifierFacade)this.getRootPackage().findModelElement(name);
        }
        return arrayType;
    }

    @Override
    protected boolean handleIsEnumeration() {
        return this.hasStereotype(UMLProfile.STEREOTYPE_ENUMERATION);
    }

    @Override
    protected String handleGetJavaNewString() {
        String javaNewString = this.isPrimitive() ? (UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.BOOLEAN_TYPE_NAME) ? "false" : "0") : (this.isWrappedPrimitive() ? (UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.BOOLEAN_TYPE_NAME) ? "Boolean.FALSE" : this.getFullyQualifiedName() + ".valueOf(0)") : "new " + this.getFullyQualifiedName() + "()");
        return javaNewString;
    }

    @Override
    protected String handleGetJavaNullString() {
        String javaNullString = this.isPrimitive() ? (UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.BOOLEAN_TYPE_NAME) ? "false" : "0") : "null";
        return javaNullString;
    }

    @Override
    protected List<OperationFacade> handleGetStaticOperations() {
        return new FilteredCollection(this.getOperations()){
            private static final long serialVersionUID = 34L;

            public boolean evaluate(Object object) {
                return ((OperationFacade)object).isStatic();
            }
        };
    }

    @Override
    protected List<OperationFacade> handleGetInstanceOperations() {
        return new FilteredCollection(this.getOperations()){
            private static final long serialVersionUID = 34L;

            public boolean evaluate(Object object) {
                return !((OperationFacade)object).isStatic();
            }
        };
    }

    @Override
    protected AttributeFacade handleFindAttribute(final String name) {
        return (AttributeFacade)CollectionUtils.find((Collection)this.getAttributes(true), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                AttributeFacade attribute = (AttributeFacade)object;
                return StringUtils.trimToEmpty((String)attribute.getName()).equals(name);
            }
        });
    }

    @Override
    protected String handleGetArrayName() {
        return this.getName() + this.getArraySuffix();
    }

    @Override
    protected String handleGetFullyQualifiedArrayName() {
        return this.getFullyQualifiedName() + this.getArraySuffix();
    }

    @Override
    protected long handleGetSerialVersionUID() {
        String serialVersionString = UML14MetafacadeUtils.getSerialVersionUID(this);
        long serialVersionUID = serialVersionString != null ? Long.parseLong(serialVersionString) : MetafacadeUtils.calculateDefaultSUID((ClassifierFacade)this);
        return serialVersionUID;
    }

    @Override
    protected Collection handleGetNavigableConnectingEnds() {
        ArrayList<AssociationEndFacade> connectingEnds = new ArrayList<AssociationEndFacade>(this.getAssociationEnds());
        CollectionUtils.transform(connectingEnds, (Transformer)new Transformer(){

            public AssociationEndFacade transform(Object object) {
                return ((AssociationEndFacade)object).getOtherEnd();
            }
        });
        CollectionUtils.filter(connectingEnds, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return ((AssociationEndFacade)object).isNavigable();
            }
        });
        return connectingEnds;
    }

    @Override
    protected List<AssociationEndFacade> handleGetNavigableConnectingEnds(boolean follow) {
        ArrayList<ClassifierFacade> connectionEnds = new ArrayList<ClassifierFacade>(this.getNavigableConnectingEnds());
        for (ClassifierFacade superClass = (ClassifierFacade)this.getGeneralization(); superClass != null && follow; superClass = (ClassifierFacade)superClass.getGeneralization()) {
            for (AssociationEndFacade superAssociationEnd : superClass.getNavigableConnectingEnds()) {
                boolean present = false;
                for (AssociationEndFacade associationEnd : this.getAssociationEnds()) {
                    if (!associationEnd.getName().equals(superAssociationEnd.getName())) continue;
                    present = true;
                    break;
                }
                if (present) continue;
                connectionEnds.add((ClassifierFacade)superAssociationEnd);
            }
        }
        return connectionEnds;
    }

    @Override
    protected boolean handleIsLeaf() {
        return this.metaObject.isLeaf();
    }

    @Override
    protected boolean handleIsAssociationClass() {
        return AssociationClass.class.isAssignableFrom(this.metaObject.getClass());
    }

    @Override
    protected Collection<ClassifierFacade> handleGetAssociatedClasses() {
        LinkedHashSet<ClassifierFacade> associatedClasses = new LinkedHashSet<ClassifierFacade>();
        List<AssociationEndFacade> associationEnds = this.getAssociationEnds();
        for (int i = 0; i < associationEnds.size(); ++i) {
            AssociationEndFacade associationEndFacade = associationEnds.get(i);
            associatedClasses.add(associationEndFacade.getOtherEnd().getType());
        }
        return associatedClasses;
    }

    @Override
    protected Collection<ClassifierFacade> handleGetAllAssociatedClasses() {
        LinkedHashSet<ClassifierFacade> associatedClasses = new LinkedHashSet<ClassifierFacade>();
        associatedClasses.addAll(this.getAssociatedClasses());
        for (ClassifierFacade classifierFacade : this.getGeneralizations()) {
            associatedClasses.addAll(classifierFacade.getAllAssociatedClasses());
        }
        return associatedClasses;
    }

    protected ClassifierFacade handleGetSuperClass() {
        GeneralizableElementFacade superClass = this.getGeneralization();
        return (ClassifierFacade)(superClass instanceof ClassifierFacade ? superClass : null);
    }

    @Override
    protected boolean handleIsEmbeddedValue() {
        return this.hasStereotype(UMLProfile.STEREOTYPE_EMBEDDED_VALUE);
    }
}

