/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.spring;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.andromda.cartridges.spring.metafacades.SpringService;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.andromda.metafacades.uml.Role;
import org.andromda.metafacades.uml.Service;
import org.andromda.utils.StringUtilsHelper;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;

public class SpringUtils {
    private boolean richClient = false;
    private static final SimpleDateFormat DF = new SimpleDateFormat("MM/dd/yyyy HH:mm:ssZ");

    public Collection<Role> getAllRoles(Collection<Service> services) {
        final LinkedHashSet<Role> allRoles = new LinkedHashSet<Role>();
        CollectionUtils.forAllDo(services, (Closure)new Closure(){

            public void execute(Object object) {
                if (object != null && Service.class.isAssignableFrom(object.getClass())) {
                    allRoles.addAll(((Service)object).getAllRoles());
                }
            }
        });
        return allRoles;
    }

    public boolean remoteEjbsPresent(Collection<Service> services) {
        boolean present;
        boolean bl = present = services != null && !services.isEmpty();
        if (present) {
            present = CollectionUtils.find(services, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    boolean valid = false;
                    if (object instanceof SpringService) {
                        SpringService service = (SpringService)object;
                        valid = service.isEjbRemoteView();
                    }
                    return valid;
                }
            }) != null;
        }
        return present;
    }

    public boolean localEjbsPresent(Collection<Service> services) {
        boolean present;
        boolean bl = present = services != null && !services.isEmpty();
        if (present) {
            present = CollectionUtils.find(services, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    boolean valid = false;
                    if (object instanceof SpringService) {
                        SpringService service = (SpringService)object;
                        valid = service.isEjbLocalView();
                    }
                    return valid;
                }
            }) != null;
        }
        return present;
    }

    public boolean remotableServicesPresent(Collection<Service> services) {
        boolean present;
        boolean bl = present = services != null && !services.isEmpty();
        if (present) {
            present = CollectionUtils.find(services, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    boolean valid = false;
                    if (object instanceof SpringService) {
                        SpringService service = (SpringService)object;
                        valid = service.isRemotable();
                    }
                    return valid;
                }
            }) != null;
        }
        return present;
    }

    public boolean lingoRemotableServicesPresent(Collection<Service> services) {
        boolean present;
        boolean bl = present = services != null && !services.isEmpty();
        if (present) {
            present = CollectionUtils.find(services, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    boolean valid = false;
                    if (object instanceof SpringService) {
                        SpringService service = (SpringService)object;
                        valid = service.isRemotingTypeLingo();
                    }
                    return valid;
                }
            }) != null;
        }
        return present;
    }

    public boolean privateServicesPresent(Collection<Service> services) {
        boolean present;
        boolean bl = present = services != null && !services.isEmpty();
        if (present) {
            present = CollectionUtils.find(services, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    boolean valid = false;
                    if (object instanceof SpringService) {
                        SpringService service = (SpringService)object;
                        valid = service.isPrivate();
                    }
                    return valid;
                }
            }) != null;
        }
        return present;
    }

    public boolean publicServicesPresent(Collection<Service> services) {
        boolean present;
        boolean bl = present = services != null && !services.isEmpty();
        if (present) {
            present = CollectionUtils.find(services, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    boolean valid = false;
                    if (object instanceof SpringService) {
                        SpringService service = (SpringService)object;
                        valid = !service.isPrivate();
                    }
                    return valid;
                }
            }) != null;
        }
        return present;
    }

    public String getSpringPropertyValue(String value) {
        String propertyValue = "";
        if (value != null) {
            propertyValue = "null".equalsIgnoreCase(value) ? "<null/>" : "<value>" + value + "</value>";
        }
        return propertyValue;
    }

    public String removeGenerics(String parameter) {
        int position = parameter.indexOf(60);
        String result = parameter;
        if (position != -1) {
            result = result.substring(0, position);
        }
        return result;
    }

    public void setRichClient(boolean richClientProperty) {
        this.richClient = richClientProperty;
    }

    public boolean isRichClient() {
        return this.richClient;
    }

    public String getClassName(String fullyQualifiedName) {
        int lastDot;
        String className = null;
        className = StringUtils.isNotBlank((String)fullyQualifiedName) ? ((lastDot = fullyQualifiedName.lastIndexOf(46)) >= 0 ? fullyQualifiedName.substring(lastDot + 1) : fullyQualifiedName) : "";
        return className;
    }

    public String getPackageName(String fullyQualifiedName) {
        int lastDot;
        String packageName = null;
        packageName = StringUtils.isNotBlank((String)fullyQualifiedName) ? ((lastDot = fullyQualifiedName.lastIndexOf(46)) >= 0 ? fullyQualifiedName.substring(0, lastDot) : "") : "";
        return packageName;
    }

    public List<ModelElementFacade> filterUniqueByName(Collection<ModelElementFacade> modelElements) {
        LinkedHashMap<String, ModelElementFacade> filteredElements = new LinkedHashMap<String, ModelElementFacade>();
        for (ModelElementFacade modelElement : modelElements) {
            if (filteredElements.containsKey(modelElement.getName())) continue;
            filteredElements.put(modelElement.getName(), modelElement);
        }
        return new ArrayList<ModelElementFacade>(filteredElements.values());
    }

    public String formatHibernateQueryParameterValue(ClassifierFacade type, String value) {
        if (type != null && type.isPrimitive()) {
            value = "new " + type.getWrapperName() + '(' + value + ')';
        }
        return value;
    }

    public static String concatNamesCamelCase(Collection<String> names) {
        String result = null;
        if (names != null) {
            result = StringUtilsHelper.lowerCamelCaseName((String)StringUtils.join(names.iterator(), (String)" "));
        }
        return result;
    }

    public static String getFullyQualifiedClassName(String packageName, String name) {
        StringBuilder fullName = new StringBuilder(StringUtils.trimToEmpty((String)packageName));
        if (fullName.length() > 0) {
            fullName.append('.');
        }
        fullName.append(name);
        return fullName.toString();
    }

    public static String getDate(String format) {
        return DF.format(new Date());
    }

    public static String getDate() {
        return DF.format(new Date());
    }
}

