/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.ui.gaderian;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.ImageIcon;
import nu.zoom.ui.Resources;

public class ResourcesImpl
implements Resources {
    ArrayList<Properties> props = null;

    @Override
    public synchronized String getMessage(String key) throws Resources.ResourceNotFoundException {
        try {
            if (!this.containsMessage(key)) {
                throw new Resources.ResourceNotFoundException("Unable to find a string for key: " + key);
            }
        }
        catch (IOException e) {
            throw new Resources.ResourceNotFoundException(e);
        }
        for (Properties properties : this.props) {
            Object object = properties.get(key);
            if (object == null) continue;
            return (String)object;
        }
        return null;
    }

    @Override
    public synchronized String format(String key, Object ... args) throws Resources.ResourceNotFoundException {
        try {
            if (!this.containsMessage(key)) {
                throw new Resources.ResourceNotFoundException("Unable to find a string for key: " + key);
            }
        }
        catch (IOException e) {
            throw new Resources.ResourceNotFoundException(e);
        }
        String template = this.getMessage(key);
        return String.format(template, args);
    }

    private synchronized boolean containsMessage(String key) throws IOException {
        if (this.props == null) {
            this.findResources();
        }
        for (Properties properties : this.props) {
            Object object = properties.get(key);
            if (object == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized ImageIcon getIcon(String key) throws Resources.ResourceNotFoundException {
        String resourceName = this.getMessage(key);
        URL url = this.getClass().getResource(resourceName);
        ImageIcon icon = null;
        if (url != null && (icon = new ImageIcon(url)) != null) {
            return icon;
        }
        throw new Resources.ResourceNotFoundException("Unable to load Icon resource: " + key);
    }

    private synchronized void findResources() throws IOException {
        this.props = new ArrayList();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> resources = contextClassLoader.getResources("META-INF/org/ops4j/gaderian/module.properties");
        while (resources.hasMoreElements()) {
            URL resourceURL = resources.nextElement();
            Properties p = new Properties();
            p.load(resourceURL.openStream());
            this.props.add(p);
        }
    }
}

