/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.utils;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

public final class InetUtils {
    public static String findInterfaceAddress(String interfaceName) {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces != null) {
                while (interfaces.hasMoreElements()) {
                    NetworkInterface iface = interfaces.nextElement();
                    if (!iface.getName().equals(interfaceName)) continue;
                    Enumeration<InetAddress> addresses = iface.getInetAddresses();
                    if (!addresses.hasMoreElements()) {
                        throw new IllegalArgumentException("Network interface " + interfaceName + " has no attached address");
                    }
                    InetAddress address = addresses.nextElement();
                    return address.getHostAddress();
                }
            }
            throw new IllegalArgumentException("No network interface with that name : " + interfaceName);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot find interface address : " + e);
        }
    }

    public static String resolveAutoInterfaceAddress(String address) {
        if (address == null) {
            return null;
        }
        if (address.startsWith("auto:")) {
            return InetUtils.findInterfaceAddress(address.substring(5));
        }
        return address;
    }
}

