/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.listeners.tcp.nio;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import javax.jms.JMSException;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.jmx.JMXAgent;
import net.timewalker.ffmq4.listeners.ClientProcessor;
import net.timewalker.ffmq4.listeners.tcp.AbstractTcpClientListener;
import net.timewalker.ffmq4.listeners.tcp.nio.NIOTcpListenerMBean;
import net.timewalker.ffmq4.local.FFMQEngine;
import net.timewalker.ffmq4.transport.PacketTransport;
import net.timewalker.ffmq4.transport.PacketTransportException;
import net.timewalker.ffmq4.transport.tcp.nio.NIOClientSocketHandler;
import net.timewalker.ffmq4.transport.tcp.nio.NIOServerSocketHandler;
import net.timewalker.ffmq4.transport.tcp.nio.NIOTcpMultiplexer;
import net.timewalker.ffmq4.transport.tcp.nio.NIOTcpPacketTransport;
import net.timewalker.ffmq4.utils.Settings;
import net.timewalker.ffmq4.utils.id.UUIDProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class NIOTcpListener
extends AbstractTcpClientListener
implements NIOServerSocketHandler,
NIOTcpListenerMBean {
    private static final Log log = LogFactory.getLog(NIOTcpListener.class);
    private ServerSocketChannel serverSocketChannel;
    private NIOTcpMultiplexer multiplexer;

    public NIOTcpListener(FFMQEngine engine, String listenAddr, int listenPort, Settings settings) {
        this(engine, listenAddr, listenPort, settings, null);
    }

    public NIOTcpListener(FFMQEngine engine, String listenAddr, int listenPort, Settings settings, JMXAgent jmxAgent) {
        super(engine, settings, jmxAgent, listenAddr, listenPort);
    }

    @Override
    public String getName() {
        return "tcpnio-" + this.listenAddr + "-" + this.listenPort;
    }

    private void initServerSocket() throws JMSException {
        try {
            this.serverSocketChannel = ServerSocketChannel.open();
            this.serverSocketChannel.configureBlocking(false);
            this.serverSocketChannel.socket().setReuseAddress(true);
            int tcpBackLog = this.settings.getIntProperty("listener.tcp.backLog", 50);
            InetAddress bindAddress = this.getBindAddress();
            InetSocketAddress isa = new InetSocketAddress(bindAddress, this.listenPort);
            this.serverSocketChannel.socket().bind(isa, tcpBackLog);
        }
        catch (Exception e) {
            throw new FFMQException("Could not configure server socket", "NETWORK_ERROR", (Throwable)e);
        }
    }

    @Override
    public synchronized void start() throws JMSException {
        if (this.started) {
            return;
        }
        log.info((Object)(" Starting listener [" + this.getName() + "]"));
        this.initServerSocket();
        this.multiplexer = new NIOTcpMultiplexer(this.settings, false);
        this.multiplexer.registerServerSocketHandler((NIOServerSocketHandler)this);
        this.started = true;
    }

    @Override
    public void stop() {
        if (!this.started) {
            return;
        }
        log.info((Object)("Stopping listener [" + this.getName() + "]"));
        this.multiplexer.unregisterServerSocketHandler((NIOServerSocketHandler)this);
        this.multiplexer.stop();
        this.multiplexer = null;
        this.closeRemainingClients();
        this.started = false;
    }

    public NIOClientSocketHandler createClientHandler(NIOTcpMultiplexer multiplexer, SocketChannel socketChannel) {
        try {
            String clientId = UUIDProvider.getInstance().getShortUUID();
            NIOTcpPacketTransport transport = new NIOTcpPacketTransport(clientId, multiplexer, socketChannel, this.settings);
            ClientProcessor clientProcessor = new ClientProcessor(clientId, this, this.localEngine, (PacketTransport)transport);
            this.registerClient(clientProcessor);
            clientProcessor.start();
            return transport;
        }
        catch (PacketTransportException e) {
            log.error((Object)"Cannot create client processor", (Throwable)e);
            return null;
        }
    }

    public ServerSocketChannel getServerSocketChannel() {
        return this.serverSocketChannel;
    }
}

