/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import java.io.Closeable;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.BytesStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractReference
implements Byteable,
Closeable {
    @Nullable
    protected BytesStore bytes;
    protected long offset;

    public void bytesStore(@NotNull BytesStore bytes, long offset, long length) throws IllegalStateException, IllegalArgumentException, BufferOverflowException, BufferUnderflowException {
        this.acceptNewBytesStore(bytes);
        this.offset = offset;
    }

    @Nullable
    public BytesStore bytesStore() {
        return this.bytes;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public abstract long maxSize();

    protected void acceptNewBytesStore(@NotNull BytesStore bytes) {
        if (this.bytes != null) {
            this.bytes.release();
        }
        this.bytes = bytes.bytesStore();
        this.bytes.reserve();
    }

    @Override
    public void close() {
        if (this.bytes != null) {
            this.bytes.release();
            this.bytes = null;
        }
    }

    public long address() {
        return this.bytesStore().addressForRead(this.offset);
    }
}

