/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.config;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.devh.boot.grpc.client.config.GrpcChannelProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="grpc")
public class GrpcChannelsProperties {
    public static final String GLOBAL_PROPERTIES_KEY = "GLOBAL";
    private final Map<String, GrpcChannelProperties> client = new ConcurrentHashMap<String, GrpcChannelProperties>();
    private String defaultScheme;

    public final Map<String, GrpcChannelProperties> getClient() {
        return this.client;
    }

    public GrpcChannelProperties getChannel(String name) {
        GrpcChannelProperties properties = this.getRawChannel(name);
        properties.copyDefaultsFrom(this.getGlobalChannel());
        return properties;
    }

    public final GrpcChannelProperties getGlobalChannel() {
        return this.getRawChannel(GLOBAL_PROPERTIES_KEY);
    }

    private GrpcChannelProperties getRawChannel(String name) {
        return this.client.computeIfAbsent(name, key -> new GrpcChannelProperties());
    }

    public String getDefaultScheme() {
        return this.defaultScheme;
    }

    public void setDefaultScheme(String defaultScheme) {
        this.defaultScheme = defaultScheme;
    }

    public String toString() {
        return "GrpcChannelsProperties(client=" + this.getClient() + ", defaultScheme=" + this.getDefaultScheme() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GrpcChannelsProperties)) {
            return false;
        }
        GrpcChannelsProperties other = (GrpcChannelsProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, GrpcChannelProperties> this$client = this.getClient();
        Map<String, GrpcChannelProperties> other$client = other.getClient();
        if (this$client == null ? other$client != null : !((Object)this$client).equals(other$client)) {
            return false;
        }
        String this$defaultScheme = this.getDefaultScheme();
        String other$defaultScheme = other.getDefaultScheme();
        return !(this$defaultScheme == null ? other$defaultScheme != null : !this$defaultScheme.equals(other$defaultScheme));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GrpcChannelsProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, GrpcChannelProperties> $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : ((Object)$client).hashCode());
        String $defaultScheme = this.getDefaultScheme();
        result = result * 59 + ($defaultScheme == null ? 43 : $defaultScheme.hashCode());
        return result;
    }
}

