/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.stringparsers.IntegerStringParser;
import com.martiansoftware.jsap.stringparsers.StringStringParser;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestParser
extends TestCase {
    public static Test suite() {
        return new TestSuite(TestParser.class);
    }

    public void testMultipleDeclarations() {
        FlaggedOption flaggedOption = new FlaggedOption("flagged");
        flaggedOption.setShortFlag('f');
        flaggedOption.setLongFlag("longflag");
        JSAP jSAP = new JSAP();
        try {
            jSAP.registerParameter(flaggedOption);
        }
        catch (Exception exception) {
            TestParser.fail((String)exception.getMessage());
        }
        String[] stringArray = new String[]{"-f", "testone"};
        JSAPResult jSAPResult = null;
        try {
            jSAPResult = jSAP.parse(stringArray);
        }
        catch (Exception exception) {
            TestParser.fail((String)exception.getMessage());
        }
        TestParser.assertEquals((String)"testone", (String)((String)jSAPResult.getObject("flagged")));
        String[] stringArray2 = new String[]{"-f", "testone", "-f", "testtwo"};
        jSAPResult = jSAP.parse(stringArray2);
        TestParser.assertEquals((boolean)false, (boolean)jSAPResult.success());
        jSAP.unregisterParameter(flaggedOption);
        flaggedOption.setAllowMultipleDeclarations(true);
        try {
            jSAP.registerParameter(flaggedOption);
        }
        catch (Exception exception) {
            TestParser.fail((String)exception.getMessage());
        }
        try {
            jSAPResult = jSAP.parse(stringArray2);
        }
        catch (Exception exception) {
            TestParser.fail((String)exception.getMessage());
        }
        String[] stringArray3 = (String[])jSAPResult.getObjectArray("flagged", new String[0]);
        TestParser.assertEquals((int)2, (int)stringArray3.length);
        TestParser.assertEquals((String)"testone", (String)stringArray3[0]);
        TestParser.assertEquals((String)"testtwo", (String)stringArray3[1]);
    }

    public void testParser() {
        FlaggedOption flaggedOption = new FlaggedOption("flagged");
        flaggedOption.setShortFlag('f');
        flaggedOption.setLongFlag("longflag");
        flaggedOption.setStringParser(StringStringParser.getParser());
        JSAP jSAP = new JSAP();
        FlaggedOption flaggedOption2 = new FlaggedOption("flaggedInteger");
        flaggedOption2.setLongFlag("integer");
        flaggedOption2.setStringParser(IntegerStringParser.getParser());
        try {
            jSAP.registerParameter(flaggedOption);
            jSAP.registerParameter(flaggedOption2);
        }
        catch (JSAPException jSAPException) {
            TestParser.fail((String)jSAPException.getMessage());
        }
        String[] stringArray = new String[]{"-f", "myflagthing", "--integer", "42"};
        JSAPResult jSAPResult = null;
        try {
            jSAPResult = jSAP.parse(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            TestParser.fail((String)exception.getMessage());
        }
        TestParser.assertEquals((String)"myflagthing", (String)((String)jSAPResult.getObject("flagged")));
        TestParser.assertEquals((int)42, (int)((Integer)jSAPResult.getObject("flaggedInteger")));
    }
}

