/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestJSAPConfiguration
extends TestCase {
    public static Test suite() {
        return new TestSuite(TestJSAPConfiguration.class);
    }

    public void testConfigurationGymnastics() {
        JSAP jSAP = new JSAP();
        FlaggedOption flaggedOption = new FlaggedOption("testOption");
        try {
            jSAP.registerParameter(flaggedOption);
            TestJSAPConfiguration.fail((String)"Successfully registered a FlaggedOption with no flags!");
        }
        catch (JSAPException jSAPException) {
            // empty catch block
        }
        flaggedOption.setShortFlag('t');
        flaggedOption.setLongFlag("test");
        try {
            jSAP.registerParameter(flaggedOption);
        }
        catch (JSAPException jSAPException) {
            TestJSAPConfiguration.fail((String)jSAPException.getMessage());
        }
        try {
            flaggedOption.setRequired(true);
            TestJSAPConfiguration.fail((String)"locked option was changed!");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            jSAP.registerParameter(flaggedOption);
            TestJSAPConfiguration.fail((String)"Registered the same option ID twice.");
        }
        catch (JSAPException jSAPException) {
            // empty catch block
        }
        FlaggedOption flaggedOption2 = new FlaggedOption("test2");
        flaggedOption2.setShortFlag('2');
        try {
            jSAP.registerParameter(flaggedOption2);
        }
        catch (JSAPException jSAPException) {
            TestJSAPConfiguration.fail((String)jSAPException.getMessage());
        }
        FlaggedOption flaggedOption3 = new FlaggedOption("test3");
        flaggedOption3.setShortFlag('2');
        try {
            jSAP.registerParameter(flaggedOption3);
            TestJSAPConfiguration.fail((String)"Registered the same short flag twice.");
        }
        catch (JSAPException jSAPException) {
            // empty catch block
        }
        FlaggedOption flaggedOption4 = (FlaggedOption)jSAP.getByShortFlag('2');
        TestJSAPConfiguration.assertEquals((Object)flaggedOption2, (Object)flaggedOption4);
        FlaggedOption flaggedOption5 = (FlaggedOption)jSAP.getByLongFlag("test");
        TestJSAPConfiguration.assertEquals((Object)flaggedOption, (Object)flaggedOption5);
        FlaggedOption flaggedOption6 = (FlaggedOption)jSAP.getByLongFlag("nosuchflag");
        TestJSAPConfiguration.assertNull((Object)flaggedOption6);
        jSAP.unregisterParameter(flaggedOption);
        try {
            flaggedOption.setRequired(true);
        }
        catch (Exception exception) {
            TestJSAPConfiguration.fail((String)"Unable to modify unlocked option.");
        }
        flaggedOption5 = (FlaggedOption)jSAP.getByLongFlag("test");
        TestJSAPConfiguration.assertNull((Object)flaggedOption5);
        try {
            jSAP.registerParameter(flaggedOption);
        }
        catch (Exception exception) {
            TestJSAPConfiguration.fail((String)"Unable to register arg that was previously unregistered.");
        }
    }
}

