/*
 * Copyright (C) 2002-2021, Martian Software, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 */

package com.martiansoftware.jsap.stringparsers;

import junit.framework.Test;
import junit.framework.TestSuite;

/**
 * Contains all of the tests in the stringparsers package.
 *
 * @author <a href="http://www.martiansoftware.com/contact.html">Marty Lamb</a>
 */
public class TestAll {

    /**
     * Returns a suite of all tests in the stringparsers package.
     * @return a suite of all tests in the stringparsers package.
     */
    public static Test suite() {
        TestSuite suite =
            new TestSuite("Test for com.martiansoftware.jsap.stringparsers");
        suite.addTest(new TestSuite(TestColorStringParser.class));
        suite.addTest(new TestSuite(TestLongStringParser.class));
        return suite;
    }
}
