/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.UndertowLogger;
import io.undertow.server.Connectors;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.UndertowServletLogger;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ExceptionHandler;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.LoggingExceptionHandler;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletDispatcher;
import io.undertow.servlet.handlers.ServletDebugPageHandler;
import io.undertow.servlet.handlers.ServletPathMatch;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.HttpServletResponseImpl;
import io.undertow.servlet.spec.SecurityActions;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.servlet.util.DispatchUtils;
import io.undertow.util.CanonicalPathUtils;
import io.undertow.util.Headers;
import io.undertow.util.ParameterLimitException;
import io.undertow.util.SameThreadExecutor;
import io.undertow.util.WorkerUtils;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.xnio.IoUtils;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;

public class AsyncContextImpl
implements AsyncContext {
    private final List<BoundAsyncListener> asyncListeners = new CopyOnWriteArrayList<BoundAsyncListener>();
    private final HttpServerExchange exchange;
    private final ServletRequest servletRequest;
    private final ServletResponse servletResponse;
    private final TimeoutTask timeoutTask = new TimeoutTask();
    private final ServletRequestContext servletRequestContext;
    private final boolean requestSupplied;
    private AsyncContextImpl previousAsyncContext;
    private volatile long timeout = 30000L;
    private volatile XnioExecutor.Key timeoutKey;
    private boolean dispatched;
    private boolean initialRequestDone;
    private Thread initiatingThread;
    private final Deque<Runnable> asyncTaskQueue = new ArrayDeque<Runnable>();
    private boolean processingAsyncTask = false;
    private volatile boolean complete = false;
    private volatile boolean completedBeforeInitialRequestDone = false;

    public AsyncContextImpl(final HttpServerExchange exchange, ServletRequest servletRequest, ServletResponse servletResponse, ServletRequestContext servletRequestContext, boolean requestSupplied, AsyncContextImpl previousAsyncContext) {
        this.exchange = exchange;
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
        this.servletRequestContext = servletRequestContext;
        this.requestSupplied = requestSupplied;
        this.previousAsyncContext = previousAsyncContext;
        this.initiatingThread = Thread.currentThread();
        exchange.dispatch(SameThreadExecutor.INSTANCE, new Runnable(){

            @Override
            public void run() {
                exchange.setDispatchExecutor(null);
                AsyncContextImpl.this.initialRequestDone();
            }
        });
    }

    public void updateTimeout() {
        XnioExecutor.Key key = this.timeoutKey;
        if (key != null) {
            if (!key.remove()) {
                return;
            }
            this.timeoutKey = null;
        }
        if (this.timeout > 0L && !this.complete) {
            this.timeoutKey = WorkerUtils.executeAfter((XnioIoThread)this.exchange.getIoThread(), (Runnable)this.timeoutTask, (long)this.timeout, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    public ServletRequest getRequest() {
        return this.servletRequest;
    }

    public ServletResponse getResponse() {
        return this.servletResponse;
    }

    public boolean hasOriginalRequestAndResponse() {
        return this.servletRequest instanceof HttpServletRequestImpl && this.servletResponse instanceof HttpServletResponseImpl;
    }

    public boolean isInitialRequestDone() {
        return this.initialRequestDone;
    }

    public void dispatch() {
        if (this.dispatched) {
            throw UndertowServletMessages.MESSAGES.asyncRequestAlreadyDispatched();
        }
        HttpServletRequestImpl requestImpl = this.servletRequestContext.getOriginalRequest();
        Deployment deployment = requestImpl.getServletContext().getDeployment();
        if (this.requestSupplied && this.servletRequest instanceof HttpServletRequest) {
            String requestURI;
            ServletContainer container = deployment.getServletContainer();
            DeploymentManager context = container.getDeploymentByPath(requestURI = ((HttpServletRequest)this.servletRequest).getRequestURI());
            if (context == null) {
                throw UndertowServletMessages.MESSAGES.couldNotFindContextToDispatchTo(requestImpl.getOriginalContextPath());
            }
            Object toDispatch = requestURI.substring(context.getDeployment().getServletContext().getContextPath().length());
            String qs = ((HttpServletRequest)this.servletRequest).getQueryString();
            if (qs != null && !qs.isEmpty()) {
                toDispatch = (String)toDispatch + "?" + qs;
            }
            this.dispatch(context.getDeployment().getServletContext(), (String)toDispatch);
        } else {
            ServletContainer container = deployment.getServletContainer();
            DeploymentManager context = container.getDeploymentByPath(requestImpl.getOriginalContextPath());
            if (context == null) {
                throw UndertowServletMessages.MESSAGES.couldNotFindContextToDispatchTo(requestImpl.getOriginalContextPath());
            }
            Object toDispatch = CanonicalPathUtils.canonicalize((String)requestImpl.getOriginalRequestURI()).substring(requestImpl.getOriginalContextPath().length());
            String qs = requestImpl.getOriginalQueryString();
            if (qs != null && !qs.isEmpty()) {
                toDispatch = (String)toDispatch + "?" + qs;
            }
            this.dispatch(context.getDeployment().getServletContext(), (String)toDispatch);
        }
    }

    private void dispatchAsyncRequest(final ServletDispatcher servletDispatcher, final ServletPathMatch pathInfo, final HttpServerExchange exchange) {
        this.doDispatch(new Runnable(){

            @Override
            public void run() {
                Connectors.executeRootHandler((HttpHandler)new HttpHandler(){

                    public void handleRequest(HttpServerExchange exchange) throws Exception {
                        ServletRequestContext src = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                        src.setServletRequest(AsyncContextImpl.this.servletRequest);
                        src.setServletResponse(AsyncContextImpl.this.servletResponse);
                        servletDispatcher.dispatchToPath(exchange, pathInfo, DispatcherType.ASYNC);
                    }
                }, (HttpServerExchange)exchange);
            }
        });
    }

    public void dispatch(String path) {
        this.dispatch(this.servletRequest.getServletContext(), path);
    }

    public void dispatch(ServletContext context, String path) {
        ServletPathMatch info;
        if (this.dispatched) {
            throw UndertowServletMessages.MESSAGES.asyncRequestAlreadyDispatched();
        }
        HttpServletRequestImpl requestImpl = this.servletRequestContext.getOriginalRequest();
        HttpServletResponseImpl responseImpl = this.servletRequestContext.getOriginalResponse();
        try {
            info = DispatchUtils.dispatchAsync(path, requestImpl, responseImpl, (ServletContextImpl)context);
        }
        catch (ParameterLimitException e) {
            throw new IllegalStateException(e);
        }
        Deployment deployment = requestImpl.getServletContext().getDeployment();
        this.dispatchAsyncRequest(deployment.getServletDispatcher(), info, this.exchange);
    }

    public synchronized void complete() {
        if (this.complete) {
            UndertowLogger.REQUEST_LOGGER.trace((Object)"Ignoring call to AsyncContext.complete() as it has already been called");
            return;
        }
        this.complete = true;
        if (this.timeoutKey != null) {
            this.timeoutKey.remove();
            this.timeoutKey = null;
        }
        if (!this.dispatched) {
            this.completeInternal(false);
        } else {
            this.onAsyncComplete();
        }
        if (this.previousAsyncContext != null) {
            this.previousAsyncContext.complete();
        }
    }

    public synchronized void completeInternal(boolean forceComplete) {
        Thread currentThread = Thread.currentThread();
        if (!forceComplete && !this.initialRequestDone && currentThread == this.initiatingThread) {
            this.completedBeforeInitialRequestDone = true;
            if (this.dispatched) {
                throw UndertowServletMessages.MESSAGES.asyncRequestAlreadyDispatched();
            }
        } else {
            this.servletRequestContext.getOriginalRequest().asyncRequestDispatched();
            if (forceComplete || currentThread == this.exchange.getIoThread()) {
                this.onAsyncCompleteAndRespond();
            } else {
                this.servletRequestContext.getOriginalRequest().asyncRequestDispatched();
                this.doDispatch(new Runnable(){

                    @Override
                    public void run() {
                        AsyncContextImpl.this.onAsyncCompleteAndRespond();
                    }
                });
            }
        }
    }

    public void start(final Runnable run) {
        Executor executor = this.asyncExecutor();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                AsyncContextImpl.this.servletRequestContext.getCurrentServletContext().invokeRunnable(AsyncContextImpl.this.exchange, run);
            }
        });
    }

    private Executor asyncExecutor() {
        Executor executor = this.servletRequestContext.getDeployment().getAsyncExecutor();
        if (executor == null) {
            executor = this.servletRequestContext.getDeployment().getExecutor();
        }
        if (executor == null) {
            executor = this.exchange.getConnection().getWorker();
        }
        return executor;
    }

    public void addListener(AsyncListener listener) {
        this.asyncListeners.add(new BoundAsyncListener(listener, this.servletRequest, this.servletResponse));
    }

    public void addListener(AsyncListener listener, ServletRequest servletRequest, ServletResponse servletResponse) {
        this.asyncListeners.add(new BoundAsyncListener(listener, servletRequest, servletResponse));
    }

    public boolean isDispatched() {
        return this.dispatched;
    }

    public boolean isCompletedBeforeInitialRequestDone() {
        return this.completedBeforeInitialRequestDone;
    }

    public <T extends AsyncListener> T createListener(Class<T> clazz) throws ServletException {
        try {
            InstanceFactory<T> factory = ((ServletContextImpl)this.servletRequest.getServletContext()).getDeployment().getDeploymentInfo().getClassIntrospecter().createInstanceFactory(clazz);
            final InstanceHandle<T> instance = factory.createInstance();
            this.exchange.addExchangeCompleteListener(new ExchangeCompletionListener(){

                public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                    try {
                        instance.release();
                    }
                    finally {
                        nextListener.proceed();
                    }
                }
            });
            return (T)((AsyncListener)instance.getInstance());
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public synchronized void setTimeout(long timeout) {
        if (this.initialRequestDone) {
            throw UndertowServletMessages.MESSAGES.asyncRequestAlreadyReturnedToContainer();
        }
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void handleError(Throwable error) {
        this.dispatched = false;
        this.onAsyncError(error);
        if (!this.dispatched) {
            block14: {
                if (!this.exchange.isResponseStarted()) {
                    this.exchange.setStatusCode(500);
                    this.exchange.getResponseHeaders().clear();
                }
                this.servletRequest.setAttribute("jakarta.servlet.error.exception", (Object)error);
                if (!this.exchange.isResponseStarted()) {
                    try {
                        boolean errorPage = this.servletRequestContext.displayStackTraces();
                        if (errorPage) {
                            ServletDebugPageHandler.handleRequest(this.exchange, this.servletRequestContext, error);
                            break block14;
                        }
                        if (this.servletResponse instanceof HttpServletResponse) {
                            ((HttpServletResponse)this.servletResponse).sendError(500);
                            break block14;
                        }
                        this.servletRequestContext.getOriginalResponse().sendError(500);
                    }
                    catch (IOException e) {
                        UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                    }
                    catch (Throwable t) {
                        UndertowLogger.REQUEST_IO_LOGGER.handleUnexpectedFailure(t);
                    }
                } else if (error instanceof IOException) {
                    UndertowLogger.REQUEST_IO_LOGGER.ioException((IOException)error);
                } else {
                    boolean handled;
                    ExceptionHandler exceptionHandler = this.servletRequestContext.getDeployment().getDeploymentInfo().getExceptionHandler();
                    if (exceptionHandler == null) {
                        exceptionHandler = LoggingExceptionHandler.DEFAULT;
                    }
                    if (!(handled = exceptionHandler.handleThrowable(this.exchange, this.getRequest(), this.getResponse(), error))) {
                        this.exchange.endExchange();
                    }
                }
            }
            if (!this.dispatched) {
                this.complete();
            }
        }
    }

    public synchronized void initialRequestDone() {
        this.initialRequestDone = true;
        if (this.previousAsyncContext != null) {
            this.previousAsyncContext.onAsyncStart(this);
            this.previousAsyncContext = null;
        }
        if (!this.processingAsyncTask) {
            this.processAsyncTask();
        }
        this.initiatingThread = null;
    }

    public synchronized void initialRequestFailed() {
        this.initialRequestDone = true;
    }

    private synchronized void doDispatch(final Runnable runnable) {
        if (this.dispatched) {
            throw UndertowServletMessages.MESSAGES.asyncRequestAlreadyDispatched();
        }
        this.dispatched = true;
        final HttpServletRequestImpl request = this.servletRequestContext.getOriginalRequest();
        this.addAsyncTask(new Runnable(){

            @Override
            public void run() {
                request.asyncRequestDispatched();
                runnable.run();
            }
        });
        if (this.timeoutKey != null) {
            this.timeoutKey.remove();
        }
    }

    public void handleCompletedBeforeInitialRequestDone() {
        assert (this.completedBeforeInitialRequestDone);
        this.completeInternal(true);
        this.dispatched = true;
    }

    private synchronized void processAsyncTask() {
        if (!this.initialRequestDone) {
            return;
        }
        this.updateTimeout();
        Runnable task = this.asyncTaskQueue.poll();
        if (task != null) {
            this.processingAsyncTask = true;
            this.asyncExecutor().execute(new TaskDispatchRunnable(task));
        } else {
            this.processingAsyncTask = false;
        }
    }

    public synchronized void addAsyncTask(Runnable runnable) {
        this.asyncTaskQueue.add(runnable);
        if (!this.processingAsyncTask) {
            this.processAsyncTask();
        }
    }

    private void onAsyncCompleteAndRespond() {
        HttpServletResponseImpl response = this.servletRequestContext.getOriginalResponse();
        try {
            this.onAsyncComplete();
        }
        catch (RuntimeException e) {
            UndertowServletLogger.REQUEST_LOGGER.failureDispatchingAsyncEvent(e);
        }
        finally {
            response.responseDone();
            try {
                this.servletRequestContext.getOriginalRequest().closeAndDrainRequest();
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
            }
            catch (Throwable t) {
                UndertowLogger.REQUEST_IO_LOGGER.handleUnexpectedFailure(t);
            }
        }
    }

    private void onAsyncComplete() {
        final boolean setupRequired = SecurityActions.currentServletRequestContext() == null;
        this.servletRequestContext.getCurrentServletContext().invokeRunnable(this.servletRequestContext.getExchange(), new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AsyncContextImpl.this.setupRequestContext(setupRequired);
                try {
                    for (BoundAsyncListener listener : AsyncContextImpl.this.asyncListeners) {
                        AsyncEvent event = new AsyncEvent((AsyncContext)AsyncContextImpl.this, listener.servletRequest, listener.servletResponse);
                        try {
                            listener.asyncListener.onComplete(event);
                        }
                        catch (IOException e) {
                            UndertowServletLogger.REQUEST_LOGGER.ioExceptionDispatchingAsyncEvent(e);
                        }
                        catch (Throwable t) {
                            UndertowServletLogger.REQUEST_LOGGER.failureDispatchingAsyncEvent(t);
                        }
                    }
                }
                finally {
                    AsyncContextImpl.this.tearDownRequestContext(setupRequired);
                }
            }
        });
    }

    private void onAsyncTimeout() {
        for (BoundAsyncListener listener : this.asyncListeners) {
            AsyncEvent event = new AsyncEvent((AsyncContext)this, listener.servletRequest, listener.servletResponse);
            try {
                listener.asyncListener.onTimeout(event);
            }
            catch (IOException e) {
                UndertowServletLogger.REQUEST_LOGGER.ioExceptionDispatchingAsyncEvent(e);
            }
            catch (Throwable t) {
                UndertowServletLogger.REQUEST_LOGGER.failureDispatchingAsyncEvent(t);
            }
        }
    }

    private void onAsyncStart(final AsyncContext newAsyncContext) {
        final boolean setupRequired = SecurityActions.currentServletRequestContext() == null;
        this.servletRequestContext.getCurrentServletContext().invokeRunnable(this.servletRequestContext.getExchange(), new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AsyncContextImpl.this.setupRequestContext(setupRequired);
                try {
                    for (BoundAsyncListener listener : AsyncContextImpl.this.asyncListeners) {
                        AsyncEvent event = new AsyncEvent(newAsyncContext, listener.servletRequest, listener.servletResponse);
                        try {
                            listener.asyncListener.onStartAsync(event);
                        }
                        catch (IOException e) {
                            UndertowServletLogger.REQUEST_LOGGER.ioExceptionDispatchingAsyncEvent(e);
                        }
                        catch (Throwable t) {
                            UndertowServletLogger.REQUEST_LOGGER.failureDispatchingAsyncEvent(t);
                        }
                    }
                }
                finally {
                    AsyncContextImpl.this.tearDownRequestContext(setupRequired);
                }
            }
        });
    }

    private void onAsyncError(final Throwable t) {
        final boolean setupRequired = SecurityActions.currentServletRequestContext() == null;
        this.servletRequestContext.getCurrentServletContext().invokeRunnable(this.servletRequestContext.getExchange(), new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AsyncContextImpl.this.setupRequestContext(setupRequired);
                try {
                    for (BoundAsyncListener listener : AsyncContextImpl.this.asyncListeners) {
                        AsyncEvent event = new AsyncEvent((AsyncContext)AsyncContextImpl.this, listener.servletRequest, listener.servletResponse, t);
                        try {
                            listener.asyncListener.onError(event);
                        }
                        catch (IOException e) {
                            UndertowServletLogger.REQUEST_LOGGER.ioExceptionDispatchingAsyncEvent(e);
                        }
                        catch (Throwable t2) {
                            UndertowServletLogger.REQUEST_LOGGER.failureDispatchingAsyncEvent(t2);
                        }
                    }
                }
                finally {
                    AsyncContextImpl.this.tearDownRequestContext(setupRequired);
                }
            }
        });
    }

    private void setupRequestContext(boolean setupRequired) {
        if (setupRequired) {
            this.servletRequestContext.getDeployment().getApplicationListeners().requestInitialized(this.servletRequest);
            SecurityActions.setCurrentRequestContext(this.servletRequestContext);
        }
    }

    private void tearDownRequestContext(boolean setupRequired) {
        if (setupRequired) {
            this.servletRequestContext.getDeployment().getApplicationListeners().requestDestroyed(this.servletRequest);
            SecurityActions.clearCurrentServletAttachments();
        }
    }

    private static final class BoundAsyncListener {
        final AsyncListener asyncListener;
        final ServletRequest servletRequest;
        final ServletResponse servletResponse;

        private BoundAsyncListener(AsyncListener asyncListener, ServletRequest servletRequest, ServletResponse servletResponse) {
            this.asyncListener = asyncListener;
            this.servletRequest = servletRequest;
            this.servletResponse = servletResponse;
        }
    }

    private class TaskDispatchRunnable
    implements Runnable {
        private final Runnable task;

        private TaskDispatchRunnable(Runnable task) {
            this.task = task;
        }

        @Override
        public void run() {
            try {
                this.task.run();
            }
            finally {
                AsyncContextImpl.this.processAsyncTask();
            }
        }
    }

    private final class TimeoutTask
    implements Runnable {
        private TimeoutTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AsyncContextImpl asyncContextImpl = AsyncContextImpl.this;
            synchronized (asyncContextImpl) {
                if (!AsyncContextImpl.this.dispatched && !AsyncContextImpl.this.complete) {
                    AsyncContextImpl.this.addAsyncTask(new Runnable(){

                        @Override
                        public void run() {
                            final boolean setupRequired = SecurityActions.currentServletRequestContext() == null;
                            UndertowServletLogger.REQUEST_LOGGER.debug("Async request timed out");
                            AsyncContextImpl.this.servletRequestContext.getCurrentServletContext().invokeRunnable(AsyncContextImpl.this.servletRequestContext.getExchange(), new Runnable(){

                                @Override
                                public void run() {
                                    AsyncContextImpl.this.setupRequestContext(setupRequired);
                                    try {
                                        AsyncContextImpl.this.onAsyncTimeout();
                                        if (!AsyncContextImpl.this.dispatched) {
                                            if (!AsyncContextImpl.this.getResponse().isCommitted()) {
                                                AsyncContextImpl.this.exchange.setPersistent(false);
                                                AsyncContextImpl.this.exchange.getResponseHeaders().put(Headers.CONNECTION, Headers.CLOSE.toString());
                                                Connectors.executeRootHandler((HttpHandler)new HttpHandler(){

                                                    public void handleRequest(HttpServerExchange exchange) throws Exception {
                                                        try {
                                                            if (AsyncContextImpl.this.servletResponse instanceof HttpServletResponse) {
                                                                ((HttpServletResponse)AsyncContextImpl.this.servletResponse).sendError(500);
                                                            } else {
                                                                AsyncContextImpl.this.servletRequestContext.getOriginalResponse().sendError(500);
                                                            }
                                                        }
                                                        catch (IOException e) {
                                                            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                                                        }
                                                        catch (Throwable t) {
                                                            UndertowLogger.REQUEST_IO_LOGGER.handleUnexpectedFailure(t);
                                                        }
                                                    }
                                                }, (HttpServerExchange)AsyncContextImpl.this.exchange);
                                            } else {
                                                IoUtils.safeClose((Closeable)AsyncContextImpl.this.exchange.getConnection());
                                            }
                                            if (!AsyncContextImpl.this.dispatched) {
                                                AsyncContextImpl.this.complete();
                                            }
                                        }
                                    }
                                    finally {
                                        AsyncContextImpl.this.tearDownRequestContext(setupRequired);
                                    }
                                }
                            });
                        }
                    });
                }
            }
        }
    }
}

