/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Enumerations {
    public static <T> Stream<T> stream(Enumeration<T> e) {
        return Enumerations.stream(e, false);
    }

    public static <T> Stream<T> stream(final Enumeration<T> e, boolean parallel) {
        Objects.requireNonNull(e);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<T>(){

            @Override
            public T next() {
                return e.nextElement();
            }

            @Override
            public boolean hasNext() {
                return e.hasMoreElements();
            }
        }, 16), parallel);
    }

    public static <O> Enumeration<O> singleton(O element) {
        return new SingletonEnumeration<O>(element);
    }

    private static class SingletonEnumeration<O>
    implements Enumeration<O> {
        private final O element;
        private boolean nextElement;

        public SingletonEnumeration(O element) {
            Objects.requireNonNull(element);
            this.element = element;
            this.nextElement = true;
        }

        @Override
        public boolean hasMoreElements() {
            return this.nextElement;
        }

        @Override
        public O nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            this.nextElement = false;
            return this.element;
        }
    }
}

