/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.adapter.apt;

import io.sundr.adapter.apt.AptContext;
import io.sundr.model.AnnotationRef;
import io.sundr.model.Modifiers;
import io.sundr.model.Property;
import io.sundr.model.PropertyBuilder;
import io.sundr.model.TypeRef;
import io.sundr.model.utils.Types;
import io.sundr.utils.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class VariableElementToProperty
implements Function<VariableElement, Property> {
    private static final String NEWLINE_PATTERN = "\r|\n";
    private final AptContext context;
    private final Function<TypeMirror, TypeRef> referenceAdapterFunction;
    private final Function<AnnotationMirror, AnnotationRef> annotationAdapterFunction;

    public VariableElementToProperty(AptContext context, Function<TypeMirror, TypeRef> referenceAdapterFunction, Function<AnnotationMirror, AnnotationRef> annotationAdapterFunction) {
        this.context = context;
        this.referenceAdapterFunction = referenceAdapterFunction;
        this.annotationAdapterFunction = annotationAdapterFunction;
    }

    @Override
    public Property apply(VariableElement variableElement) {
        String name = variableElement.getSimpleName().toString();
        TypeRef type = this.referenceAdapterFunction.apply(variableElement.asType());
        boolean isEnum = Types.isEnum((TypeRef)type);
        ArrayList<AnnotationRef> annotations = new ArrayList<AnnotationRef>();
        for (AnnotationMirror annotationMirror : variableElement.getAnnotationMirrors()) {
            annotations.add(this.annotationAdapterFunction.apply(annotationMirror));
        }
        String comments = this.context.getElements().getDocComment(variableElement);
        ArrayList arrayList = Strings.isNullOrEmpty((String)comments) ? new ArrayList() : Arrays.stream(comments.split(NEWLINE_PATTERN)).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        return ((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)new PropertyBuilder().withComments(arrayList)).withName(name)).withTypeRef(type)).withAnnotations(annotations)).withEnumConstant(isEnum)).withSynthetic(false)).withModifiers(Modifiers.from(variableElement.getModifiers()))).build();
    }
}

