package io.vertx.mutiny.ext.web.handler;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.Handler;

/**
 *
 * A handler which renders responses using a template engine and where the template name is selected from the URI
 * path.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.TemplateHandler original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.handler.TemplateHandler.class)
public class TemplateHandler implements io.smallrye.mutiny.vertx.MutinyDelegate, io.vertx.core.Handler<io.vertx.mutiny.ext.web.RoutingContext>, java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> {

  public static final io.smallrye.mutiny.vertx.TypeArg<TemplateHandler> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new TemplateHandler((io.vertx.ext.web.handler.TemplateHandler) obj),
    TemplateHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.TemplateHandler delegate;
  
  public TemplateHandler(io.vertx.ext.web.handler.TemplateHandler delegate) {
    this.delegate = delegate;
  }

  public TemplateHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.TemplateHandler)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  TemplateHandler() {
    this.delegate = null;
  }

  @Override
  public io.vertx.ext.web.handler.TemplateHandler getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TemplateHandler that = (TemplateHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * @param indexTemplate the index template
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.TemplateHandler setIndexTemplate(String indexTemplate) { 
    delegate.setIndexTemplate(indexTemplate);
    return this;
  }

  /**
   * @param engine the template engine
   * @return the handler
   */
  public static io.vertx.mutiny.ext.web.handler.TemplateHandler create(io.vertx.mutiny.ext.web.common.template.TemplateEngine engine) { 
    io.vertx.mutiny.ext.web.handler.TemplateHandler ret = io.vertx.mutiny.ext.web.handler.TemplateHandler.newInstance((io.vertx.ext.web.handler.TemplateHandler)io.vertx.ext.web.handler.TemplateHandler.create(engine.getDelegate()));
    return ret;
  }

  /**
   * @param engine the template engine
   * @param templateDirectory the template directory where templates will be looked for
   * @param contentType the content type header to be used in the response
   * @return the handler
   */
  public static io.vertx.mutiny.ext.web.handler.TemplateHandler create(io.vertx.mutiny.ext.web.common.template.TemplateEngine engine, String templateDirectory, String contentType) { 
    io.vertx.mutiny.ext.web.handler.TemplateHandler ret = io.vertx.mutiny.ext.web.handler.TemplateHandler.newInstance((io.vertx.ext.web.handler.TemplateHandler)io.vertx.ext.web.handler.TemplateHandler.create(engine.getDelegate(), templateDirectory, contentType));
    return ret;
  }

  /**
   * The default directory where templates will be looked for
   */
  public static final String DEFAULT_TEMPLATE_DIRECTORY = io.vertx.ext.web.handler.TemplateHandler.DEFAULT_TEMPLATE_DIRECTORY;
  /**
   * The default content type header to be used in the response
   */
  public static final String DEFAULT_CONTENT_TYPE = io.vertx.ext.web.handler.TemplateHandler.DEFAULT_CONTENT_TYPE;
  /**
   * The default index page
   */
  public static final String DEFAULT_INDEX_TEMPLATE = io.vertx.ext.web.handler.TemplateHandler.DEFAULT_INDEX_TEMPLATE;
  public void accept(io.vertx.mutiny.ext.web.RoutingContext item) {
    handle(item);
  }
  public static  TemplateHandler newInstance(io.vertx.ext.web.handler.TemplateHandler arg) {
    return arg != null ? new TemplateHandler(arg) : null;
  }

}
