/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl;

import io.smallrye.classfile.CodeBuilder;
import io.smallrye.classfile.CodeModel;
import io.smallrye.classfile.attribute.CodeAttribute;
import io.smallrye.classfile.impl.BufferedCodeBuilder;
import io.smallrye.classfile.impl.LabelContext;
import io.smallrye.classfile.impl.MethodInfo;
import io.smallrye.classfile.impl.Util;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface TerminalCodeBuilder
extends CodeBuilder,
LabelContext {
    public int curTopLocal();

    public static int setupTopLocal(MethodInfo methodInfo, CodeModel original) {
        int paramSlots = Util.maxLocals(methodInfo.methodFlags(), methodInfo.methodTypeSymbol());
        if (original == null) {
            return paramSlots;
        }
        if (original instanceof CodeAttribute) {
            CodeAttribute attr = (CodeAttribute)original;
            return Math.max(paramSlots, attr.maxLocals());
        }
        if (original instanceof BufferedCodeBuilder.Model) {
            BufferedCodeBuilder.Model buffered = (BufferedCodeBuilder.Model)original;
            return Math.max(paramSlots, buffered.curTopLocal());
        }
        throw new InternalError("Unknown code model " + String.valueOf(original));
    }
}

