/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.jaxrs;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.ws.rs.sse.OutboundSseEvent;
import javax.ws.rs.sse.SseBroadcaster;
import javax.ws.rs.sse.SseEventSink;
import org.jboss.resteasy.reactive.server.jaxrs.SseEventSinkImpl;

public class SseBroadcasterImpl
implements SseBroadcaster {
    private final List<SseEventSink> sinks = new ArrayList<SseEventSink>();
    private final List<BiConsumer<SseEventSink, Throwable>> onErrorListeners = new ArrayList<BiConsumer<SseEventSink, Throwable>>();
    private final List<Consumer<SseEventSink>> onCloseListeners = new ArrayList<Consumer<SseEventSink>>();
    private volatile boolean isClosed;

    public synchronized void onError(BiConsumer<SseEventSink, Throwable> onError) {
        Objects.requireNonNull(onError);
        this.checkClosed();
        this.onErrorListeners.add(onError);
    }

    public synchronized void onClose(Consumer<SseEventSink> onClose) {
        Objects.requireNonNull(onClose);
        this.checkClosed();
        this.onCloseListeners.add(onClose);
    }

    public synchronized void register(SseEventSink sseEventSink) {
        Objects.requireNonNull(sseEventSink);
        this.checkClosed();
        if (!(sseEventSink instanceof SseEventSinkImpl)) {
            throw new IllegalArgumentException("Can only work with Quarkus-REST instances: " + sseEventSink);
        }
        ((SseEventSinkImpl)sseEventSink).register(this);
        this.sinks.add(sseEventSink);
    }

    public synchronized CompletionStage<?> broadcast(OutboundSseEvent event) {
        Objects.requireNonNull(event);
        this.checkClosed();
        CompletableFuture[] cfs = new CompletableFuture[this.sinks.size()];
        for (int i = 0; i < this.sinks.size(); ++i) {
            SseEventSink sseEventSink = this.sinks.get(i);
            cfs[i] = sseEventSink.send(event).toCompletableFuture();
        }
        return CompletableFuture.allOf(cfs);
    }

    private void checkClosed() {
        if (this.isClosed) {
            throw new IllegalStateException("Broadcaster has been closed");
        }
    }

    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        for (SseEventSink sink : this.sinks) {
            sink.close();
        }
    }

    synchronized void fireClose(SseEventSinkImpl sseEventSink) {
        for (Consumer<SseEventSink> listener : this.onCloseListeners) {
            listener.accept(sseEventSink);
        }
    }

    synchronized void fireException(SseEventSinkImpl sseEventSink, Throwable t) {
        for (BiConsumer<SseEventSink, Throwable> listener : this.onErrorListeners) {
            listener.accept(sseEventSink, t);
        }
    }
}

