/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http;

import io.quarkus.registry.ValueRegistry;
import java.net.URI;

public interface HttpServer {
    public static final ValueRegistry.RuntimeKey<Integer> HTTP_PORT = ValueRegistry.RuntimeKey.intKey((String)"quarkus.http.port");
    public static final ValueRegistry.RuntimeKey<Integer> HTTP_TEST_PORT = ValueRegistry.RuntimeKey.intKey((String)"quarkus.http.test-port");
    public static final ValueRegistry.RuntimeKey<Integer> HTTPS_PORT = ValueRegistry.RuntimeKey.intKey((String)"quarkus.http.ssl-port");
    public static final ValueRegistry.RuntimeKey<Integer> HTTPS_TEST_PORT = ValueRegistry.RuntimeKey.intKey((String)"quarkus.http.test-ssl-port");
    public static final ValueRegistry.RuntimeKey<Integer> MANAGEMENT_PORT = ValueRegistry.RuntimeKey.intKey((String)"quarkus.management.port");
    public static final ValueRegistry.RuntimeKey<Integer> MANAGEMENT_TEST_PORT = ValueRegistry.RuntimeKey.intKey((String)"quarkus.management.test-port");
    public static final ValueRegistry.RuntimeKey<URI> LOCAL_BASE_URI = ValueRegistry.RuntimeKey.key((String)"quarkus.http.local-base-uri");
    public static final ValueRegistry.RuntimeKey<HttpServer> HTTP_SERVER = ValueRegistry.RuntimeKey.key(HttpServer.class);
    public static final ValueRegistry.RuntimeInfo<HttpServer> INFO = new ValueRegistry.RuntimeInfo<HttpServer>(){

        public HttpServer get(final ValueRegistry valueRegistry) {
            return new HttpServer(){

                @Override
                public int getPort() {
                    return (Integer)valueRegistry.getOrDefault(HTTP_PORT, (Object)-1);
                }

                @Override
                public int getSecurePort() {
                    return (Integer)valueRegistry.getOrDefault(HTTPS_PORT, (Object)-1);
                }

                @Override
                public int getManagementPort() {
                    return (Integer)valueRegistry.getOrDefault(MANAGEMENT_PORT, (Object)-1);
                }

                @Override
                public URI getLocalBaseUri() {
                    return (URI)valueRegistry.get(LOCAL_BASE_URI);
                }
            };
        }
    };

    public int getPort();

    public int getSecurePort();

    public int getManagementPort();

    public URI getLocalBaseUri();
}

