/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.RolesMapping;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import java.security.Permission;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class RolesAllowedHttpSecurityPolicy
extends RolesMapping
implements HttpSecurityPolicy {
    private static final String AUTHENTICATED = "**";
    private final String[] rolesAllowed;

    public RolesAllowedHttpSecurityPolicy(List<String> rolesAllowed, Map<String, Set<Permission>> roleToPermissions, Map<String, List<String>> roleToRoles) {
        super(roleToPermissions, roleToRoles);
        this.rolesAllowed = (String[])rolesAllowed.toArray(String[]::new);
    }

    @Override
    public Uni<HttpSecurityPolicy.CheckResult> checkPermission(RoutingContext request, Uni<SecurityIdentity> identity, HttpSecurityPolicy.AuthorizationRequestContext requestContext) {
        return identity.map((Function)new Function<SecurityIdentity, HttpSecurityPolicy.CheckResult>(){

            @Override
            public HttpSecurityPolicy.CheckResult apply(SecurityIdentity securityIdentity) {
                SecurityIdentity augmented;
                if ((RolesAllowedHttpSecurityPolicy.this.grantPermissions || RolesAllowedHttpSecurityPolicy.this.grantRoles) && (augmented = RolesAllowedHttpSecurityPolicy.this.augmentIdentity(securityIdentity)) != null) {
                    for (String i : RolesAllowedHttpSecurityPolicy.this.rolesAllowed) {
                        if (!augmented.hasRole(i) && (!RolesAllowedHttpSecurityPolicy.AUTHENTICATED.equals(i) || augmented.isAnonymous())) continue;
                        return new HttpSecurityPolicy.CheckResult(true, augmented);
                    }
                    return new HttpSecurityPolicy.CheckResult(false, augmented);
                }
                for (String i : RolesAllowedHttpSecurityPolicy.this.rolesAllowed) {
                    if (!securityIdentity.hasRole(i) && (!RolesAllowedHttpSecurityPolicy.AUTHENTICATED.equals(i) || securityIdentity.isAnonymous())) continue;
                    return HttpSecurityPolicy.CheckResult.PERMIT;
                }
                return HttpSecurityPolicy.CheckResult.DENY;
            }
        });
    }
}

