/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.smallrye.config.WithDefault;
import java.time.Duration;
import java.util.Optional;

public interface FormAuthRuntimeConfig {
    @WithDefault(value="/login.html")
    public Optional<String> loginPage();

    @WithDefault(value="j_username")
    public String usernameParameter();

    @WithDefault(value="j_password")
    public String passwordParameter();

    @WithDefault(value="/error.html")
    public Optional<String> errorPage();

    @WithDefault(value="/index.html")
    public Optional<String> landingPage();

    @WithDefault(value="true")
    @Deprecated
    public boolean redirectAfterLogin();

    @WithDefault(value="quarkus-redirect-location")
    public String locationCookie();

    @WithDefault(value="PT30M")
    public Duration timeout();

    @WithDefault(value="PT1M")
    public Duration newCookieInterval();

    @WithDefault(value="quarkus-credential")
    public String cookieName();

    @WithDefault(value="/")
    public Optional<String> cookiePath();

    @WithDefault(value="false")
    public boolean httpOnlyCookie();

    @WithDefault(value="strict")
    public CookieSameSite cookieSameSite();

    public Optional<Duration> cookieMaxAge();

    public static enum CookieSameSite {
        STRICT,
        LAX,
        NONE;

    }
}

