/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.metrics.runtime;

import io.smallrye.metrics.MetricsRequestHandler;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.stream.Stream;
import javax.enterprise.inject.spi.CDI;
import org.jboss.logging.Logger;

public class SmallRyeMetricsHandler
implements Handler<RoutingContext> {
    private String metricsPath;
    private static final Logger LOGGER = Logger.getLogger((String)SmallRyeMetricsHandler.class.getName());

    public void setMetricsPath(String metricsPath) {
        this.metricsPath = metricsPath;
    }

    public void handle(RoutingContext routingContext) {
        MetricsRequestHandler internalHandler = (MetricsRequestHandler)CDI.current().select(MetricsRequestHandler.class, new Annotation[0]).get();
        HttpServerResponse response = routingContext.response();
        HttpServerRequest request = routingContext.request();
        Stream acceptHeaders = request.headers().getAll("Accept").stream();
        try {
            internalHandler.handleRequest(request.path(), this.metricsPath, request.rawMethod(), acceptHeaders, (status, message, headers) -> {
                response.setStatusCode(status);
                headers.forEach((arg_0, arg_1) -> ((HttpServerResponse)response).putHeader(arg_0, arg_1));
                response.end(Buffer.buffer((String)message));
            });
        }
        catch (IOException e) {
            response.setStatusCode(503);
            response.end();
            LOGGER.error((Object)e);
        }
    }
}

