/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.spi;

import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.security.spi.SecurityTransformer;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationOverlay;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationTransformation;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.Declaration;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;

public final class SecurityTransformerBuildItem
extends SimpleBuildItem {
    private final Map<SecurityTransformer.AuthorizationType, Set<DotName>> authorizationTypeToSecurityAnnotations;
    private final Set<DotName> allSecurityAnnotations;
    private final Map<IndexView, SecurityTransformerCache> securityTransformerCache;

    public SecurityTransformerBuildItem(Map<SecurityTransformer.AuthorizationType, Set<DotName>> authorizationTypeToSecurityAnnotations) {
        this.authorizationTypeToSecurityAnnotations = Collections.unmodifiableMap(authorizationTypeToSecurityAnnotations);
        this.allSecurityAnnotations = SecurityTransformerBuildItem.getAllSecurityAnnotations(authorizationTypeToSecurityAnnotations);
        this.securityTransformerCache = new ConcurrentHashMap<IndexView, SecurityTransformerCache>();
    }

    public static SecurityTransformer createSecurityTransformer(IndexView indexView, Optional<SecurityTransformerBuildItem> optionalTransformerBuildItem) {
        return SecurityTransformerBuildItem.createSecurityTransformer(indexView, optionalTransformerBuildItem.orElseThrow());
    }

    public static SecurityTransformer createSecurityTransformer(IndexView indexView, SecurityTransformerBuildItem transformerBuildItem) {
        return transformerBuildItem.getOrCreateTransformer(indexView);
    }

    public String[] getAllSecurityAnnotationNames() {
        return (String[])this.allSecurityAnnotations.stream().map(DotName::toString).toArray(String[]::new);
    }

    private SecurityTransformer getOrCreateTransformer(IndexView indexView) {
        return this.securityTransformerCache.computeIfAbsent((IndexView)indexView, (Function<IndexView, SecurityTransformerCache>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getOrCreateTransformer$1(org.jboss.jandex.IndexView ), (Lorg/jboss/jandex/IndexView;)Lio/quarkus/security/spi/SecurityTransformerBuildItem$SecurityTransformerCache;)((SecurityTransformerBuildItem)this)).transformer;
    }

    private Set<DotName> getSecurityAnnotations(SecurityTransformer.AuthorizationType[] authorizationTypes) {
        if (authorizationTypes == null || authorizationTypes.length == 0 || authorizationTypes.length == SecurityTransformer.AuthorizationType.values().length) {
            return this.allSecurityAnnotations;
        }
        HashSet<DotName> result = new HashSet<DotName>();
        for (SecurityTransformer.AuthorizationType authorizationType : authorizationTypes) {
            Set<DotName> securityAnnotations = this.authorizationTypeToSecurityAnnotations.get((Object)authorizationType);
            if (securityAnnotations == null) continue;
            result.addAll(securityAnnotations);
        }
        return result;
    }

    private boolean hasSecurityAnnotationDetectedByIndex(Declaration declaration, IndexView index) {
        if (declaration.declaredAnnotations().stream().anyMatch(this::isSecurityAnnotation)) {
            return true;
        }
        return declaration.declaredAnnotations().stream().anyMatch(ai -> this.isSecurityMetaAnnotation((AnnotationInstance)ai, index));
    }

    private boolean hasSecurityAnnotationDetectedByIndex(Declaration declaration) {
        return declaration.declaredAnnotations().stream().anyMatch(this::isSecurityAnnotation);
    }

    private Collection<AnnotationInstance> getSecurityAnnotations(MethodInfo methodInfo, IndexView index) {
        ArrayList securityAnnotations = new ArrayList(this.allSecurityAnnotations.stream().map(sa -> methodInfo.declaredAnnotationsWithRepeatable(sa, index)).flatMap(Collection::stream).toList());
        securityAnnotations.addAll(methodInfo.declaredAnnotations().stream().filter(ai -> this.isSecurityMetaAnnotation((AnnotationInstance)ai, index)).map(AnnotationInstance::name).map(sa -> methodInfo.declaredAnnotationsWithRepeatable(sa, index)).flatMap(Collection::stream).toList());
        if (securityAnnotations.isEmpty()) {
            securityAnnotations.addAll(this.allSecurityAnnotations.stream().map(sa -> methodInfo.declaringClass().declaredAnnotationsWithRepeatable(sa, index)).flatMap(Collection::stream).toList());
            securityAnnotations.addAll(methodInfo.declaringClass().declaredAnnotations().stream().filter(ai -> this.isSecurityMetaAnnotation((AnnotationInstance)ai, index)).map(AnnotationInstance::name).map(sa -> methodInfo.declaringClass().declaredAnnotationsWithRepeatable(sa, index)).flatMap(Collection::stream).toList());
        }
        return Collections.unmodifiableCollection(securityAnnotations);
    }

    private boolean isSecurityAnnotation(AnnotationInstance ai) {
        return this.allSecurityAnnotations.contains(ai.name());
    }

    private boolean isSecurityMetaAnnotation(AnnotationInstance ai, IndexView index) {
        ClassInfo annotationClass = index.getClassByName(ai.name());
        if (annotationClass != null) {
            for (AnnotationInstance declaredAnnotation : annotationClass.declaredAnnotations()) {
                if (!this.isSecurityAnnotation(declaredAnnotation)) continue;
                return true;
            }
        }
        return false;
    }

    private static Set<DotName> getAllSecurityAnnotations(Map<SecurityTransformer.AuthorizationType, Set<DotName>> authorizationTypeToSecurityAnnotations) {
        return authorizationTypeToSecurityAnnotations.values().stream().filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private /* synthetic */ SecurityTransformerCache lambda$getOrCreateTransformer$1(IndexView index) {
        SecurityTransformerImpl transformer = new SecurityTransformerImpl(AnnotationOverlay.builder((IndexView)index, null).build(), null, List.of());
        return new SecurityTransformerCache(index, transformer);
    }

    private record SecurityTransformerCache(IndexView indexView, SecurityTransformer transformer) {
    }

    final class SecurityTransformerImpl
    implements SecurityTransformer {
        private final AnnotationOverlay annotationOverlay;
        private final Collection<AnnotationTransformation> interfaceTransformations;
        private final Collection<DotName> possiblySecuredParentInterfaces;

        private SecurityTransformerImpl(AnnotationOverlay annotationOverlay, Collection<AnnotationTransformation> interfaceTransformations, Collection<DotName> possiblySecuredParentInterfaces) {
            this.annotationOverlay = annotationOverlay;
            this.interfaceTransformations = interfaceTransformations;
            this.possiblySecuredParentInterfaces = possiblySecuredParentInterfaces;
        }

        @Override
        public Collection<AnnotationInstance> getAnnotations(DotName securityAnnotationName) {
            return this.getAnnotations(securityAnnotationName, false);
        }

        @Override
        public Collection<AnnotationInstance> getAnnotationsWithRepeatable(DotName securityAnnotationName) {
            return this.getAnnotations(securityAnnotationName, true);
        }

        @Override
        public boolean hasSecurityAnnotation(AnnotationTarget annotationTarget, SecurityTransformer.AuthorizationType ... authorizationTypes) {
            return this.findFirstSecurityAnnotation(annotationTarget, authorizationTypes).isPresent();
        }

        @Override
        public boolean isSecurityAnnotation(AnnotationInstance annotationInstance, SecurityTransformer.AuthorizationType ... authorizationTypes) {
            if (authorizationTypes == null || authorizationTypes.length == 0) {
                authorizationTypes = SecurityTransformer.AuthorizationType.values();
            }
            DotName securityAnnotationName = annotationInstance.name();
            for (SecurityTransformer.AuthorizationType authorizationType : authorizationTypes) {
                Set<DotName> securityAnnotations = SecurityTransformerBuildItem.this.authorizationTypeToSecurityAnnotations.get((Object)authorizationType);
                if (securityAnnotations == null || !securityAnnotations.contains(securityAnnotationName)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isSecurityAnnotation(Collection<AnnotationInstance> annotationInstances) {
            for (AnnotationInstance annotationInstance : annotationInstances) {
                if (!this.isSecurityAnnotation(annotationInstance, new SecurityTransformer.AuthorizationType[0])) continue;
                return true;
            }
            return false;
        }

        @Override
        public Optional<AnnotationInstance> findFirstSecurityAnnotation(Collection<AnnotationInstance> annotationInstances) {
            for (AnnotationInstance annotationInstance : annotationInstances) {
                if (!this.isSecurityAnnotation(annotationInstance, new SecurityTransformer.AuthorizationType[0])) continue;
                return Optional.of(annotationInstance);
            }
            return Optional.empty();
        }

        @Override
        public Optional<AnnotationInstance> findFirstSecurityAnnotation(AnnotationTarget annotationTarget, SecurityTransformer.AuthorizationType ... authorizationTypes) {
            return this.findFirstSecurityAnnotation(annotationTarget.asDeclaration(), SecurityTransformerBuildItem.this.getSecurityAnnotations(authorizationTypes));
        }

        @Override
        public Collection<AnnotationTransformation> getInterfaceTransformations() {
            return this.interfaceTransformations;
        }

        @Override
        public Collection<DotName> getSecurityAnnotationNames(SecurityTransformer.AuthorizationType ... authorizationTypes) {
            return SecurityTransformerBuildItem.this.getSecurityAnnotations(authorizationTypes);
        }

        private Optional<AnnotationInstance> findFirstSecurityAnnotation(Declaration declaration, Set<DotName> securityAnnotations) {
            for (AnnotationInstance instance : this.annotationOverlay.annotations(declaration)) {
                if (!securityAnnotations.contains(instance.name())) continue;
                return Optional.of(instance);
            }
            return Optional.empty();
        }

        private boolean shouldCheckForSecurityAnnotations(ClassInfo ci, HashSet<String> checkedInterfaces) {
            return this.possiblySecuredParentInterfaces.contains(ci.name()) && checkedInterfaces.add(ci.name().toString());
        }

        private Collection<AnnotationInstance> getImplementorsSecurityAnnotations(DotName securityAnnotationName, ClassInfo securedInterface, boolean repeatable) {
            HashSet<AnnotationInstance> result = null;
            for (ClassInfo implementation : this.annotationOverlay.index().getAllKnownImplementations(securedInterface.name())) {
                for (MethodInfo implementationMethod : implementation.methods()) {
                    if (SecurityTransformerBuildItem.this.hasSecurityAnnotationDetectedByIndex((Declaration)implementationMethod)) continue;
                    if (repeatable) {
                        List<AnnotationInstance> annotations = this.annotationOverlay.annotationsWithRepeatable((Declaration)implementationMethod, securityAnnotationName).stream().map(interfaceInstance -> AnnotationInstance.builder((DotName)interfaceInstance.name()).addAll(interfaceInstance.values()).buildWithTarget((AnnotationTarget)implementationMethod)).toList();
                        if (annotations.isEmpty()) continue;
                        if (result == null) {
                            result = new HashSet();
                        }
                        result.addAll(annotations);
                        continue;
                    }
                    if (!this.annotationOverlay.hasAnnotation((Declaration)implementationMethod, securityAnnotationName)) continue;
                    if (result == null) {
                        result = new HashSet<AnnotationInstance>();
                    }
                    AnnotationInstance interfaceInstance2 = this.annotationOverlay.annotation((Declaration)implementationMethod, securityAnnotationName);
                    AnnotationInstance implementationInstance = AnnotationInstance.builder((DotName)interfaceInstance2.name()).addAll(interfaceInstance2.values()).buildWithTarget((AnnotationTarget)implementationMethod);
                    result.add(implementationInstance);
                }
            }
            return result;
        }

        private Collection<AnnotationInstance> getAnnotations(DotName securityAnnotationName, boolean repeatable) {
            Collection indexedAnnotationInstances = repeatable ? this.annotationOverlay.index().getAnnotationsWithRepeatable(securityAnnotationName, this.annotationOverlay.index()) : this.annotationOverlay.index().getAnnotations(securityAnnotationName);
            if (this.interfaceTransformations == null || indexedAnnotationInstances.isEmpty()) {
                return indexedAnnotationInstances;
            }
            HashSet<String> checkedInterfaces = new HashSet<String>();
            HashSet<AnnotationInstance> result = new HashSet<AnnotationInstance>(indexedAnnotationInstances);
            for (AnnotationInstance annotationInstance : indexedAnnotationInstances) {
                ClassInfo declaringClass;
                if (annotationInstance.target().kind() == AnnotationTarget.Kind.METHOD) {
                    declaringClass = annotationInstance.target().asMethod().declaringClass();
                } else {
                    if (annotationInstance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
                    declaringClass = annotationInstance.target().asClass();
                }
                if (!this.shouldCheckForSecurityAnnotations(declaringClass, checkedInterfaces)) continue;
                for (MethodInfo securedInterfaceMethod : declaringClass.methods()) {
                    if (!securedInterfaceMethod.isDefault() || !SecurityTransformerBuildItem.this.hasSecurityAnnotationDetectedByIndex((Declaration)securedInterfaceMethod, this.annotationOverlay.index())) continue;
                    throw new RuntimeException("Interface '%s' default method '%s' has security annotation.\nSecuring interface default methods is currently not supported, please secure\nthe interface implementation method instead.\n".formatted(declaringClass.name().toString(), securedInterfaceMethod.name()));
                }
                Collection<AnnotationInstance> implementorSecurityAnnotation = this.getImplementorsSecurityAnnotations(securityAnnotationName, declaringClass, repeatable);
                if (implementorSecurityAnnotation == null) continue;
                result.addAll(implementorSecurityAnnotation);
            }
            return Collections.unmodifiableCollection(result);
        }
    }
}

