/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime.security;

import io.quarkus.arc.Arc;
import io.quarkus.resteasy.reactive.server.runtime.ResteasyReactiveSecurityContext;
import io.quarkus.resteasy.reactive.server.runtime.security.EagerSecurityContext;
import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import jakarta.ws.rs.core.SecurityContext;
import java.lang.annotation.Annotation;
import java.security.Permission;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jboss.resteasy.reactive.common.model.ResourceClass;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.model.ServerResourceMethod;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class SecurityContextOverrideHandler
implements ServerRestHandler {
    private static final SecurityContextOverrideHandler INSTANCE = new SecurityContextOverrideHandler();

    private SecurityContextOverrideHandler() {
    }

    public void handle(ResteasyReactiveRequestContext requestContext) throws Exception {
        if (!requestContext.isSecurityContextSet()) {
            return;
        }
        SecurityContext modified = requestContext.getSecurityContext();
        if (modified instanceof ResteasyReactiveSecurityContext) {
            return;
        }
        SecurityContextOverrideHandler.updateIdentity(requestContext, modified);
    }

    private static void updateIdentity(ResteasyReactiveRequestContext requestContext, final SecurityContext modified) {
        requestContext.requireCDIRequestScope();
        CurrentIdentityAssociation currentIdentityAssociation = SecurityContextOverrideHandler.getIdentityAssociation();
        if (currentIdentityAssociation != null) {
            final RoutingContext routingContext = (RoutingContext)requestContext.unwrap(RoutingContext.class);
            Uni oldIdentity = currentIdentityAssociation.getDeferredIdentity();
            currentIdentityAssociation.setIdentity(oldIdentity.map((Function)new Function<SecurityIdentity, SecurityIdentity>(){

                @Override
                public SecurityIdentity apply(SecurityIdentity old) {
                    final Set oldCredentials = old.getCredentials();
                    final Set oldPermissions = old.getPermissions();
                    final Map oldAttributes = old.getAttributes();
                    SecurityIdentity newIdentity = new SecurityIdentity(){

                        public Principal getPrincipal() {
                            return modified.getUserPrincipal();
                        }

                        public boolean isAnonymous() {
                            return modified.getUserPrincipal() == null;
                        }

                        public Set<String> getRoles() {
                            throw new UnsupportedOperationException("retrieving all roles not supported when JAX-RS security context has been replaced");
                        }

                        public boolean hasRole(String role) {
                            return modified.isUserInRole(role);
                        }

                        public <T extends Credential> T getCredential(Class<T> credentialType) {
                            for (Credential cred : this.getCredentials()) {
                                if (!credentialType.isAssignableFrom(cred.getClass())) continue;
                                return (T)cred;
                            }
                            return null;
                        }

                        public Set<Credential> getCredentials() {
                            return oldCredentials;
                        }

                        public Set<Permission> getPermissions() {
                            return oldPermissions;
                        }

                        public <T> T getAttribute(String name) {
                            return (T)oldAttributes.get(name);
                        }

                        public Map<String, Object> getAttributes() {
                            return oldAttributes;
                        }

                        public Uni<Boolean> checkPermission(Permission permission) {
                            return Uni.createFrom().nullItem();
                        }
                    };
                    if (routingContext != null) {
                        routingContext.setUser((User)new QuarkusHttpUser(newIdentity));
                    }
                    return newIdentity;
                }
            }));
        }
    }

    private static CurrentIdentityAssociation getIdentityAssociation() {
        CurrentIdentityAssociation currentIdentityAssociation = EagerSecurityContext.getCurrentIdentityAssociation();
        if (currentIdentityAssociation != null) {
            return currentIdentityAssociation;
        }
        return (CurrentIdentityAssociation)Arc.container().instance(CurrentIdentityAssociation.class, new Annotation[0]).orElse(null);
    }

    public static class Customizer
    implements HandlerChainCustomizer {
        public List<ServerRestHandler> handlers(HandlerChainCustomizer.Phase phase, ResourceClass resourceClass, ServerResourceMethod serverResourceMethod) {
            if (phase == HandlerChainCustomizer.Phase.AFTER_PRE_MATCH) {
                return Collections.singletonList(INSTANCE);
            }
            return Collections.emptyList();
        }
    }
}

