/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.instrumentation.grpc;

import io.grpc.Attributes;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.net.SocketAddress;

public class GrpcRequest {
    private final MethodDescriptor<?, ?> methodDescriptor;
    private Metadata metadata;
    private final Attributes attributes;
    private volatile String logicalHost;
    private volatile int logicalPort = -1;
    private volatile SocketAddress peerSocketAddress;

    public static GrpcRequest server(MethodDescriptor<?, ?> methodDescriptor, Metadata metadata, Attributes attributes, String authority) {
        return new GrpcRequest(methodDescriptor, metadata, attributes, attributes == null ? null : (SocketAddress)attributes.get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR), authority);
    }

    public static GrpcRequest client(MethodDescriptor<?, ?> methodDescriptor, String authority) {
        return new GrpcRequest(methodDescriptor, null, null, null, authority);
    }

    public static GrpcRequest client(MethodDescriptor<?, ?> methodDescriptor, Metadata metadata) {
        return new GrpcRequest(methodDescriptor, metadata, null, null, null);
    }

    private GrpcRequest(MethodDescriptor<?, ?> methodDescriptor, Metadata metadata, Attributes attributes, SocketAddress peerSocketAddress, String authority) {
        this.methodDescriptor = methodDescriptor;
        this.metadata = metadata;
        this.attributes = attributes;
        this.peerSocketAddress = peerSocketAddress;
        this.setLogicalAddress(authority);
    }

    public MethodDescriptor<?, ?> getMethodDescriptor() {
        return this.methodDescriptor;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public String getLogicalHost() {
        return this.logicalHost;
    }

    public int getLogicalPort() {
        return this.logicalPort;
    }

    public SocketAddress getPeerSocketAddress() {
        return this.peerSocketAddress;
    }

    void setPeerSocketAddress(SocketAddress peerSocketAddress) {
        this.peerSocketAddress = peerSocketAddress;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    private void setLogicalAddress(String authority) {
        if (authority == null) {
            return;
        }
        int index = authority.indexOf(58);
        if (index == -1) {
            this.logicalHost = authority;
        } else {
            this.logicalHost = authority.substring(0, index);
            try {
                this.logicalPort = Integer.parseInt(authority.substring(index + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

