/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.deployment.devservices.keycloak;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.builditem.RuntimeConfigSetupCompleteBuildItem;
import io.quarkus.devconsole.spi.DevConsoleRouteBuildItem;
import io.quarkus.devconsole.spi.DevConsoleTemplateInfoBuildItem;
import io.quarkus.oidc.deployment.devservices.keycloak.DevServicesConfigBuildItem;
import io.quarkus.oidc.deployment.devservices.keycloak.KeycloakAuthorizationCodePostHandler;
import io.quarkus.oidc.deployment.devservices.keycloak.KeycloakBuildTimeConfig;
import io.quarkus.oidc.deployment.devservices.keycloak.KeycloakDevConsolePostHandler;
import io.quarkus.oidc.deployment.devservices.keycloak.KeycloakImplicitGrantPostHandler;
import io.vertx.core.Handler;
import java.util.Map;
import java.util.Optional;

public class KeycloakDevConsoleProcessor {
    KeycloakBuildTimeConfig config;

    @BuildStep(onlyIf={IsDevelopment.class})
    @Consume(value=RuntimeConfigSetupCompleteBuildItem.class)
    public void setConfigProperties(BuildProducer<DevConsoleTemplateInfoBuildItem> console, Optional<DevServicesConfigBuildItem> configProps) {
        if (configProps.isPresent()) {
            console.produce((BuildItem)new DevConsoleTemplateInfoBuildItem("devServicesEnabled", (Object)this.config.devservices.enabled));
            console.produce((BuildItem)new DevConsoleTemplateInfoBuildItem("keycloakUrl", configProps.get().getProperties().get("keycloak.url")));
            console.produce((BuildItem)new DevConsoleTemplateInfoBuildItem("oidcApplicationType", configProps.get().getProperties().get("quarkus.oidc.application-type")));
            console.produce((BuildItem)new DevConsoleTemplateInfoBuildItem("keycloakClient", configProps.get().getProperties().get("quarkus.oidc.client-id")));
            console.produce((BuildItem)new DevConsoleTemplateInfoBuildItem("keycloakClientSecret", configProps.get().getProperties().get("quarkus.oidc.credentials.secret")));
            console.produce((BuildItem)new DevConsoleTemplateInfoBuildItem("keycloakUsers", configProps.get().getProperties().get("oidc.users")));
            console.produce((BuildItem)new DevConsoleTemplateInfoBuildItem("keycloakRealm", (Object)this.config.devservices.realmName));
            console.produce((BuildItem)new DevConsoleTemplateInfoBuildItem("oidcGrantType", (Object)this.config.devservices.grant.type.getGrantType()));
        }
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void invokeEndpoint(BuildProducer<DevConsoleRouteBuildItem> devConsoleRoute, Optional<DevServicesConfigBuildItem> configProps) {
        if (configProps.isPresent()) {
            Map users = (Map)configProps.get().getProperties().get("oidc.users");
            devConsoleRoute.produce((BuildItem)new DevConsoleRouteBuildItem("testService", "POST", (Handler)new KeycloakDevConsolePostHandler(users)));
            devConsoleRoute.produce((BuildItem)new DevConsoleRouteBuildItem("testServiceWithToken", "POST", (Handler)new KeycloakImplicitGrantPostHandler()));
            devConsoleRoute.produce((BuildItem)new DevConsoleRouteBuildItem("exchangeCodeForTokens", "POST", (Handler)new KeycloakAuthorizationCodePostHandler()));
        }
    }
}

