/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.maven.BuildMojo;
import io.quarkus.maven.ImageBuilder;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.runtime.LaunchMode;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public class AbstractImageMojo
extends BuildMojo {
    @Parameter(property="quarkus.container-image.builder")
    String builderName;
    @Parameter(property="quarkus.container-image.dry-run")
    boolean dryRun;

    public ImageBuilder getBuilder() {
        return ImageBuilder.getBuilder(this.builderName, this.mavenProject()).orElse(ImageBuilder.docker);
    }

    @Override
    protected boolean beforeExecute() throws MojoExecutionException {
        this.systemProperties.put("quarkus.container-image.builder", this.getBuilder().name());
        return super.beforeExecute();
    }

    @Override
    protected void doExecute() throws MojoExecutionException {
        if (this.dryRun) {
            this.getLog().info((CharSequence)"Container image configuration:");
            this.systemProperties.entrySet().stream().filter(e -> ((String)e.getKey()).contains("quarkus.container-image")).forEach(e -> this.getLog().info((CharSequence)(" - " + (String)e.getKey() + ": " + (String)e.getValue())));
        } else {
            super.doExecute();
        }
    }

    @Override
    protected List<Dependency> forcedDependencies(LaunchMode mode) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        this.getBuilder().getExtensionArtifact(this.mavenProject()).ifPresent(dependencies::add);
        return dependencies;
    }
}

