/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.jar;

import io.quarkus.bootstrap.model.MutableJarApplicationModel;
import io.quarkus.bootstrap.runner.QuarkusEntryPoint;
import io.quarkus.bootstrap.runner.SerializedApplication;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.commons.classloading.ClassLoaderHelper;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveBuildItem;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.MainClassBuildItem;
import io.quarkus.deployment.builditem.TransformedClassesBuildItem;
import io.quarkus.deployment.jvm.ResolvedJVMRequirements;
import io.quarkus.deployment.pkg.JarUnsigner;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.JarBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.jar.AbstractJarBuilder;
import io.quarkus.deployment.pkg.jar.Decompiler;
import io.quarkus.deployment.pkg.jar.FastJarFormat;
import io.quarkus.deployment.pkg.jar.ParallelCommonsCompressArchiveCreator;
import io.quarkus.deployment.pkg.jar.VineflowerDecompiler;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.sbom.ApplicationComponent;
import io.quarkus.sbom.ApplicationManifestConfig;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public class FastJarBuilder
extends AbstractJarBuilder<JarBuildItem> {
    private static final Logger LOG = Logger.getLogger(FastJarBuilder.class);
    private static final String MP_CONFIG_FILE = "META-INF/microprofile-config.properties";
    private final List<AdditionalApplicationArchiveBuildItem> additionalApplicationArchives;
    private final Set<ArtifactKey> parentFirstArtifactKeys;

    public FastJarBuilder(CurateOutcomeBuildItem curateOutcome, OutputTargetBuildItem outputTarget, ApplicationInfoBuildItem applicationInfo, PackageConfig packageConfig, MainClassBuildItem mainClass, ApplicationArchivesBuildItem applicationArchives, List<AdditionalApplicationArchiveBuildItem> additionalApplicationArchives, TransformedClassesBuildItem transformedClasses, List<GeneratedClassBuildItem> generatedClasses, List<GeneratedResourceBuildItem> generatedResources, Set<ArtifactKey> parentFirstArtifactKeys, Set<ArtifactKey> removedArtifactKeys, ExecutorService executorService, ResolvedJVMRequirements jvmRequirements) {
        super(curateOutcome, outputTarget, applicationInfo, packageConfig, mainClass, applicationArchives, transformedClasses, generatedClasses, generatedResources, removedArtifactKeys, executorService, jvmRequirements);
        this.additionalApplicationArchives = additionalApplicationArchives;
        this.parentFirstArtifactKeys = parentFirstArtifactKeys;
    }

    @Override
    public JarBuildItem build() throws IOException {
        List lines;
        boolean mutableJar;
        ParallelCommonsCompressArchiveCreator archiveCreator;
        boolean rebuild = this.outputTarget.isRebuild();
        Path buildDir = this.packageConfig.outputDirectory().isPresent() ? this.outputTarget.getOutputDirectory() : this.outputTarget.getOutputDirectory().resolve("quarkus-app");
        ApplicationManifestConfig.Builder manifestConfig = ApplicationManifestConfig.builder().setApplicationModel(this.curateOutcome.getApplicationModel()).setDistributionDirectory(buildDir);
        Path libDir = buildDir.resolve("lib");
        Path mainLib = libDir.resolve("main");
        Path baseLib = libDir.resolve("boot");
        Files.createDirectories(baseLib, new FileAttribute[0]);
        Path appDir = buildDir.resolve("app");
        Path quarkus = buildDir.resolve("quarkus");
        Path userProviders = null;
        if (this.packageConfig.jar().userProvidersDirectory().isPresent()) {
            userProviders = buildDir.resolve(this.packageConfig.jar().userProvidersDirectory().get());
        }
        if (!rebuild) {
            IoUtils.createOrEmptyDir((Path)buildDir);
            Files.createDirectories(mainLib, new FileAttribute[0]);
            Files.createDirectories(baseLib, new FileAttribute[0]);
            Files.createDirectories(appDir, new FileAttribute[0]);
            Files.createDirectories(quarkus, new FileAttribute[0]);
            if (userProviders != null) {
                Files.createDirectories(userProviders, new FileAttribute[0]);
                Path keepFile = userProviders.resolve(".keep");
                if (!keepFile.toFile().exists()) {
                    Files.createFile(keepFile, new FileAttribute[0]);
                }
            }
        } else {
            IoUtils.createOrEmptyDir((Path)quarkus);
        }
        Path decompiledOutputDir = null;
        boolean wasDecompiledSuccessfully = true;
        VineflowerDecompiler decompiler = null;
        PackageConfig.DecompilerConfig decompilerConfig = this.packageConfig.jar().decompiler();
        if (decompilerConfig.enabled()) {
            decompiledOutputDir = buildDir.getParent().resolve(decompilerConfig.outputDirectory());
            FileUtil.deleteDirectory(decompiledOutputDir);
            Files.createDirectory(decompiledOutputDir, new FileAttribute[0]);
            decompiler = new VineflowerDecompiler();
            Path jarDirectory = Paths.get(decompilerConfig.jarDirectory(), new String[0]);
            if (!Files.exists(jarDirectory, new LinkOption[0])) {
                Files.createDirectory(jarDirectory, new FileAttribute[0]);
            }
            decompiler.init(new Decompiler.Context(jarDirectory, decompiledOutputDir));
            decompiler.downloadIfNecessary();
        }
        FastJarJars.FastJarJarsBuilder fastJarJarsBuilder = new FastJarJars.FastJarJarsBuilder();
        ArrayList parentFirst = new ArrayList();
        if (!this.transformedClasses.getTransformedClassesByJar().isEmpty()) {
            Path transformedZip = quarkus.resolve("transformed-bytecode.jar");
            fastJarJarsBuilder.setTransformedJar(transformedZip);
            archiveCreator = new ParallelCommonsCompressArchiveCreator(transformedZip, this.packageConfig.jar().compress(), this.packageConfig.outputTimestamp().orElse(null), this.executorService);
            try {
                for (Map.Entry entry : this.transformedClasses.getTransformedClassesByJar().entrySet().stream().sorted(Comparator.comparing(e -> ((Path)e.getKey()).toString())).toList()) {
                    for (TransformedClassesBuildItem.TransformedClass transformed : ((Set)entry.getValue()).stream().sorted(Comparator.comparing(TransformedClassesBuildItem.TransformedClass::getFileName)).toList()) {
                        if (transformed.getData() == null) continue;
                        archiveCreator.addFile(transformed.getData(), transformed.getFileName());
                    }
                }
            }
            finally {
                archiveCreator.close();
            }
            if (decompiler != null) {
                wasDecompiledSuccessfully = decompiler.decompile(transformedZip);
            }
        }
        Path generatedZip = quarkus.resolve("generated-bytecode.jar");
        fastJarJarsBuilder.setGeneratedJar(generatedZip);
        archiveCreator = new ParallelCommonsCompressArchiveCreator(generatedZip, this.packageConfig.jar().compress(), this.packageConfig.outputTimestamp().orElse(null), this.executorService);
        try {
            for (GeneratedClassBuildItem generatedClassBuildItem : this.generatedClasses.stream().sorted(Comparator.comparing(GeneratedClassBuildItem::binaryName)).toList()) {
                Iterator<AdditionalApplicationArchiveBuildItem> fileName = ClassLoaderHelper.fromClassNameToResourceName((String)generatedClassBuildItem.internalName());
                archiveCreator.addFile(generatedClassBuildItem.getClassData(), (String)((Object)fileName));
            }
            for (GeneratedResourceBuildItem generatedResourceBuildItem : this.generatedResources.stream().sorted(Comparator.comparing(GeneratedResourceBuildItem::getName)).toList()) {
                archiveCreator.addFileIfNotExists(generatedResourceBuildItem.getData(), generatedResourceBuildItem.getName());
            }
        }
        finally {
            archiveCreator.close();
        }
        if (decompiler != null) {
            wasDecompiledSuccessfully &= decompiler.decompile(generatedZip);
        }
        if (wasDecompiledSuccessfully && decompiledOutputDir != null) {
            LOG.info((Object)("The decompiled output can be found at: " + decompiledOutputDir.toAbsolutePath().toString()));
        }
        Path runnerJar = appDir.resolve(this.outputTarget.getBaseName() + ".jar");
        fastJarJarsBuilder.setRunnerJar(runnerJar);
        if (!rebuild) {
            manifestConfig.addComponent((ApplicationComponent)ApplicationComponent.builder().setResolvedDependency(this.applicationArchives.getRootArchive().getResolvedDependency()).setPath(runnerJar));
            Predicate<String> ignoredEntriesPredicate = FastJarBuilder.getThinJarIgnoredEntriesPredicate(this.packageConfig);
            try (ParallelCommonsCompressArchiveCreator parallelCommonsCompressArchiveCreator = new ParallelCommonsCompressArchiveCreator(runnerJar, this.packageConfig.jar().compress(), this.packageConfig.outputTimestamp().orElse(null), this.executorService);){
                FastJarBuilder.copyFiles(this.applicationArchives.getRootArchive(), parallelCommonsCompressArchiveCreator, null, ignoredEntriesPredicate);
            }
        }
        StringBuilder classPath = new StringBuilder();
        HashMap<ArtifactKey, List<Path>> hashMap = new HashMap<ArtifactKey, List<Path>>();
        for (ResolvedDependency appDep : this.curateOutcome.getApplicationModel().getRuntimeDependencies()) {
            if (!rebuild) {
                FastJarBuilder.copyDependency(this.parentFirstArtifactKeys, this.outputTarget, hashMap, mainLib, baseLib, fastJarJarsBuilder::addDependency, true, classPath, appDep, this.transformedClasses, this.removedArtifactKeys, this.packageConfig, manifestConfig, this.executorService);
            } else if (FastJarBuilder.includeAppDependency(appDep, this.outputTarget.getIncludedOptionalDependencies(), this.removedArtifactKeys)) {
                appDep.getResolvedPaths().forEach(fastJarJarsBuilder::addDependency);
            }
            if (!this.parentFirstArtifactKeys.contains(appDep.getKey())) continue;
            appDep.getResolvedPaths().forEach(parentFirst::add);
        }
        for (AdditionalApplicationArchiveBuildItem i : this.additionalApplicationArchives) {
            for (Path path : i.getResolvedPaths()) {
                if (!path.getParent().equals(userProviders)) {
                    throw new RuntimeException("Additional application archives can only be provided from the user providers directory. " + String.valueOf(path) + " is not present in " + String.valueOf(userProviders));
                }
                fastJarJarsBuilder.addDependency(path);
            }
        }
        ArrayList<String> nonExistentResources = new ArrayList<String>(1);
        Enumeration<URL> mpConfigURLs = Thread.currentThread().getContextClassLoader().getResources(MP_CONFIG_FILE);
        if (!mpConfigURLs.hasMoreElements()) {
            nonExistentResources.add(MP_CONFIG_FILE);
        }
        Path appInfo = buildDir.resolve("quarkus/quarkus-application.dat");
        try (OutputStream out = Files.newOutputStream(appInfo, new OpenOption[0]);){
            FastJarJars fastJarJars = fastJarJarsBuilder.build();
            ArrayList<Path> allJars = new ArrayList<Path>();
            if (fastJarJars.transformedJar != null) {
                allJars.add(fastJarJars.transformedJar);
            }
            allJars.add(fastJarJars.generatedJar);
            allJars.add(fastJarJars.runnerJar);
            ArrayList<Path> sortedDeps = new ArrayList<Path>(fastJarJars.dependencies);
            Collections.sort(sortedDeps);
            allJars.addAll(sortedDeps);
            ArrayList sortedParentFirst = new ArrayList(parentFirst);
            Collections.sort(sortedParentFirst);
            ArrayList arrayList = new ArrayList(nonExistentResources);
            Collections.sort(arrayList);
            SerializedApplication.write((OutputStream)out, (String)this.mainClass.getClassName(), (Path)buildDir, allJars, sortedParentFirst, arrayList);
        }
        runnerJar.toFile().setReadable(true, false);
        Path initJar = buildDir.resolve("quarkus-run.jar");
        manifestConfig.setMainComponent((ApplicationComponent)ApplicationComponent.builder().setPath(initJar).setDependencies(List.of(this.curateOutcome.getApplicationModel().getAppArtifact()))).setRunnerPath(initJar);
        boolean bl = mutableJar = this.packageConfig.jar().type() == PackageConfig.JarConfig.JarType.MUTABLE_JAR;
        if (mutableJar) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.outputTarget.getBuildSystemProperties().store(out, null);
            lines = Arrays.stream(out.toString(StandardCharsets.UTF_8).split("\n")).filter(s -> !s.startsWith("#")).sorted().collect(Collectors.toList());
            Path buildSystemProps = quarkus.resolve("build-system.properties");
            manifestConfig.addComponent((ApplicationComponent)ApplicationComponent.builder().setPath(buildSystemProps).setDevelopmentScope());
            try (OutputStream outputStream = Files.newOutputStream(buildSystemProps, new OpenOption[0]);){
                outputStream.write(String.join((CharSequence)"\n", lines).getBytes(StandardCharsets.UTF_8));
            }
        }
        if (!rebuild) {
            try (ParallelCommonsCompressArchiveCreator archiveCreator3 = new ParallelCommonsCompressArchiveCreator(initJar, this.packageConfig.jar().compress(), this.packageConfig.outputTimestamp().orElse(null), this.executorService);){
                ResolvedDependency appArtifact = this.curateOutcome.getApplicationModel().getAppArtifact();
                FastJarBuilder.generateManifest(archiveCreator3, classPath.toString(), this.packageConfig, appArtifact, this.jvmRequirements, QuarkusEntryPoint.class.getName(), this.applicationInfo);
            }
            if (mutableJar) {
                Path deploymentLib = libDir.resolve("deployment");
                Files.createDirectories(deploymentLib, new FileAttribute[0]);
                for (Object appDep : this.curateOutcome.getApplicationModel().getDependencies()) {
                    FastJarBuilder.copyDependency(this.parentFirstArtifactKeys, this.outputTarget, hashMap, deploymentLib, baseLib, p -> {}, false, classPath, (ResolvedDependency)appDep, new TransformedClassesBuildItem(Map.of()), this.removedArtifactKeys, this.packageConfig, manifestConfig, this.executorService);
                }
                HashMap relativePaths = new HashMap();
                for (Map.Entry entry : hashMap.entrySet()) {
                    relativePaths.put((ArtifactKey)entry.getKey(), ((List)entry.getValue()).stream().map(s -> buildDir.relativize((Path)s).toString().replace('\\', '/')).collect(Collectors.toList()));
                }
                MutableJarApplicationModel model = new MutableJarApplicationModel(this.outputTarget.getBaseName(), relativePaths, this.curateOutcome.getApplicationModel(), (String)this.packageConfig.jar().userProvidersDirectory().orElse(null), buildDir.relativize(runnerJar).toString());
                Path path = deploymentLib.resolve("appmodel.dat");
                manifestConfig.addComponent((ApplicationComponent)ApplicationComponent.builder().setPath(path).setDevelopmentScope());
                try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
                    ObjectOutputStream obj = new ObjectOutputStream(out);
                    obj.writeObject(model);
                    obj.close();
                }
                Path deploymentCp = deploymentLib.resolve("deployment-class-path.dat");
                manifestConfig.addComponent((ApplicationComponent)ApplicationComponent.builder().setPath(deploymentCp).setDevelopmentScope());
                try (OutputStream out = Files.newOutputStream(deploymentCp, new OpenOption[0]);){
                    ObjectOutputStream obj = new ObjectOutputStream(out);
                    ArrayList paths = new ArrayList();
                    for (ResolvedDependency i : this.curateOutcome.getApplicationModel().getDependencies()) {
                        List list = (List)relativePaths.get(i.getKey());
                        if (list == null) continue;
                        paths.addAll(list);
                    }
                    obj.writeObject(paths);
                    obj.close();
                }
            }
            if (this.packageConfig.jar().includeDependencyList()) {
                Path deplist = buildDir.resolve("quarkus-app-dependencies.txt");
                lines = new ArrayList();
                for (ResolvedDependency resolvedDependency : this.curateOutcome.getApplicationModel().getRuntimeDependencies()) {
                    lines.add(resolvedDependency.toGACTVString());
                }
                lines.sort(Comparator.naturalOrder());
                Files.write(deplist, lines, new OpenOption[0]);
            }
        }
        try (Stream<Path> files = Files.walk(buildDir, new FileVisitOption[0]);){
            files.forEach(new Consumer<Path>(){

                @Override
                public void accept(Path path) {
                    path.toFile().setReadable(true, false);
                }
            });
        }
        return new JarBuildItem(initJar, null, libDir, this.packageConfig.jar().type(), null, manifestConfig.build());
    }

    private static Predicate<String> getThinJarIgnoredEntriesPredicate(PackageConfig packageConfig) {
        return packageConfig.jar().userConfiguredIgnoredEntries().map(Set::copyOf).orElse(Set.of())::contains;
    }

    private static void copyDependency(Set<ArtifactKey> parentFirstArtifacts, OutputTargetBuildItem outputTargetBuildItem, Map<ArtifactKey, List<Path>> runtimeArtifacts, Path libDir, Path baseLib, Consumer<Path> targetPathConsumer, boolean allowParentFirst, StringBuilder classPath, ResolvedDependency appDep, TransformedClassesBuildItem transformedClasses, Set<ArtifactKey> removedDeps, PackageConfig packageConfig, ApplicationManifestConfig.Builder manifestConfig, ExecutorService executorService) throws IOException {
        if (!FastJarBuilder.includeAppDependency(appDep, outputTargetBuildItem.getIncludedOptionalDependencies(), removedDeps)) {
            return;
        }
        if (runtimeArtifacts.containsKey(appDep.getKey())) {
            return;
        }
        Set forceUseArtifactIdOnlyAsNameSet = packageConfig.jar().forceUseArtifactIdOnlyAsName().orElse(Collections.emptySet());
        boolean forceUseArtifactIdOnlyAsName = forceUseArtifactIdOnlyAsNameSet.stream().anyMatch(gact -> gact.getGroupId().equals(appDep.getGroupId()) && gact.getArtifactId().equals(appDep.getArtifactId()) && gact.getType().equals(appDep.getType()) && gact.getClassifier().equals(appDep.getClassifier()));
        for (Path resolvedDep : appDep.getResolvedPaths()) {
            Path targetPath;
            Object fileName = forceUseArtifactIdOnlyAsName ? appDep.getArtifactId() + "." + appDep.getType() : FastJarFormat.getJarFileName(appDep, resolvedDep);
            if (allowParentFirst && parentFirstArtifacts.contains(appDep.getKey())) {
                targetPath = baseLib.resolve((String)fileName);
                classPath.append(" ").append("lib").append("/").append("boot").append("/").append((String)fileName);
            } else {
                targetPath = libDir.resolve((String)fileName);
                targetPathConsumer.accept(targetPath);
            }
            runtimeArtifacts.computeIfAbsent(appDep.getKey(), s -> new ArrayList(1)).add(targetPath);
            if (Files.isDirectory(resolvedDep, new LinkOption[0])) {
                FastJarBuilder.packageClasses(resolvedDep, targetPath, packageConfig, outputTargetBuildItem, executorService);
                continue;
            }
            Set<TransformedClassesBuildItem.TransformedClass> transformedFromThisArchive = transformedClasses.getTransformedClassesByJar().get(resolvedDep);
            HashSet<String> removedFromThisArchive = new HashSet<String>();
            if (transformedFromThisArchive != null) {
                for (TransformedClassesBuildItem.TransformedClass i : transformedFromThisArchive) {
                    if (i.getData() != null) continue;
                    removedFromThisArchive.add(i.getFileName());
                }
            }
            ApplicationComponent.Builder appComponent = ApplicationComponent.builder().setPath(targetPath).setResolvedDependency(appDep);
            if (removedFromThisArchive.isEmpty()) {
                Files.copy(resolvedDep, targetPath, StandardCopyOption.REPLACE_EXISTING);
                Files.setLastModifiedTime(targetPath, Files.getLastModifiedTime(resolvedDep, new LinkOption[0]));
            } else {
                JarUnsigner.unsignJar(resolvedDep, targetPath, Predicate.not(removedFromThisArchive::contains));
                ArrayList list = new ArrayList(removedFromThisArchive);
                Collections.sort(list);
                StringBuilder sb = new StringBuilder("Removed ").append((String)list.get(0));
                for (int i = 1; i < list.size(); ++i) {
                    sb.append(",").append((String)list.get(i));
                }
                appComponent.setPedigree(sb.toString());
            }
            manifestConfig.addComponent((ApplicationComponent)appComponent);
        }
    }

    private static void packageClasses(final Path resolvedDep, Path targetPath, PackageConfig packageConfig, OutputTargetBuildItem outputTargetBuildItem, ExecutorService executorService) throws IOException {
        try (final ParallelCommonsCompressArchiveCreator archiveCreator = new ParallelCommonsCompressArchiveCreator(targetPath, packageConfig.jar().compress(), packageConfig.outputTimestamp().orElse(null), executorService);){
            Files.walkFileTree(resolvedDep, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path relativePath = resolvedDep.relativize(file);
                    archiveCreator.addFile(file, relativePath.toString());
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private static class FastJarJars {
        private final Path transformedJar;
        private final Path generatedJar;
        private final Path runnerJar;
        private final List<Path> dependencies;

        public FastJarJars(FastJarJarsBuilder builder) {
            this.transformedJar = builder.transformedJar;
            this.generatedJar = builder.generatedJar;
            this.runnerJar = builder.runnerJar;
            this.dependencies = builder.dependencies;
        }

        public static class FastJarJarsBuilder {
            private Path transformedJar;
            private Path generatedJar;
            private Path runnerJar;
            private final List<Path> dependencies = new ArrayList<Path>();

            public FastJarJarsBuilder setTransformedJar(Path transformedJar) {
                this.transformedJar = transformedJar;
                return this;
            }

            public FastJarJarsBuilder setGeneratedJar(Path generatedJar) {
                this.generatedJar = generatedJar;
                return this;
            }

            public FastJarJarsBuilder setRunnerJar(Path runnerJar) {
                this.runnerJar = runnerJar;
                return this;
            }

            public FastJarJarsBuilder addDependency(Path dependency) {
                this.dependencies.add(dependency);
                return this;
            }

            public FastJarJars build() {
                return new FastJarJars(this);
            }
        }
    }
}

