/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.GeneratedClassGizmo2Adaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.GeneratedNativeImageClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.JPMSExportBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedPackageBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeReinitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.UnsafeAccessedFieldBuildItem;
import io.quarkus.deployment.pkg.NativeConfig;
import io.quarkus.gizmo2.ClassOutput;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.Gizmo;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.ParamVar;
import io.quarkus.gizmo2.desc.Descs;
import io.quarkus.gizmo2.desc.MethodDesc;
import io.quarkus.runtime.LocalesBuildTimeConfig;
import io.quarkus.runtime.graal.GraalVM;
import java.lang.constant.ClassDesc;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeSystemProperties;

public class NativeImageFeatureStep {
    public static final String GRAAL_FEATURE = "io.quarkus.runner.Feature";
    private static final MethodDesc BUILD_TIME_INITIALIZATION = MethodDesc.of(RuntimeClassInitialization.class, (String)"initializeAtBuildTime", Void.TYPE, (Class[])new Class[]{String[].class});
    private static final MethodDesc REGISTER_RUNTIME_SYSTEM_PROPERTIES = MethodDesc.of(RuntimeSystemProperties.class, (String)"register", Void.TYPE, (Class[])new Class[]{String.class, String.class});
    private static final MethodDesc GRAALVM_VERSION_GET_CURRENT = MethodDesc.of(GraalVM.Version.class, (String)"getCurrent", GraalVM.Version.class, (Class[])new Class[0]);
    private static final MethodDesc GRAALVM_VERSION_COMPARE_TO = MethodDesc.of(GraalVM.Version.class, (String)"compareTo", Integer.TYPE, (Class[])new Class[]{int[].class});
    private static final MethodDesc INITIALIZE_CLASSES_AT_RUN_TIME = MethodDesc.of(RuntimeClassInitialization.class, (String)"initializeAtRunTime", Void.TYPE, (Class[])new Class[]{Class[].class});
    private static final MethodDesc INITIALIZE_PACKAGES_AT_RUN_TIME = MethodDesc.of(RuntimeClassInitialization.class, (String)"initializeAtRunTime", Void.TYPE, (Class[])new Class[]{String[].class});
    private static final MethodDesc PRINT_STACK_TRACE = MethodDesc.of(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]);
    private static final MethodDesc GET_DECLARED_FIELD = MethodDesc.of(Class.class, (String)"getDeclaredField", Field.class, (Class[])new Class[]{String.class});
    private static final MethodDesc REGISTER_AS_UNSAFE_ACCESSED = MethodDesc.of(Feature.BeforeAnalysisAccess.class, (String)"registerAsUnsafeAccessed", Void.TYPE, (Class[])new Class[]{Field.class});
    private static final MethodDesc GET_CONTEXT_CLASS_LOADER = MethodDesc.of(Thread.class, (String)"getContextClassLoader", ClassLoader.class, (Class[])new Class[0]);

    @BuildStep
    void addExportsToNativeImage(BuildProducer<JPMSExportBuildItem> features) {
        features.produce(new JPMSExportBuildItem("org.graalvm.sdk", "org.graalvm.nativeimage.impl", null, GraalVM.Version.VERSION_23_1_0));
        features.produce(new JPMSExportBuildItem("org.graalvm.nativeimage", "org.graalvm.nativeimage.impl", GraalVM.Version.VERSION_23_1_0));
    }

    @BuildStep
    void generateFeature(BuildProducer<GeneratedNativeImageClassBuildItem> nativeImageClass, List<RuntimeInitializedClassBuildItem> runtimeInitializedClassBuildItems, List<RuntimeInitializedPackageBuildItem> runtimeInitializedPackageBuildItems, List<RuntimeReinitializedClassBuildItem> runtimeReinitializedClassBuildItems, List<UnsafeAccessedFieldBuildItem> unsafeAccessedFields, NativeConfig nativeConfig, LocalesBuildTimeConfig localesBuildTimeConfig) {
        Gizmo g = Gizmo.create((ClassOutput)new GeneratedClassGizmo2Adaptor(item -> nativeImageClass.produce(new GeneratedNativeImageClassBuildItem(item.binaryName(), item.getClassData())), item -> {}, false));
        g.class_(GRAAL_FEATURE, cc -> {
            cc.implements_(Feature.class);
            cc.defaultConstructor();
            cc.method("getDescription", mc -> {
                mc.returning(String.class);
                mc.body(b0 -> b0.return_((Expr)Const.of((String)"Auto-generated class by Quarkus from the existing extensions")));
            });
            cc.method("beforeAnalysis", mc -> {
                ParamVar access = mc.parameter("access", Feature.BeforeAnalysisAccess.class);
                MethodDesc classForName3 = MethodDesc.of(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class, Boolean.TYPE, ClassLoader.class});
                mc.body(b0 -> {
                    b0.try_(t1 -> {
                        t1.body(b2 -> {
                            b2.invokeStatic(BUILD_TIME_INITIALIZATION, b2.newArray(String.class, new Expr[]{Const.of((String)"")}));
                            LocalVar cl = b2.localVar("cl", b2.invokeVirtual((MethodDesc)Descs.MD_Class.getClassLoader, (Expr)Const.of((ClassDesc)cc.type())));
                            if (localesBuildTimeConfig.defaultLocale().isPresent()) {
                                Locale defaultLocale = (Locale)localesBuildTimeConfig.defaultLocale().get();
                                b2.invokeStatic(REGISTER_RUNTIME_SYSTEM_PROPERTIES, (Expr)Const.of((String)"user.language"), (Expr)Const.of((String)defaultLocale.getLanguage()));
                                b2.invokeStatic(REGISTER_RUNTIME_SYSTEM_PROPERTIES, (Expr)Const.of((String)"user.country"), (Expr)Const.of((String)defaultLocale.getCountry()));
                            } else {
                                LocalVar graalVMVersion = b2.localVar("graalVMVersion", b2.invokeStatic(GRAALVM_VERSION_GET_CURRENT));
                                b2.if_(b2.gt(b2.invokeVirtual(GRAALVM_VERSION_COMPARE_TO, (Expr)graalVMVersion, b2.newArray(Integer.TYPE, new Expr[]{Const.of((int)24), Const.of((int)2)})), 0), t3 -> {
                                    t3.invokeStatic(REGISTER_RUNTIME_SYSTEM_PROPERTIES, (Expr)Const.of((String)"user.language"), (Expr)Const.of((String)"en"));
                                    t3.invokeStatic(REGISTER_RUNTIME_SYSTEM_PROPERTIES, (Expr)Const.of((String)"user.country"), (Expr)Const.of((String)"US"));
                                });
                            }
                            if (!runtimeInitializedClassBuildItems.isEmpty() || !runtimeReinitializedClassBuildItems.isEmpty()) {
                                b2.block(b3 -> {
                                    LocalVar classes = b3.localVar("classes", b3.new_(ArrayList.class, (Expr)Const.of((int)(runtimeInitializedClassBuildItems.size() + runtimeReinitializedClassBuildItems.size()))));
                                    Stream.concat(runtimeInitializedClassBuildItems.stream().map(RuntimeInitializedClassBuildItem::getClassName), runtimeReinitializedClassBuildItems.stream().map(RuntimeReinitializedClassBuildItem::getClassName)).forEach(name -> b3.try_(t4 -> {
                                        t4.body(b5 -> b5.invokeInterface((MethodDesc)Descs.MD_Collection.add, (Expr)classes, b5.invokeStatic(classForName3, new Expr[]{Const.of((String)name), Const.of((boolean)false), cl})));
                                        t4.catch_(Throwable.class, "t", (b5, t) -> b5.invokeVirtual(PRINT_STACK_TRACE, (Expr)t));
                                    }));
                                    b3.invokeStatic(INITIALIZE_CLASSES_AT_RUN_TIME, b3.cast(b3.invokeVirtual(MethodDesc.of(ArrayList.class, (String)"toArray", Object[].class, (Class[])new Class[]{Object[].class}), (Expr)classes, b3.newEmptyArray(Class.class, b3.invokeInterface((MethodDesc)Descs.MD_Collection.size, (Expr)classes))), Class[].class));
                                });
                            }
                            if (!runtimeInitializedPackageBuildItems.isEmpty()) {
                                b2.block(b3 -> b3.invokeStatic(INITIALIZE_PACKAGES_AT_RUN_TIME, b3.newArray(String.class, (Expr[])runtimeInitializedPackageBuildItems.stream().map(RuntimeInitializedPackageBuildItem::getPackageName).map(Const::of).toArray(Expr[]::new))));
                            }
                            if (!unsafeAccessedFields.isEmpty()) {
                                for (UnsafeAccessedFieldBuildItem unsafeAccessedField : unsafeAccessedFields) {
                                    b2.try_(t3 -> {
                                        t3.body(b4 -> {
                                            LocalVar declaringClass = b4.localVar("declaringClass", b4.invokeStatic(classForName3, new Expr[]{Const.of((String)unsafeAccessedField.getDeclaringClass()), Const.of((boolean)false), cl}));
                                            LocalVar declaredField = b4.localVar("declaredField", b4.invokeVirtual(GET_DECLARED_FIELD, (Expr)declaringClass, (Expr)Const.of((String)unsafeAccessedField.getFieldName())));
                                            b4.invokeInterface(REGISTER_AS_UNSAFE_ACCESSED, (Expr)access, (Expr)declaredField);
                                        });
                                        t3.catch_(Throwable.class, "t", (b4, t) -> b4.invokeVirtual(PRINT_STACK_TRACE, (Expr)t));
                                    });
                                }
                            }
                        });
                        t1.catch_(Throwable.class, "t", (b2, t) -> b2.invokeVirtual(PRINT_STACK_TRACE, (Expr)t));
                    });
                    Expr tccl = b0.invokeVirtual(GET_CONTEXT_CLASS_LOADER, b0.invokeStatic((MethodDesc)Descs.MD_Thread.currentThread));
                    b0.invokeStatic(classForName3, new Expr[]{Const.of((String)"io.quarkus.runner.ApplicationImpl"), Const.of((boolean)false), tccl});
                    b0.return_();
                });
            });
        });
    }
}

