/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.jvm;

import io.quarkus.changeagent.ClassChangeAgent;
import io.quarkus.deployment.builditem.ModuleOpenBuildItem;
import io.quarkus.deployment.jvm.AgentBasedModulesReconfigurer;
import io.quarkus.deployment.jvm.DirectExportedModulesAPIModulesReconfigurer;
import io.quarkus.deployment.jvm.FallbackModulesReconfigurer;
import io.quarkus.deployment.jvm.JVMDeploymentLogger;
import io.quarkus.deployment.jvm.ModulesClassloaderContext;
import io.quarkus.deployment.jvm.ReflectiveAccessModulesReconfigurer;
import java.lang.instrument.Instrumentation;
import java.util.List;
import net.bytebuddy.agent.ByteBuddyAgent;
import org.jboss.logging.Logger;

public interface JvmModulesReconfigurer {
    public void openJavaModules(List<ModuleOpenBuildItem> var1, ModulesClassloaderContext var2);

    public static JvmModulesReconfigurer create() {
        Logger logger = JVMDeploymentLogger.logger;
        Instrumentation existingInstrumentation = ClassChangeAgent.getInstrumentation();
        if (existingInstrumentation != null) {
            logger.debugf("Initializing AgentBasedModulesReconfigurer from existing instrumentation agent", new Object[0]);
            return new AgentBasedModulesReconfigurer(existingInstrumentation);
        }
        logger.debugf("Attempting to initialize ReflectiveAccessModulesReconfigurer", new Object[0]);
        try {
            return new ReflectiveAccessModulesReconfigurer();
        }
        catch (RuntimeException e) {
            logger.debugf((Throwable)e, "Failed to initialize ReflectiveAccessModulesReconfigurer", new Object[0]);
            logger.debugf("Attempting to initialize DirectExportedModulesAPIModulesReconfigurer", new Object[0]);
            try {
                return new DirectExportedModulesAPIModulesReconfigurer();
            }
            catch (RuntimeException e2) {
                logger.debugf((Throwable)e2, "Failed to initialize DirectExportedModulesAPIModulesReconfigurer", new Object[0]);
                logger.warn((Object)"Could not get access to jdk.internal.module API: this is required for Quarkus to adjust Java Modules configuration to match the various requirements of each extension. Please ensure this JVM is launched with --add-opens=java.base/java.lang.invoke=ALL-UNNAMED.");
                logger.debugf("Attempting to initialize AgentBasedModulesReconfigurer by self-attaching an agent - this will most likely trigger warnings by the JVM, and might fail in future JVM versions", new Object[0]);
                try {
                    Instrumentation instrumentation = ByteBuddyAgent.install();
                    return new AgentBasedModulesReconfigurer(instrumentation);
                }
                catch (IllegalStateException e3) {
                    logger.debugf("ByteBuddy failed to auto-attach", (Object)e3);
                    return new FallbackModulesReconfigurer();
                }
            }
        }
    }
}

