/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.recording;

import io.quarkus.deployment.proxy.ProxyConfiguration;
import io.quarkus.deployment.proxy.ProxyFactory;
import io.quarkus.deployment.recording.AnnotationProxyProvider;
import io.quarkus.deployment.recording.FieldsHelper;
import io.quarkus.deployment.recording.ObjectLoader;
import io.quarkus.deployment.recording.PropertyUtils;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.deployment.recording.RecordingAnnotationsUtil;
import io.quarkus.deployment.recording.RecordingProxyFactories;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.runtime.ObjectSubstitution;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.StartupContext;
import io.quarkus.runtime.StartupTask;
import io.quarkus.runtime.annotations.RelaxedValidation;
import jakarta.inject.Inject;
import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;
import org.wildfly.common.Assert;

public class BytecodeRecorderImpl
implements RecorderContext {
    private static final Class<?> SINGLETON_LIST_CLASS = Collections.singletonList(1).getClass();
    private static final Class<?> SINGLETON_SET_CLASS = Collections.singleton(1).getClass();
    private static final Class<?> SINGLETON_MAP_CLASS = Collections.singletonMap(1, 1).getClass();
    private static final AtomicInteger COUNT = new AtomicInteger();
    private static final String BASE_PACKAGE = "io.quarkus.deployment.steps.";
    private static final String PROXY_KEY = "proxykey";
    private static final MethodDescriptor COLLECTION_ADD = MethodDescriptor.ofMethod(Collection.class, (String)"add", Boolean.TYPE, (Class[])new Class[]{Object.class});
    private static final MethodDescriptor MAP_PUT = MethodDescriptor.ofMethod(Map.class, (String)"put", Object.class, (Class[])new Class[]{Object.class, Object.class});
    public static final String CREATE_ARRAY = "$quarkus$createArray";
    private final boolean staticInit;
    private final ClassLoader classLoader;
    private final Map<Class<?>, ProxyFactory<?>> returnValueProxy = new ConcurrentHashMap();
    private final Map<Class<?>, Object> existingProxyClasses = new ConcurrentHashMap();
    private final Map<Class<?>, NewRecorder> existingRecorderValues = new ConcurrentHashMap();
    private final List<BytecodeInstruction> storedMethodCalls = new ArrayList<BytecodeInstruction>();
    private final IdentityHashMap<Class<?>, String> classProxies = new IdentityHashMap();
    private final Map<Class<?>, SubstitutionHolder> substitutions = new HashMap();
    private final Map<Class<?>, NonDefaultConstructorHolder> nonDefaultConstructors = new HashMap();
    private final String className;
    private final Function<ClassOutput, ClassCreator> classCreatorFunction;
    private final Function<ClassCreator, MethodCreator> methodCreatorFunction;
    private final Function<Type, Object> configCreatorFunction;
    private final List<ObjectLoader> loaders = new ArrayList<ObjectLoader>();
    private final Map<Class<?>, ConstantHolder<?>> constants = new HashMap();
    private final Set<Class> classesToUseRecordableConstructor = new HashSet<Class>();
    private final boolean useIdentityComparison;
    private static final int MAX_INSTRUCTION_GROUPS = 300;
    private int deferredParameterCount = 0;
    private boolean loadComplete;

    public BytecodeRecorderImpl(boolean staticInit, String buildStepName, String methodName, String uniqueHash, boolean useIdentityComparison) {
        this(staticInit, buildStepName, methodName, uniqueHash, useIdentityComparison, s -> null);
    }

    public BytecodeRecorderImpl(boolean staticInit, String buildStepName, String methodName, String uniqueHash, boolean useIdentityComparison, Function<Type, Object> configCreatorFunction) {
        this(Thread.currentThread().getContextClassLoader(), staticInit, BytecodeRecorderImpl.toClassName(buildStepName, methodName, uniqueHash), classOutput -> BytecodeRecorderImpl.startupTaskClassCreator(classOutput, BytecodeRecorderImpl.toClassName(buildStepName, methodName, uniqueHash)), classCreator -> BytecodeRecorderImpl.startupMethodCreator(buildStepName, methodName, classCreator), useIdentityComparison, configCreatorFunction);
    }

    BytecodeRecorderImpl(ClassLoader classLoader, boolean staticInit, String className) {
        this(classLoader, staticInit, className, classOutput -> BytecodeRecorderImpl.startupTaskClassCreator(classOutput, className), classCreator -> BytecodeRecorderImpl.startupMethodCreator(null, null, classCreator), true, s -> {
            try {
                if (s instanceof Class) {
                    return ((Class)s).newInstance();
                }
                throw new RuntimeException("Not implemented for testing");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private BytecodeRecorderImpl(ClassLoader classLoader, boolean staticInit, String className, Function<ClassOutput, ClassCreator> classCreatorFunction, Function<ClassCreator, MethodCreator> methodCreatorFunction, boolean useIdentityComparison, Function<Type, Object> configCreatorFunction) {
        this.classLoader = classLoader;
        this.staticInit = staticInit;
        this.className = className;
        this.classCreatorFunction = classCreatorFunction;
        this.methodCreatorFunction = methodCreatorFunction;
        this.useIdentityComparison = useIdentityComparison;
        this.configCreatorFunction = configCreatorFunction;
    }

    private static MethodCreator startupMethodCreator(String buildStepName, String methodName, ClassCreator classCreator) {
        MethodCreator mainMethod = classCreator.getMethodCreator("deploy", Void.TYPE, new Class[]{StartupContext.class});
        if (buildStepName != null && methodName != null) {
            mainMethod.invokeVirtualMethod(MethodDescriptor.ofMethod(StartupContext.class, (String)"setCurrentBuildStepName", Void.TYPE, (Class[])new Class[]{String.class}), mainMethod.getMethodParam(0), new ResultHandle[]{mainMethod.load(buildStepName + "." + methodName)});
        }
        return mainMethod;
    }

    private static ClassCreator startupTaskClassCreator(ClassOutput classOutput, String className) {
        return ClassCreator.builder().classOutput(classOutput).className(className).superClass(Object.class).interfaces(new Class[]{StartupTask.class}).build();
    }

    private static String toClassName(String buildStepName, String methodName, String uniqueHash) {
        return BASE_PACKAGE + buildStepName + "$" + methodName + uniqueHash;
    }

    public boolean isEmpty() {
        return this.storedMethodCalls.isEmpty();
    }

    @Override
    public <F, T> void registerSubstitution(Class<F> from, Class<T> to, Class<? extends ObjectSubstitution<? super F, ? super T>> substitution) {
        this.substitutions.put(from, new SubstitutionHolder(from, to, substitution));
    }

    @Override
    public <T> void registerNonDefaultConstructor(Constructor<T> constructor, Function<T, List<Object>> parameters) {
        this.nonDefaultConstructors.put(constructor.getDeclaringClass(), new NonDefaultConstructorHolder(constructor, parameters));
    }

    @Override
    public void registerObjectLoader(ObjectLoader loader) {
        Assert.checkNotNullParam((String)"loader", (Object)loader);
        this.loaders.add(loader);
    }

    public <T> void registerConstant(Class<T> type, T value) {
        Assert.checkNotNullParam((String)"type", type);
        Assert.checkNotNullParam((String)"value", value);
        this.constants.put(type, new ConstantHolder<T>(type, value));
    }

    @Override
    public Class<?> classProxy(String name) {
        switch (name) {
            case "boolean": {
                return Boolean.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "void": {
                return Void.TYPE;
            }
        }
        ProxyFactory<Object> factory = new ProxyFactory<Object>(new ProxyConfiguration<Object>().setSuperClass(Object.class).setClassLoader(this.classLoader).setAnchorClass(this.getClass()).setProxyNameSuffix("$$ClassProxy" + COUNT.incrementAndGet()));
        Class<Object> theClass = factory.defineClass();
        this.classProxies.put(theClass, name);
        return theClass;
    }

    @Override
    public <T> RuntimeValue<T> newInstance(String name) {
        try {
            ProxyInstance ret = this.getProxyInstance(RuntimeValue.class);
            NewInstance instance = new NewInstance(name, ret.proxy, ret.key);
            this.storedMethodCalls.add(instance);
            return (RuntimeValue)ret.proxy;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isProxiable(Class<?> returnType) {
        if (returnType.isPrimitive()) {
            return false;
        }
        if (Modifier.isFinal(returnType.getModifiers())) {
            return false;
        }
        boolean returnInterface = returnType.isInterface();
        if (!returnInterface) {
            try {
                returnType.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }
        return true;
    }

    public <T> T getRecordingProxy(final Class<T> theClass) {
        if (this.existingProxyClasses.containsKey(theClass)) {
            return theClass.cast(this.existingProxyClasses.get(theClass));
        }
        NewRecorder newRecorder = new NewRecorder(theClass);
        this.existingRecorderValues.put(theClass, newRecorder);
        InvocationHandler invocationHandler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (BytecodeRecorderImpl.this.staticInit) {
                    for (int i = 0; i < args.length; ++i) {
                        ReturnedProxy p;
                        if (!(args[i] instanceof ReturnedProxy) || (p = (ReturnedProxy)args[i]).__static$$init()) continue;
                        throw new RuntimeException("Invalid proxy passed to recorder. Parameter " + i + " of type " + method.getParameterTypes()[i] + " was created in a runtime recorder method, while this recorder is for a static init method. The object will not have been created at the time this method is run.");
                    }
                }
                StoredMethodCall storedMethodCall = new StoredMethodCall(theClass, method, args);
                BytecodeRecorderImpl.this.storedMethodCalls.add(storedMethodCall);
                Class<?> returnType = method.getReturnType();
                if (method.getName().equals("toString") && method.getParameterCount() == 0 && returnType.equals(String.class)) {
                    return proxy.getClass().getName();
                }
                boolean voidMethod = method.getReturnType().equals(Void.TYPE);
                if (!voidMethod && !BytecodeRecorderImpl.isProxiable(method.getReturnType())) {
                    throw new RuntimeException("Cannot use " + method + " as a recorder method as the return type cannot be proxied. Use RuntimeValue to wrap the return value instead.");
                }
                if (voidMethod) {
                    return null;
                }
                ProxyInstance instance = BytecodeRecorderImpl.this.getProxyInstance(returnType);
                if (instance == null) {
                    return null;
                }
                storedMethodCall.returnedProxy = instance.proxy;
                storedMethodCall.proxyId = instance.key;
                return instance.proxy;
            }
        };
        try {
            ProxyFactory<T> factory = RecordingProxyFactories.get(theClass);
            if (factory != null) {
                return factory.newInstance(invocationHandler);
            }
            String proxyNameSuffix = "$$RecordingProxyProxy" + COUNT.incrementAndGet();
            ProxyConfiguration proxyConfiguration = new ProxyConfiguration<T>().setSuperClass(theClass).setClassLoader(this.classLoader).setAnchorClass(this.getClass()).setProxyNameSuffix(proxyNameSuffix);
            factory = new ProxyFactory(proxyConfiguration);
            T recordingProxy = factory.newInstance(invocationHandler);
            this.existingProxyClasses.put(theClass, recordingProxy);
            RecordingProxyFactories.put(theClass, factory);
            return recordingProxy;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public void markClassAsConstructorRecordable(Class<?> clazz) {
        this.classesToUseRecordableConstructor.add(clazz);
    }

    private ProxyInstance getProxyInstance(Class<?> returnType) throws InstantiationException, IllegalAccessException {
        boolean returnInterface = returnType.isInterface();
        ProxyFactory<Object> proxyFactory = this.returnValueProxy.get(returnType);
        if (proxyFactory == null) {
            ProxyConfiguration<Object> proxyConfiguration = new ProxyConfiguration<Object>().setSuperClass(returnInterface ? Object.class : returnType).setClassLoader(this.classLoader).addAdditionalInterface(ReturnedProxy.class).setAnchorClass(this.getClass()).setProxyNameSuffix("$$ReturnValueProxy" + COUNT.incrementAndGet());
            if (returnInterface) {
                proxyConfiguration.addAdditionalInterface(returnType);
            }
            proxyFactory = new ProxyFactory<Object>(proxyConfiguration);
            this.returnValueProxy.put(returnType, proxyFactory);
        }
        String key = PROXY_KEY + COUNT.incrementAndGet();
        Object proxyInstance = proxyFactory.newInstance(new ReturnValueProxyInvocationHandler(key, returnType, this.staticInit));
        return new ProxyInstance(proxyInstance, key);
    }

    public String getClassName() {
        return this.className;
    }

    private Map.Entry<ClassCreator, MethodCreator> prepareBytecodeWriting(ClassOutput classOutput) {
        ClassCreator file = this.classCreatorFunction.apply(classOutput);
        MethodCreator mainMethod = this.methodCreatorFunction.apply(file);
        return new AbstractMap.SimpleEntry<ClassCreator, MethodCreator>(file, mainMethod);
    }

    public void writeBytecode(ClassOutput classOutput) {
        Map.Entry<ClassCreator, MethodCreator> entry = this.prepareBytecodeWriting(classOutput);
        ClassCreator file = entry.getKey();
        MethodCreator mainMethod = entry.getValue();
        HashMap classInstanceVariables = new HashMap();
        IdentityHashMap<Object, DeferredParameter> parameterMap = this.useIdentityComparison ? new IdentityHashMap() : new HashMap();
        for (BytecodeInstruction bytecodeInstruction : this.storedMethodCalls) {
            if (!(bytecodeInstruction instanceof StoredMethodCall)) continue;
            final StoredMethodCall call = (StoredMethodCall)bytecodeInstruction;
            if (!classInstanceVariables.containsKey(call.theClass)) {
                DeferredArrayStoreParameter value = new DeferredArrayStoreParameter(null, call.theClass){

                    @Override
                    ResultHandle createValue(MethodContext context, MethodCreator method, ResultHandle array) {
                        return method.newInstance(MethodDescriptor.ofConstructor(call.theClass, (Class[])new Class[0]), new ResultHandle[0]);
                    }
                };
                classInstanceVariables.put(call.theClass, value);
            }
            try {
                Class<?>[] parameterTypes = call.method.getParameterTypes();
                Annotation[][] parameterAnnotations = call.method.getParameterAnnotations();
                for (int i = 0; i < call.parameters.length; ++i) {
                    call.deferredParameters[i] = this.loadObjectInstance(call.parameters[i], parameterMap, parameterTypes[i], Arrays.stream(parameterAnnotations[i]).anyMatch(s -> s.annotationType() == RelaxedValidation.class));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to record call to method " + call.method, e);
            }
        }
        for (Map.Entry entry2 : this.existingRecorderValues.entrySet()) {
            ((NewRecorder)entry2.getValue()).preWrite(parameterMap);
        }
        this.loadComplete = true;
        MethodDescriptor createArrayDescriptor = MethodDescriptor.ofMethod((String)mainMethod.getMethodDescriptor().getDeclaringClass(), (String)CREATE_ARRAY, (String)"[Ljava/lang/Object;", (String[])new String[0]);
        ResultHandle resultHandle = mainMethod.invokeVirtualMethod(createArrayDescriptor, mainMethod.getThis(), new ResultHandle[0]);
        SplitMethodContext context = new SplitMethodContext(resultHandle, mainMethod, file);
        for (NewRecorder i : this.existingRecorderValues.values()) {
            i.prepare(context);
        }
        for (final BytecodeInstruction set : this.storedMethodCalls) {
            if (set instanceof StoredMethodCall) {
                final StoredMethodCall call = (StoredMethodCall)set;
                for (int i = 0; i < call.parameters.length; ++i) {
                    call.deferredParameters[i].prepare(context);
                }
                final DeferredArrayStoreParameter recorderInstance = this.existingRecorderValues.get(call.theClass);
                recorderInstance.prepare(context);
                context.writeInstruction(new InstructionGroup(){

                    @Override
                    public void write(MethodContext context, MethodCreator method, ResultHandle array) {
                        ResultHandle[] params = new ResultHandle[call.parameters.length];
                        for (int i = 0; i < call.parameters.length; ++i) {
                            params[i] = context.loadDeferred(call.deferredParameters[i]);
                        }
                        ResultHandle callResult = method.invokeVirtualMethod(MethodDescriptor.ofMethod(call.method.getDeclaringClass(), (String)call.method.getName(), call.method.getReturnType(), (Class[])call.method.getParameterTypes()), context.loadDeferred(recorderInstance), params);
                        if (call.method.getReturnType() != Void.TYPE && call.returnedProxy != null) {
                            method.invokeVirtualMethod(MethodDescriptor.ofMethod(StartupContext.class, (String)"putValue", Void.TYPE, (Class[])new Class[]{String.class, Object.class}), method.getMethodParam(0), new ResultHandle[]{method.load(call.proxyId), callResult});
                        }
                    }
                });
                continue;
            }
            if (set instanceof NewInstance) {
                context.writeInstruction(new InstructionGroup(){

                    @Override
                    public void write(MethodContext context, MethodCreator method, ResultHandle array) {
                        NewInstance ni = (NewInstance)set;
                        ResultHandle val = method.newInstance(MethodDescriptor.ofConstructor((String)ni.theClass, (String[])new String[0]), new ResultHandle[0]);
                        ResultHandle rv = method.newInstance(MethodDescriptor.ofConstructor(RuntimeValue.class, (Class[])new Class[]{Object.class}), new ResultHandle[]{val});
                        method.invokeVirtualMethod(MethodDescriptor.ofMethod(StartupContext.class, (String)"putValue", Void.TYPE, (Class[])new Class[]{String.class, Object.class}), method.getMethodParam(0), new ResultHandle[]{method.load(ni.proxyId), rv});
                    }
                });
                continue;
            }
            throw new RuntimeException("unknown type " + set);
        }
        context.close();
        mainMethod.returnValue(null);
        MethodCreator createArray = file.getMethodCreator(createArrayDescriptor);
        createArray.returnValue(createArray.newArray(Object.class, this.deferredParameterCount));
        file.close();
    }

    private DeferredParameter loadObjectInstance(Object param, Map<Object, DeferredParameter> existing, Class<?> expectedType, boolean relaxedValidation) {
        if (this.loadComplete) {
            throw new RuntimeException("All parameters have already been loaded, it is too late to call loadObjectInstance");
        }
        if (existing.containsKey(param)) {
            return existing.get(param);
        }
        DeferredParameter ret = this.loadObjectInstanceImpl(param, existing, expectedType, relaxedValidation);
        existing.put(param, ret);
        return ret;
    }

    private DeferredParameter loadObjectInstanceImpl(final Object param, Map<Object, DeferredParameter> existing, final Class<?> expectedType, boolean relaxedValidation) {
        if (param == null) {
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext creator, MethodCreator method, ResultHandle array) {
                    return method.loadNull();
                }
            };
        }
        DeferredParameter loadedObject = this.findLoaded(param);
        if (loadedObject != null) {
            return loadedObject;
        }
        loadedObject = this.handleCollectionsObjects(param, existing, relaxedValidation);
        if (loadedObject != null) {
            return loadedObject;
        }
        if (this.substitutions.containsKey(param.getClass()) || this.substitutions.containsKey(expectedType)) {
            SubstitutionHolder holder = this.substitutions.get(param.getClass());
            if (holder == null) {
                holder = this.substitutions.get(expectedType);
            }
            try {
                ObjectSubstitution<?, ?> substitution = holder.sub.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Object res = substitution.serialize(param);
                final DeferredParameter serialized = this.loadObjectInstance(res, existing, holder.to, relaxedValidation);
                final SubstitutionHolder finalHolder = holder;
                return new DeferredArrayStoreParameter(param, expectedType){

                    @Override
                    void doPrepare(MethodContext context) {
                        serialized.prepare(context);
                        super.doPrepare(context);
                    }

                    @Override
                    ResultHandle createValue(MethodContext creator, MethodCreator method, ResultHandle array) {
                        ResultHandle subInstance = method.newInstance(MethodDescriptor.ofConstructor(finalHolder.sub, (Class[])new Class[0]), new ResultHandle[0]);
                        return method.invokeInterfaceMethod(MethodDescriptor.ofMethod(ObjectSubstitution.class, (String)"deserialize", Object.class, (Class[])new Class[]{Object.class}), subInstance, new ResultHandle[]{creator.loadDeferred(serialized)});
                    }
                };
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to substitute " + param, e);
            }
        }
        if (param instanceof Optional) {
            Optional val = (Optional)param;
            if (val.isPresent()) {
                final DeferredParameter res = this.loadObjectInstance(val.get(), existing, Object.class, relaxedValidation);
                return new DeferredArrayStoreParameter(param, expectedType){

                    @Override
                    void doPrepare(MethodContext context) {
                        res.prepare(context);
                        super.doPrepare(context);
                    }

                    @Override
                    ResultHandle createValue(MethodContext context, MethodCreator method, ResultHandle array) {
                        return method.invokeStaticMethod(MethodDescriptor.ofMethod(Optional.class, (String)"ofNullable", Optional.class, (Class[])new Class[]{Object.class}), new ResultHandle[]{context.loadDeferred(res)});
                    }
                };
            }
            return new DeferredArrayStoreParameter(param, (Class)expectedType){

                @Override
                ResultHandle createValue(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.invokeStaticMethod(MethodDescriptor.ofMethod(Optional.class, (String)"empty", Optional.class, (Class[])new Class[0]), new ResultHandle[0]);
                }
            };
        }
        if (param instanceof String) {
            if (((String)param).length() > 65535) {
                throw new RuntimeException("String too large to record: " + param);
            }
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.load((String)param);
                }
            };
        }
        if (param instanceof URL) {
            final String url = ((URL)param).toExternalForm();
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    AssignableResultHandle value = method.createVariable(URL.class);
                    try (TryBlock et = method.tryBlock();){
                        et.assign(value, et.newInstance(MethodDescriptor.ofConstructor(URL.class, (Class[])new Class[]{String.class}), new ResultHandle[]{et.load(url)}));
                        try (CatchBlockCreator malformed = et.addCatch(MalformedURLException.class);){
                            malformed.throwException(RuntimeException.class, "Malformed URL", malformed.getCaughtException());
                        }
                    }
                    return value;
                }
            };
        }
        if (param instanceof Enum) {
            final Enum e = (Enum)param;
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    ResultHandle nm = method.load(e.name());
                    return method.invokeStaticMethod(MethodDescriptor.ofMethod(e.getDeclaringClass(), (String)"valueOf", e.getDeclaringClass(), (Class[])new Class[]{String.class}), new ResultHandle[]{nm});
                }
            };
        }
        if (param instanceof ReturnedProxy) {
            ReturnedProxy rp = (ReturnedProxy)param;
            if (!rp.__static$$init() && this.staticInit) {
                throw new RuntimeException("Invalid proxy passed to recorder. " + rp + " was created in a runtime recorder method, while this recorder is for a static init method. The object will not have been created at the time this method is run.");
            }
            final String proxyId = rp.__returned$proxy$key();
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.invokeVirtualMethod(MethodDescriptor.ofMethod(StartupContext.class, (String)"getValue", Object.class, (Class[])new Class[]{String.class}), method.getMethodParam(0), new ResultHandle[]{method.load(proxyId)});
                }
            };
        }
        if (param instanceof Duration) {
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.invokeStaticMethod(MethodDescriptor.ofMethod(Duration.class, (String)"parse", Duration.class, (Class[])new Class[]{CharSequence.class}), new ResultHandle[]{method.load(param.toString())});
                }
            };
        }
        if (param instanceof Class) {
            if (!((Class)param).isPrimitive()) {
                String name = this.classProxies.get(param);
                if (name == null) {
                    name = ((Class)param).getName();
                }
                final String finalName = name;
                return new DeferredParameter(){

                    @Override
                    ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                        ResultHandle currentThread = method.invokeStaticMethod(MethodDescriptor.ofMethod(Thread.class, (String)"currentThread", Thread.class, (Class[])new Class[0]), new ResultHandle[0]);
                        ResultHandle tccl = method.invokeVirtualMethod(MethodDescriptor.ofMethod(Thread.class, (String)"getContextClassLoader", ClassLoader.class, (Class[])new Class[0]), currentThread, new ResultHandle[0]);
                        return method.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class, Boolean.TYPE, ClassLoader.class}), new ResultHandle[]{method.load(finalName), method.load(true), tccl});
                    }
                };
            }
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.loadClassFromTCCL((Class)param);
                }
            };
        }
        if (expectedType == Boolean.TYPE || expectedType == Boolean.class || param instanceof Boolean) {
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.load(((Boolean)param).booleanValue());
                }
            };
        }
        if (expectedType == Integer.TYPE || expectedType == Integer.class || param instanceof Integer) {
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.load(((Integer)param).intValue());
                }
            };
        }
        if (expectedType == Short.TYPE || expectedType == Short.class || param instanceof Short) {
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.load(((Short)param).shortValue());
                }
            };
        }
        if (expectedType == Byte.TYPE || expectedType == Byte.class || param instanceof Byte) {
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.load(((Byte)param).byteValue());
                }
            };
        }
        if (expectedType == Character.TYPE || expectedType == Character.class || param instanceof Character) {
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.load(((Character)param).charValue());
                }
            };
        }
        if (expectedType == Long.TYPE || expectedType == Long.class || param instanceof Long) {
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.load(((Long)param).longValue());
                }
            };
        }
        if (expectedType == Float.TYPE || expectedType == Float.class || param instanceof Float) {
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.load(((Float)param).floatValue());
                }
            };
        }
        if (expectedType == Double.TYPE || expectedType == Double.class || param instanceof Double) {
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.load(((Double)param).doubleValue());
                }
            };
        }
        if (expectedType.isArray()) {
            final int length = Array.getLength(param);
            final DeferredParameter[] components = new DeferredParameter[length];
            for (int i = 0; i < length; ++i) {
                DeferredParameter component;
                components[i] = component = this.loadObjectInstance(Array.get(param, i), existing, expectedType.getComponentType(), relaxedValidation);
            }
            return new DeferredArrayStoreParameter(param, expectedType){

                @Override
                void doPrepare(MethodContext context) {
                    for (int i = 0; i < length; ++i) {
                        components[i].prepare(context);
                    }
                    super.doPrepare(context);
                }

                @Override
                ResultHandle createValue(MethodContext context, MethodCreator method, ResultHandle array) {
                    ResultHandle out = method.newArray(expectedType.getComponentType(), length);
                    for (int i = 0; i < length; ++i) {
                        method.writeArrayValue(out, i, context.loadDeferred(components[i]));
                    }
                    return out;
                }
            };
        }
        if (param instanceof AnnotationProxyProvider.AnnotationProxy) {
            final AnnotationProxyProvider.AnnotationProxy annotationProxy = (AnnotationProxyProvider.AnnotationProxy)param;
            final List constructorParams = annotationProxy.getAnnotationClass().methods().stream().filter(m -> !m.name().equals("<clinit>") && !m.name().equals("<init>")).collect(Collectors.toList());
            Map annotationValues = annotationProxy.getAnnotationInstance().values().stream().collect(Collectors.toMap(AnnotationValue::name, Function.identity()));
            final DeferredParameter[] constructorParamsHandles = new DeferredParameter[constructorParams.size()];
            ListIterator iterator = constructorParams.listIterator();
            while (iterator.hasNext()) {
                DeferredParameter retValue;
                MethodInfo valueMethod = (MethodInfo)iterator.next();
                Object explicitValue = annotationProxy.getValues().get(valueMethod.name());
                if (explicitValue != null) {
                    constructorParamsHandles[iterator.previousIndex()] = this.loadObjectInstance(explicitValue, existing, explicitValue.getClass(), relaxedValidation);
                    continue;
                }
                AnnotationValue value = (AnnotationValue)annotationValues.get(valueMethod.name());
                if (value == null) {
                    Object defaultValue = annotationProxy.getDefaultValues().get(valueMethod.name());
                    if (defaultValue != null) {
                        constructorParamsHandles[iterator.previousIndex()] = this.loadObjectInstance(defaultValue, existing, defaultValue.getClass(), relaxedValidation);
                        continue;
                    }
                    if (value == null) {
                        value = valueMethod.defaultValue();
                    }
                }
                if (value == null) {
                    throw new NullPointerException("Value not set for " + param);
                }
                constructorParamsHandles[iterator.previousIndex()] = retValue = this.loadValue(value, annotationProxy.getAnnotationClass(), valueMethod);
            }
            return new DeferredArrayStoreParameter(annotationProxy.getAnnotationLiteralType()){

                @Override
                ResultHandle createValue(MethodContext context, MethodCreator method, ResultHandle array) {
                    MethodDescriptor constructor = MethodDescriptor.ofConstructor((Object)annotationProxy.getAnnotationLiteralType(), (Object[])constructorParams.stream().map(m -> m.returnType().name().toString()).toArray());
                    ResultHandle[] args = new ResultHandle[constructorParamsHandles.length];
                    for (int i = 0; i < constructorParamsHandles.length; ++i) {
                        DeferredParameter deferredParameter = constructorParamsHandles[i];
                        if (deferredParameter instanceof DeferredArrayStoreParameter) {
                            DeferredArrayStoreParameter arrayParam = (DeferredArrayStoreParameter)deferredParameter;
                            arrayParam.doPrepare(context);
                        }
                        args[i] = context.loadDeferred(deferredParameter);
                    }
                    return method.newInstance(constructor, args);
                }
            };
        }
        return this.loadComplexObject(param, existing, expectedType, relaxedValidation);
    }

    private DeferredParameter handleCollectionsObjects(Object param, Map<Object, DeferredParameter> existing, boolean relaxedValidation) {
        if (param instanceof Collection) {
            if (param.getClass().equals(Collections.emptyList().getClass())) {
                return new DeferredParameter(){

                    @Override
                    ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                        return method.invokeStaticMethod(MethodDescriptor.ofMethod(Collections.class, (String)"emptyList", List.class, (Class[])new Class[0]), new ResultHandle[0]);
                    }
                };
            }
            if (param.getClass().equals(Collections.emptySet().getClass())) {
                return new DeferredParameter(){

                    @Override
                    ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                        return method.invokeStaticMethod(MethodDescriptor.ofMethod(Collections.class, (String)"emptySet", Set.class, (Class[])new Class[0]), new ResultHandle[0]);
                    }
                };
            }
            if (param.getClass().equals(Collections.emptySortedSet().getClass())) {
                return new DeferredParameter(){

                    @Override
                    ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                        return method.invokeStaticMethod(MethodDescriptor.ofMethod(Collections.class, (String)"emptySortedSet", SortedSet.class, (Class[])new Class[0]), new ResultHandle[0]);
                    }
                };
            }
            if (param.getClass().equals(Collections.emptyNavigableSet().getClass())) {
                return new DeferredParameter(){

                    @Override
                    ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                        return method.invokeStaticMethod(MethodDescriptor.ofMethod(Collections.class, (String)"emptyNavigableSet", NavigableSet.class, (Class[])new Class[0]), new ResultHandle[0]);
                    }
                };
            }
            if (param.getClass().equals(SINGLETON_LIST_CLASS)) {
                final DeferredParameter deferred = this.loadObjectInstance(((List)param).get(0), existing, Object.class, relaxedValidation);
                return new DeferredParameter(){

                    @Override
                    void doPrepare(MethodContext context) {
                        super.doPrepare(context);
                        deferred.doPrepare(context);
                    }

                    @Override
                    ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                        ResultHandle res = context.loadDeferred(deferred);
                        return method.invokeStaticMethod(MethodDescriptor.ofMethod(Collections.class, (String)"singletonList", List.class, (Class[])new Class[]{Object.class}), new ResultHandle[]{res});
                    }
                };
            }
            if (param.getClass().equals(SINGLETON_SET_CLASS)) {
                final DeferredParameter deferred = this.loadObjectInstance(((Set)param).iterator().next(), existing, Object.class, relaxedValidation);
                return new DeferredParameter(){

                    @Override
                    void doPrepare(MethodContext context) {
                        super.doPrepare(context);
                        deferred.doPrepare(context);
                    }

                    @Override
                    ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                        ResultHandle res = context.loadDeferred(deferred);
                        return method.invokeStaticMethod(MethodDescriptor.ofMethod(Collections.class, (String)"singleton", Set.class, (Class[])new Class[]{Object.class}), new ResultHandle[]{res});
                    }
                };
            }
        } else if (param instanceof Map) {
            if (param.getClass().equals(Collections.emptyMap().getClass())) {
                return new DeferredParameter(){

                    @Override
                    ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                        return method.invokeStaticMethod(MethodDescriptor.ofMethod(Collections.class, (String)"emptyMap", Map.class, (Class[])new Class[0]), new ResultHandle[0]);
                    }
                };
            }
            if (param.getClass().equals(Collections.emptySortedMap().getClass())) {
                return new DeferredParameter(){

                    @Override
                    ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                        return method.invokeStaticMethod(MethodDescriptor.ofMethod(Collections.class, (String)"emptySortedMap", SortedMap.class, (Class[])new Class[0]), new ResultHandle[0]);
                    }
                };
            }
            if (param.getClass().equals(Collections.emptyNavigableMap().getClass())) {
                return new DeferredParameter(){

                    @Override
                    ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                        return method.invokeStaticMethod(MethodDescriptor.ofMethod(Collections.class, (String)"emptyNavigableMap", SortedMap.class, (Class[])new Class[0]), new ResultHandle[0]);
                    }
                };
            }
            if (param.getClass().equals(SINGLETON_MAP_CLASS)) {
                Map.Entry entry = ((Map)param).entrySet().iterator().next();
                final DeferredParameter key = this.loadObjectInstance(entry.getKey(), existing, Object.class, relaxedValidation);
                final DeferredParameter value = this.loadObjectInstance(entry.getValue(), existing, Object.class, relaxedValidation);
                return new DeferredParameter(){

                    @Override
                    void doPrepare(MethodContext context) {
                        super.doPrepare(context);
                        key.doPrepare(context);
                        value.doPrepare(context);
                    }

                    @Override
                    ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                        ResultHandle k = context.loadDeferred(key);
                        ResultHandle v = context.loadDeferred(value);
                        return method.invokeStaticMethod(MethodDescriptor.ofMethod(Collections.class, (String)"singletonMap", Map.class, (Class[])new Class[]{Object.class, Object.class}), new ResultHandle[]{k, v});
                    }
                };
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private DeferredParameter loadComplexObject(final Object param, Map<Object, DeferredParameter> existing, Class<?> expectedType, boolean relaxedValidation) {
        void var9_16;
        Integer ctorParamIndex;
        final ArrayList<SerializationStep> setupSteps = new ArrayList<SerializationStep>();
        final ArrayList<SerializationStep> ctorSetupSteps = new ArrayList<SerializationStep>();
        boolean relaxedOk = false;
        if (param instanceof Collection) {
            for (Object e : (Collection)param) {
                final DeferredParameter val = e != null ? this.loadObjectInstance(e, existing, e.getClass(), relaxedValidation) : this.loadObjectInstance(null, existing, Object.class, relaxedValidation);
                setupSteps.add(new SerializationStep(){

                    @Override
                    public void handle(MethodContext context, MethodCreator method, DeferredArrayStoreParameter out) {
                        method.invokeInterfaceMethod(COLLECTION_ADD, context.loadDeferred(out), new ResultHandle[]{context.loadDeferred(val)});
                    }

                    @Override
                    public void prepare(MethodContext context) {
                        val.prepare(context);
                    }
                });
            }
            relaxedOk = true;
        }
        if (param instanceof Map) {
            for (Map.Entry entry : ((Map)param).entrySet()) {
                final DeferredParameter key = entry.getKey() != null ? this.loadObjectInstance(entry.getKey(), existing, entry.getKey().getClass(), relaxedValidation) : this.loadObjectInstance(null, existing, Object.class, relaxedValidation);
                final DeferredParameter val = entry.getValue() != null ? this.loadObjectInstance(entry.getValue(), existing, entry.getValue().getClass(), relaxedValidation) : this.loadObjectInstance(null, existing, Object.class, relaxedValidation);
                setupSteps.add(new SerializationStep(){

                    @Override
                    public void handle(MethodContext context, MethodCreator method, DeferredArrayStoreParameter out) {
                        method.invokeInterfaceMethod(MAP_PUT, context.loadDeferred(out), new ResultHandle[]{context.loadDeferred(key), context.loadDeferred(val)});
                    }

                    @Override
                    public void prepare(MethodContext context) {
                        key.prepare(context);
                        val.prepare(context);
                    }
                });
            }
            relaxedOk = true;
        }
        NonDefaultConstructorHolder nonDefaultConstructorHolder = null;
        Object var9_12 = null;
        HashMap<String, Integer> constructorParamNameMap = new HashMap<String, Integer>();
        if (this.nonDefaultConstructors.containsKey(param.getClass())) {
            nonDefaultConstructorHolder = this.nonDefaultConstructors.get(param.getClass());
            List<Object> params = nonDefaultConstructorHolder.paramGenerator.apply(param);
            if (params.size() != nonDefaultConstructorHolder.constructor.getParameterCount()) {
                throw new RuntimeException("Unable to serialize " + param + " as the wrong number of parameters were generated for " + nonDefaultConstructorHolder.constructor);
            }
            int count = 0;
            DeferredParameter[] deferredParameterArray = new DeferredParameter[params.size()];
            GenericDeclaration[] parameterTypes = nonDefaultConstructorHolder.constructor.getParameterTypes();
            for (int i = 0; i < params.size(); ++i) {
                Object obj = params.get(i);
                deferredParameterArray[i] = this.loadObjectInstance(obj, existing, (Class<?>)parameterTypes[count++], relaxedValidation);
            }
            if (nonDefaultConstructorHolder.constructor.getParameterCount() > 0) {
                Parameter[] parameters = nonDefaultConstructorHolder.constructor.getParameters();
                for (int i = 0; i < parameters.length; ++i) {
                    if (!parameters[i].isNamePresent()) continue;
                    String name = parameters[i].getName();
                    constructorParamNameMap.put(name, i);
                }
            }
        } else if (this.classesToUseRecordableConstructor.contains(param.getClass())) {
            Constructor<?> current = null;
            int count = 0;
            for (Constructor<?> c : param.getClass().getConstructors()) {
                if (current == null || current.getParameterCount() < c.getParameterCount()) {
                    current = c;
                    count = 0;
                    continue;
                }
                if (current == null || current.getParameterCount() != c.getParameterCount()) continue;
                ++count;
            }
            if (current == null || count > 0) {
                throw new RuntimeException("Unable to determine the recordable constructor to use for " + param.getClass());
            }
            nonDefaultConstructorHolder = new NonDefaultConstructorHolder(current, null);
            DeferredParameter[] deferredParameterArray = new DeferredParameter[current.getParameterCount()];
            if (current.getParameterCount() > 0) {
                parameters = current.getParameters();
                for (int i = 0; i < parameters.length; ++i) {
                    if (!((Parameter)parameters[i]).isNamePresent()) continue;
                    String name = ((Parameter)parameters[i]).getName();
                    constructorParamNameMap.put(name, i);
                }
            }
        } else {
            Constructor<?>[] ctors = param.getClass().getConstructors();
            Constructor<?> selectedCtor = null;
            if (ctors.length == 1) {
                selectedCtor = ctors[0];
            }
            parameters = ctors;
            int i = parameters.length;
            for (int name = 0; name < i; ++name) {
                Constructor<?> ctor = parameters[name];
                if (!RecordingAnnotationsUtil.isRecordableConstructor(ctor)) continue;
                selectedCtor = ctor;
                break;
            }
            if (selectedCtor != null) {
                nonDefaultConstructorHolder = new NonDefaultConstructorHolder(selectedCtor, null);
                DeferredParameter[] deferredParameterArray = new DeferredParameter[selectedCtor.getParameterCount()];
                if (selectedCtor.getParameterCount() > 0) {
                    Parameter[] ctorParameters = selectedCtor.getParameters();
                    for (i = 0; i < ctorParameters.length; ++i) {
                        if (!ctorParameters[i].isNamePresent()) continue;
                        String name = ctorParameters[i].getName();
                        constructorParamNameMap.put(name, i);
                    }
                }
            }
        }
        HashSet<String> handledProperties = new HashSet<String>();
        PropertyUtils.Property[] desc = PropertyUtils.getPropertyDescriptors(param);
        FieldsHelper fieldsHelper = new FieldsHelper(param.getClass());
        for (final PropertyUtils.Property i : desc) {
            Object propertyValue;
            Field field;
            if (!i.getDeclaringClass().getPackageName().startsWith("java.") && (i.getReadMethod() != null && RecordingAnnotationsUtil.isIgnored(i.getReadMethod()) || (field = fieldsHelper.getDeclaredField(i.getName())) != null && BytecodeRecorderImpl.ignoreField(field))) continue;
            ctorParamIndex = (Integer)constructorParamNameMap.remove(i.name);
            if (i.getReadMethod() != null && i.getWriteMethod() == null && ctorParamIndex == null) {
                try {
                    if (Collection.class.isAssignableFrom(i.getPropertyType())) {
                        handledProperties.add(i.getName());
                        propertyValue = (Collection)i.read(param);
                        if (propertyValue == null || propertyValue.isEmpty()) continue;
                        final ArrayList<DeferredParameter> params = new ArrayList<DeferredParameter>();
                        Iterator<Object> iterator = propertyValue.iterator();
                        while (iterator.hasNext()) {
                            Object e = iterator.next();
                            DeferredParameter toAdd = this.loadObjectInstance(e, existing, Object.class, relaxedValidation);
                            params.add(toAdd);
                        }
                        setupSteps.add(new SerializationStep(){

                            @Override
                            public void handle(MethodContext context, MethodCreator method, DeferredArrayStoreParameter out) {
                                ResultHandle prop = i.getReadMethod().isDefault() ? method.invokeInterfaceMethod(MethodDescriptor.ofMethod((Method)i.getReadMethod()), context.loadDeferred(out), new ResultHandle[0]) : method.invokeVirtualMethod(MethodDescriptor.ofMethod((Method)i.getReadMethod()), context.loadDeferred(out), new ResultHandle[0]);
                                for (DeferredParameter i2 : params) {
                                    method.invokeInterfaceMethod(COLLECTION_ADD, prop, new ResultHandle[]{context.loadDeferred(i2)});
                                }
                            }

                            @Override
                            public void prepare(MethodContext context) {
                                for (DeferredParameter i2 : params) {
                                    i2.prepare(context);
                                }
                            }
                        });
                        continue;
                    }
                    if (Map.class.isAssignableFrom(i.getPropertyType())) {
                        handledProperties.add(i.getName());
                        Map propertyValue2 = (Map)i.read(param);
                        if (propertyValue2 == null || propertyValue2.isEmpty()) continue;
                        final LinkedHashMap<DeferredParameter, DeferredParameter> def = new LinkedHashMap<DeferredParameter, DeferredParameter>();
                        for (Map.Entry entry : propertyValue2.entrySet()) {
                            DeferredParameter key = this.loadObjectInstance(entry.getKey(), existing, Object.class, relaxedValidation);
                            DeferredParameter val = this.loadObjectInstance(entry.getValue(), existing, Object.class, relaxedValidation);
                            def.put(key, val);
                        }
                        setupSteps.add(new SerializationStep(){

                            @Override
                            public void handle(MethodContext context, MethodCreator method, DeferredArrayStoreParameter out) {
                                ResultHandle prop = method.invokeVirtualMethod(MethodDescriptor.ofMethod((Method)i.getReadMethod()), context.loadDeferred(out), new ResultHandle[0]);
                                for (Map.Entry e : def.entrySet()) {
                                    method.invokeInterfaceMethod(MAP_PUT, prop, new ResultHandle[]{context.loadDeferred((DeferredParameter)e.getKey()), context.loadDeferred((DeferredParameter)e.getValue())});
                                }
                            }

                            @Override
                            public void prepare(MethodContext context) {
                                for (Map.Entry e : def.entrySet()) {
                                    ((DeferredParameter)e.getKey()).prepare(context);
                                    ((DeferredParameter)e.getValue()).prepare(context);
                                }
                            }
                        });
                        continue;
                    }
                    if (relaxedValidation || i.getName().equals("class") || relaxedOk || nonDefaultConstructorHolder != null) continue;
                    try {
                        i.getReadMethod().getDeclaringClass().getDeclaredField(i.getName());
                        throw new RuntimeException("Cannot serialise field '" + i.getName() + "' on object '" + param + "' as the property is read only");
                    }
                    catch (NoSuchFieldException propertyValue2) {
                        continue;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (i.getReadMethod() == null || i.getWriteMethod() == null && ctorParamIndex == null) continue;
            try {
                Class<?> clazz;
                Class<?> getterReturnType;
                handledProperties.add(i.getName());
                propertyValue = i.read(param);
                if (propertyValue == null && ctorParamIndex == null) continue;
                Class<?> propertyType = i.getPropertyType();
                if (ctorParamIndex == null && (getterReturnType = i.getReadMethod().getReturnType()) != (clazz = i.getWriteMethod().getParameterTypes()[0])) {
                    if (relaxedValidation) {
                        for (Method m : param.getClass().getMethods()) {
                            Class<?>[] parameterTypes;
                            if (!m.getName().equals(i.getWriteMethod().getName()) || m.getParameterCount() <= 0 || !(parameterTypes = m.getParameterTypes())[0].isAssignableFrom(param.getClass())) continue;
                            propertyType = parameterTypes[0];
                            break;
                        }
                    } else {
                        throw new RuntimeException("Cannot serialise field '" + i.getName() + "' on object '" + param + "' of type '" + param.getClass().getName() + "' as getter and setter are of different types. Getter type is '" + getterReturnType.getName() + "' while setter type is '" + clazz.getName() + "'.");
                    }
                }
                final DeferredParameter val = this.loadObjectInstance(propertyValue, existing, i.getPropertyType(), relaxedValidation);
                if (ctorParamIndex != null) {
                    var9_16[ctorParamIndex.intValue()] = val;
                    ctorSetupSteps.add(new SerializationStep(){

                        @Override
                        public void handle(MethodContext context, MethodCreator method, DeferredArrayStoreParameter out) {
                        }

                        @Override
                        public void prepare(MethodContext context) {
                            val.prepare(context);
                        }
                    });
                    continue;
                }
                final Class<?> clazz2 = propertyType;
                setupSteps.add(new SerializationStep(){

                    @Override
                    public void handle(MethodContext context, MethodCreator method, DeferredArrayStoreParameter out) {
                        ResultHandle object = context.loadDeferred(out);
                        ResultHandle resultVal = context.loadDeferred(val);
                        method.invokeVirtualMethod(MethodDescriptor.ofMethod(param.getClass(), (String)i.getWriteMethod().getName(), i.getWriteMethod().getReturnType(), (Class[])new Class[]{clazz2}), object, new ResultHandle[]{resultVal});
                    }

                    @Override
                    public void prepare(MethodContext context) {
                        val.prepare(context);
                    }
                });
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        for (final Field field : param.getClass().getFields()) {
            if (BytecodeRecorderImpl.ignoreField(field) || handledProperties.contains(field.getName()) || (ctorParamIndex = (Integer)constructorParamNameMap.remove(field.getName())) == null && Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
            try {
                final DeferredParameter val = this.loadObjectInstance(field.get(param), existing, field.getType(), relaxedValidation);
                if (ctorParamIndex != null) {
                    var9_16[ctorParamIndex.intValue()] = val;
                    ctorSetupSteps.add(new SerializationStep(){

                        @Override
                        public void handle(MethodContext context, MethodCreator method, DeferredArrayStoreParameter out) {
                        }

                        @Override
                        public void prepare(MethodContext context) {
                            val.prepare(context);
                        }
                    });
                    continue;
                }
                setupSteps.add(new SerializationStep(){

                    @Override
                    public void handle(MethodContext context, MethodCreator method, DeferredArrayStoreParameter out) {
                        method.writeInstanceField(FieldDescriptor.of(param.getClass(), (String)field.getName(), field.getType()), context.loadDeferred(out), context.loadDeferred(val));
                    }

                    @Override
                    public void prepare(MethodContext context) {
                        val.prepare(context);
                    }
                });
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (!constructorParamNameMap.isEmpty()) {
            throw new RuntimeException("Could not find parameters for constructor " + nonDefaultConstructorHolder.constructor + " could not read field values " + constructorParamNameMap.keySet());
        }
        final NonDefaultConstructorHolder finalNonDefaultConstructorHolder = nonDefaultConstructorHolder;
        void finalCtorHandles = var9_16;
        final DeferredArrayStoreParameter objectValue = new DeferredArrayStoreParameter(param, expectedType, (DeferredParameter[])finalCtorHandles, param, expectedType){
            final /* synthetic */ DeferredParameter[] val$finalCtorHandles;
            final /* synthetic */ Object val$param;
            final /* synthetic */ Class val$expectedType;
            {
                this.val$finalCtorHandles = deferredParameterArray;
                this.val$param = object;
                this.val$expectedType = clazz;
                super(target, expectedType);
            }

            @Override
            ResultHandle createValue(MethodContext context, MethodCreator method, ResultHandle array) {
                ResultHandle out;
                if (finalNonDefaultConstructorHolder != null) {
                    out = method.newInstance(MethodDescriptor.ofConstructor(finalNonDefaultConstructorHolder.constructor.getDeclaringClass(), (Class[])finalNonDefaultConstructorHolder.constructor.getParameterTypes()), (ResultHandle[])Arrays.stream(this.val$finalCtorHandles).map(m -> context.loadDeferred((DeferredParameter)m)).toArray(ResultHandle[]::new));
                } else if (List.class.isAssignableFrom(this.val$param.getClass()) && this.val$expectedType == List.class) {
                    List listParam = (List)this.val$param;
                    out = listParam.isEmpty() ? method.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]) : method.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{method.load(listParam.size())});
                } else {
                    try {
                        this.val$param.getClass().getDeclaredConstructor(new Class[0]);
                        out = method.newInstance(MethodDescriptor.ofConstructor(this.val$param.getClass(), (Class[])new Class[0]), new ResultHandle[0]);
                    }
                    catch (NoSuchMethodException e) {
                        if (SortedMap.class.isAssignableFrom(this.val$expectedType)) {
                            out = method.newInstance(MethodDescriptor.ofConstructor(TreeMap.class, (Class[])new Class[0]), new ResultHandle[0]);
                        }
                        if (Map.class.isAssignableFrom(this.val$expectedType)) {
                            out = method.newInstance(MethodDescriptor.ofConstructor(LinkedHashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
                        }
                        if (List.class.isAssignableFrom(this.val$expectedType)) {
                            out = method.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
                        }
                        if (SortedSet.class.isAssignableFrom(this.val$expectedType)) {
                            out = method.newInstance(MethodDescriptor.ofConstructor(TreeSet.class, (Class[])new Class[0]), new ResultHandle[0]);
                        }
                        if (Set.class.isAssignableFrom(this.val$expectedType)) {
                            out = method.newInstance(MethodDescriptor.ofConstructor(LinkedHashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
                        }
                        throw new RuntimeException("Unable to serialize objects of type " + this.val$param.getClass() + " to bytecode as it has no default constructor");
                    }
                }
                return out;
            }
        };
        return new DeferredArrayStoreParameter(param, expectedType){

            @Override
            void doPrepare(MethodContext context) {
                for (final SerializationStep i : ctorSetupSteps) {
                    i.prepare(context);
                }
                objectValue.prepare(context);
                for (final SerializationStep i : setupSteps) {
                    i.prepare(context);
                    context.writeInstruction(new InstructionGroup(){

                        @Override
                        public void write(MethodContext context, MethodCreator method, ResultHandle array) {
                            i.handle(context, method, objectValue);
                        }
                    });
                }
                super.doPrepare(context);
            }

            @Override
            ResultHandle createValue(MethodContext context, MethodCreator method, ResultHandle array) {
                return context.loadDeferred(objectValue);
            }
        };
    }

    private static boolean ignoreField(Field field) {
        if (Modifier.isTransient(field.getModifiers())) {
            return true;
        }
        return RecordingAnnotationsUtil.isIgnored(field);
    }

    private DeferredParameter findLoaded(final Object param) {
        for (final ObjectLoader loader : this.loaders) {
            if (!loader.canHandleObject(param, this.staticInit)) continue;
            return new DeferredArrayStoreParameter(param, param.getClass()){

                @Override
                ResultHandle createValue(MethodContext context, MethodCreator method, ResultHandle array) {
                    return loader.load((BytecodeCreator)method, param, BytecodeRecorderImpl.this.staticInit);
                }
            };
        }
        return null;
    }

    private ConstantHolder<?> findConstantForParam(Type paramType) {
        ParameterizedType p;
        ConstantHolder<?> holder = null;
        if (paramType instanceof Class) {
            holder = this.constants.get(paramType);
        } else if (paramType instanceof ParameterizedType && (p = (ParameterizedType)paramType).getRawType() == RuntimeValue.class) {
            holder = this.constants.get(p.getActualTypeArguments()[0]);
        }
        return holder;
    }

    DeferredParameter loadValue(final AnnotationValue value, final ClassInfo annotationClass, final MethodInfo method) {
        return new DeferredParameter(){

            @Override
            ResultHandle doLoad(MethodContext context, MethodCreator valueMethod, ResultHandle array) {
                return switch (value.kind()) {
                    case AnnotationValue.Kind.BOOLEAN -> valueMethod.load(value.asBoolean());
                    case AnnotationValue.Kind.STRING -> valueMethod.load(value.asString());
                    case AnnotationValue.Kind.BYTE -> valueMethod.load(value.asByte());
                    case AnnotationValue.Kind.SHORT -> valueMethod.load(value.asShort());
                    case AnnotationValue.Kind.LONG -> valueMethod.load(value.asLong());
                    case AnnotationValue.Kind.INTEGER -> valueMethod.load(value.asInt());
                    case AnnotationValue.Kind.FLOAT -> valueMethod.load(value.asFloat());
                    case AnnotationValue.Kind.DOUBLE -> valueMethod.load(value.asDouble());
                    case AnnotationValue.Kind.CHARACTER -> valueMethod.load(value.asChar());
                    case AnnotationValue.Kind.CLASS -> valueMethod.loadClassFromTCCL(value.asClass().name().toString());
                    case AnnotationValue.Kind.ARRAY -> BytecodeRecorderImpl.arrayValue(value, (BytecodeCreator)valueMethod, method, annotationClass);
                    case AnnotationValue.Kind.ENUM -> valueMethod.readStaticField(FieldDescriptor.of((String)value.asEnumType().toString(), (String)value.asEnum(), (String)value.asEnumType().toString()));
                    default -> throw new UnsupportedOperationException("Unsupported value: " + value);
                };
            }
        };
    }

    static ResultHandle arrayValue(AnnotationValue value, BytecodeCreator valueMethod, MethodInfo method, ClassInfo annotationClass) {
        ResultHandle retValue;
        switch (value.componentKind()) {
            case CLASS: {
                org.jboss.jandex.Type[] classArray = value.asClassArray();
                retValue = valueMethod.newArray(BytecodeRecorderImpl.componentType(method), valueMethod.load(classArray.length));
                for (int i = 0; i < classArray.length; ++i) {
                    valueMethod.writeArrayValue(retValue, i, valueMethod.loadClassFromTCCL(classArray[i].name().toString()));
                }
                break;
            }
            case STRING: {
                String[] stringArray = value.asStringArray();
                retValue = valueMethod.newArray(BytecodeRecorderImpl.componentType(method), valueMethod.load(stringArray.length));
                for (int i = 0; i < stringArray.length; ++i) {
                    valueMethod.writeArrayValue(retValue, i, valueMethod.load(stringArray[i]));
                }
                break;
            }
            case INTEGER: {
                int[] intArray = value.asIntArray();
                retValue = valueMethod.newArray(BytecodeRecorderImpl.componentType(method), valueMethod.load(intArray.length));
                for (int i = 0; i < intArray.length; ++i) {
                    valueMethod.writeArrayValue(retValue, i, valueMethod.load(intArray[i]));
                }
                break;
            }
            case LONG: {
                long[] longArray = value.asLongArray();
                retValue = valueMethod.newArray(BytecodeRecorderImpl.componentType(method), valueMethod.load(longArray.length));
                for (int i = 0; i < longArray.length; ++i) {
                    valueMethod.writeArrayValue(retValue, i, valueMethod.load(longArray[i]));
                }
                break;
            }
            case BYTE: {
                byte[] byteArray = value.asByteArray();
                retValue = valueMethod.newArray(BytecodeRecorderImpl.componentType(method), valueMethod.load(byteArray.length));
                for (int i = 0; i < byteArray.length; ++i) {
                    valueMethod.writeArrayValue(retValue, i, valueMethod.load(byteArray[i]));
                }
                break;
            }
            case CHARACTER: {
                char[] charArray = value.asCharArray();
                retValue = valueMethod.newArray(BytecodeRecorderImpl.componentType(method), valueMethod.load(charArray.length));
                for (int i = 0; i < charArray.length; ++i) {
                    valueMethod.writeArrayValue(retValue, i, valueMethod.load(charArray[i]));
                }
                break;
            }
            case ENUM: {
                String[] enumArray = value.asEnumArray();
                retValue = valueMethod.newArray(BytecodeRecorderImpl.componentType(method), valueMethod.load(enumArray.length));
                String enumType = BytecodeRecorderImpl.componentType(method);
                for (int i = 0; i < enumArray.length; ++i) {
                    valueMethod.writeArrayValue(retValue, i, valueMethod.readStaticField(FieldDescriptor.of((String)enumType, (String)enumArray[i], (String)enumType)));
                }
                break;
            }
            default: {
                retValue = valueMethod.newArray(BytecodeRecorderImpl.componentType(method), valueMethod.load(0));
            }
        }
        return retValue;
    }

    static String componentType(MethodInfo method) {
        ArrayType arrayType = method.returnType().asArrayType();
        return arrayType.constituent().name().toString();
    }

    private boolean isAccessible(Class<?> expectedType) {
        if (!Modifier.isPublic(expectedType.getModifiers())) {
            return false;
        }
        if (expectedType.getPackage() == null) {
            return true;
        }
        return expectedType.getModule().isExported(expectedType.getPackage().getName());
    }

    static final class SubstitutionHolder {
        final Class<?> from;
        final Class<?> to;
        final Class<? extends ObjectSubstitution<?, ?>> sub;

        SubstitutionHolder(Class<?> from, Class<?> to, Class<? extends ObjectSubstitution<?, ?>> sub) {
            this.from = from;
            this.to = to;
            this.sub = sub;
        }
    }

    static final class NonDefaultConstructorHolder {
        final Constructor<?> constructor;
        final Function<Object, List<Object>> paramGenerator;

        NonDefaultConstructorHolder(Constructor<?> constructor, Function<Object, List<Object>> paramGenerator) {
            this.constructor = constructor;
            this.paramGenerator = paramGenerator;
        }
    }

    static final class ConstantHolder<T> {
        final Class<T> type;
        final T value;

        ConstantHolder(Class<T> type, T value) {
            this.type = type;
            this.value = value;
        }
    }

    private static final class ProxyInstance {
        final Object proxy;
        final String key;

        ProxyInstance(Object proxy, String key) {
            this.proxy = proxy;
            this.key = key;
        }
    }

    static final class NewInstance
    implements BytecodeInstruction {
        final String theClass;
        final Object returnedProxy;
        final String proxyId;

        NewInstance(String theClass, Object returnedProxy, String proxyId) {
            this.theClass = theClass;
            this.returnedProxy = returnedProxy;
            this.proxyId = proxyId;
        }
    }

    final class NewRecorder
    extends DeferredArrayStoreParameter {
        final Class<?> theClass;
        final Constructor<?> injectCtor;
        final List<DeferredParameter> deferredParameters;

        NewRecorder(Class<?> theClass) {
            super(theClass.getName());
            this.deferredParameters = new ArrayList<DeferredParameter>();
            this.theClass = theClass;
            Constructor<?> injectCtor = null;
            Constructor<?>[] ctors = theClass.getDeclaredConstructors();
            if (ctors.length == 1) {
                injectCtor = ctors[0];
            } else {
                for (Constructor<?> i : ctors) {
                    if (!i.isAnnotationPresent(Inject.class)) continue;
                    if (injectCtor == null) {
                        injectCtor = i;
                        continue;
                    }
                    throw new RuntimeException("Multiple @Inject constructors on " + theClass);
                }
                if (injectCtor == null) {
                    throw new RuntimeException("Could not determine constructor for " + theClass + " add @Inject to a constructor");
                }
            }
            this.injectCtor = injectCtor;
        }

        void preWrite(Map<Object, DeferredParameter> parameterMap) {
            if (this.injectCtor != null) {
                try {
                    Type[] parameterTypes = this.injectCtor.getGenericParameterTypes();
                    Annotation[][] parameterAnnotations = this.injectCtor.getParameterAnnotations();
                    for (int i = 0; i < parameterTypes.length; ++i) {
                        DeferredParameter result;
                        Type param = parameterTypes[i];
                        ConstantHolder<?> constantHolder = BytecodeRecorderImpl.this.findConstantForParam(param);
                        if (constantHolder != null) {
                            this.deferredParameters.add(BytecodeRecorderImpl.this.loadObjectInstance(constantHolder.value, parameterMap, constantHolder.type, Arrays.stream(parameterAnnotations[i]).anyMatch(s -> s.annotationType() == RelaxedValidation.class)));
                            continue;
                        }
                        Object obj = BytecodeRecorderImpl.this.configCreatorFunction.apply(param);
                        if (obj == null) {
                            throw new RuntimeException("Cannot inject type " + param);
                        }
                        if (obj instanceof RuntimeValue) {
                            if (!BytecodeRecorderImpl.this.staticInit) {
                                result = BytecodeRecorderImpl.this.findLoaded(((RuntimeValue)obj).getValue());
                                if (result == null) {
                                    throw new RuntimeException("Cannot inject object of type " + param);
                                }
                                this.deferredParameters.add(new DeferredParameter(){

                                    @Override
                                    void doPrepare(MethodContext context) {
                                        super.doPrepare(context);
                                        result.doPrepare(context);
                                    }

                                    @Override
                                    ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                                        ResultHandle r = result.doLoad(context, method, array);
                                        return method.newInstance(MethodDescriptor.ofConstructor(RuntimeValue.class, (Class[])new Class[]{Object.class}), new ResultHandle[]{r});
                                    }
                                });
                                continue;
                            }
                            this.deferredParameters.add(new DeferredParameter(){

                                @Override
                                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                                    return method.newInstance(MethodDescriptor.ofConstructor(RuntimeValue.class, (Class[])new Class[0]), new ResultHandle[0]);
                                }
                            });
                            continue;
                        }
                        result = BytecodeRecorderImpl.this.findLoaded(obj);
                        if (result == null) {
                            throw new RuntimeException("Cannot inject object of type " + param);
                        }
                        this.deferredParameters.add(result);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to prepare injector constructor " + this.injectCtor + " of bytecode recorder", e);
                }
            }
        }

        @Override
        void doPrepare(MethodContext context) {
            for (DeferredParameter i : this.deferredParameters) {
                i.doPrepare(context);
            }
            super.doPrepare(context);
        }

        @Override
        ResultHandle createValue(MethodContext context, MethodCreator method, ResultHandle array) {
            if (this.injectCtor == null) {
                return method.newInstance(MethodDescriptor.ofConstructor(this.theClass, (Class[])new Class[0]), new ResultHandle[0]);
            }
            try {
                ArrayList<ResultHandle> handles = new ArrayList<ResultHandle>();
                for (DeferredParameter result : this.deferredParameters) {
                    handles.add(context.loadDeferred(result));
                }
                return method.newInstance(MethodDescriptor.ofConstructor(this.injectCtor.getDeclaringClass(), (Class[])this.injectCtor.getParameterTypes()), (ResultHandle[])handles.toArray(ResultHandle[]::new));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to injector constructor " + this.injectCtor + " of bytecode recorder", e);
            }
        }
    }

    public static interface ReturnedProxy {
        public String __returned$proxy$key();

        public boolean __static$$init();
    }

    private static final class ReturnValueProxyInvocationHandler
    implements InvocationHandler {
        private final Class<?> returnType;
        private final String key;
        private final boolean staticInit;

        private ReturnValueProxyInvocationHandler(String key, Class<?> returnType, boolean staticInit) {
            this.returnType = returnType;
            this.key = key;
            this.staticInit = staticInit;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("__returned$proxy$key")) {
                return this.key;
            }
            if (method.getName().equals("__static$$init")) {
                return this.staticInit;
            }
            if (method.getName().equals("toString") && method.getParameterCount() == 0 && method.getReturnType().equals(String.class)) {
                return "Runtime proxy of " + this.returnType + " with id " + this.key;
            }
            if (method.getName().equals("hashCode") && method.getParameterCount() == 0 && method.getReturnType().equals(Integer.TYPE)) {
                return System.identityHashCode(proxy);
            }
            if (method.getName().equals("equals") && method.getParameterCount() == 1 && method.getParameterTypes()[0] == Object.class && method.getReturnType().equals(Boolean.TYPE)) {
                return proxy == args[0];
            }
            throw new RuntimeException("You cannot invoke " + method.getName() + "() directly on an object returned from the bytecode recorder, you can only pass it back into the recorder as a parameter");
        }
    }

    static interface BytecodeInstruction {
    }

    static final class StoredMethodCall
    implements BytecodeInstruction {
        final Class<?> theClass;
        final Method method;
        final Object[] parameters;
        final DeferredParameter[] deferredParameters;
        Object returnedProxy;
        String proxyId;

        StoredMethodCall(Class<?> theClass, Method method, Object[] parameters) {
            this.theClass = theClass;
            this.method = method;
            this.parameters = parameters;
            this.deferredParameters = new DeferredParameter[parameters.length];
        }
    }

    abstract class DeferredParameter {
        boolean prepared = false;

        DeferredParameter() {
        }

        abstract ResultHandle doLoad(MethodContext var1, MethodCreator var2, ResultHandle var3);

        final void prepare(MethodContext context) {
            if (!this.prepared) {
                this.prepared = true;
                this.doPrepare(context);
            }
        }

        void doPrepare(MethodContext context) {
        }
    }

    static class SplitMethodContext
    implements Closeable,
    MethodContext {
        final ResultHandle deferredParameterArray;
        final MethodCreator mainMethod;
        final ClassCreator classCreator;
        List<MethodCreator> allMethods = new ArrayList<MethodCreator>();
        int methodCount;
        int currentCount;
        MethodCreator currentMethod;
        Map<Integer, ResultHandle> currentMethodCache = new HashMap<Integer, ResultHandle>();

        SplitMethodContext(ResultHandle deferredParameterArray, MethodCreator mainMethod, ClassCreator classCreator) {
            this.deferredParameterArray = deferredParameterArray;
            this.mainMethod = mainMethod;
            this.classCreator = classCreator;
        }

        @Override
        public void writeInstruction(InstructionGroup writer) {
            if (this.currentMethod == null || this.currentCount++ >= 300) {
                this.newMethod();
            }
            FixedMethodContext c = new FixedMethodContext(this);
            c.writeInstruction(writer);
        }

        @Override
        public ResultHandle loadDeferred(DeferredParameter parameter) {
            if (this.currentMethod == null || this.currentCount++ >= 300) {
                this.newMethod();
            }
            FixedMethodContext c = new FixedMethodContext(this);
            return c.loadDeferred(parameter);
        }

        void newMethod() {
            this.currentCount = 0;
            this.currentMethod = this.classCreator.getMethodCreator(this.mainMethod.getMethodDescriptor().getName() + "_" + this.methodCount++, (Object)this.mainMethod.getMethodDescriptor().getReturnType(), new Object[]{StartupContext.class, Object[].class});
            this.mainMethod.invokeVirtualMethod(this.currentMethod.getMethodDescriptor(), this.mainMethod.getThis(), new ResultHandle[]{this.mainMethod.getMethodParam(0), this.deferredParameterArray});
            this.currentMethodCache = new HashMap<Integer, ResultHandle>();
            this.allMethods.add(this.currentMethod);
        }

        @Override
        public void close() {
            for (MethodCreator i : this.allMethods) {
                i.returnValue(null);
            }
        }
    }

    public static interface MethodContext {
        public void writeInstruction(InstructionGroup var1);

        public ResultHandle loadDeferred(DeferredParameter var1);
    }

    abstract class DeferredArrayStoreParameter
    extends DeferredParameter {
        int arrayIndex = -1;
        final String returnType;
        ResultHandle originalResultHandle;
        ResultHandle originalArrayResultHandle;
        MethodCreator originalRhMethod;

        DeferredArrayStoreParameter(String expectedType) {
            this.returnType = expectedType;
            if (BytecodeRecorderImpl.this.loadComplete) {
                throw new RuntimeException("Cannot create new DeferredArrayStoreParameter after array has been allocated");
            }
        }

        DeferredArrayStoreParameter(Object target, Class<?> expectedType) {
            this.returnType = expectedType == List.class ? expectedType.getName() : (target != null && !(target instanceof Proxy) && BytecodeRecorderImpl.this.isAccessible(target.getClass()) ? target.getClass().getName() : (expectedType != null && BytecodeRecorderImpl.this.isAccessible(expectedType) ? expectedType.getName() : null));
            if (BytecodeRecorderImpl.this.loadComplete) {
                throw new RuntimeException("Cannot create new DeferredArrayStoreParameter after array has been allocated");
            }
        }

        abstract ResultHandle createValue(MethodContext var1, MethodCreator var2, ResultHandle var3);

        @Override
        void doPrepare(MethodContext context) {
            context.writeInstruction(new InstructionGroup(){

                @Override
                public void write(MethodContext context, MethodCreator method, ResultHandle array) {
                    DeferredArrayStoreParameter.this.originalResultHandle = DeferredArrayStoreParameter.this.createValue(context, method, array);
                    DeferredArrayStoreParameter.this.originalRhMethod = method;
                    DeferredArrayStoreParameter.this.originalArrayResultHandle = array;
                }
            });
            this.prepared = true;
        }

        @Override
        final ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
            if (!this.prepared) {
                this.prepare(context);
            }
            if (method == this.originalRhMethod) {
                return this.originalResultHandle;
            }
            if (this.arrayIndex == -1) {
                this.arrayIndex = BytecodeRecorderImpl.this.deferredParameterCount++;
                this.originalRhMethod.writeArrayValue(this.originalArrayResultHandle, this.arrayIndex, this.originalResultHandle);
            }
            ResultHandle resultHandle = method.readArrayValue(array, this.arrayIndex);
            if (this.returnType == null) {
                return resultHandle;
            }
            return method.checkCast(resultHandle, this.returnType);
        }
    }

    static interface InstructionGroup {
        public void write(MethodContext var1, MethodCreator var2, ResultHandle var3);
    }

    static final class FixedMethodContext
    implements MethodContext {
        final SplitMethodContext parent;
        final MethodCreator currentMethod;
        final Map<Integer, ResultHandle> currentMethodCache;

        FixedMethodContext(SplitMethodContext parent) {
            this.parent = parent;
            this.currentMethod = parent.currentMethod;
            this.currentMethodCache = parent.currentMethodCache;
        }

        @Override
        public void writeInstruction(InstructionGroup writer) {
            writer.write(this, this.currentMethod, this.currentMethod.getMethodParam(1));
        }

        @Override
        public ResultHandle loadDeferred(DeferredParameter parameter) {
            if (parameter instanceof DeferredArrayStoreParameter) {
                int arrayIndex = ((DeferredArrayStoreParameter)parameter).arrayIndex;
                if (arrayIndex > 0 && this.currentMethodCache.containsKey(arrayIndex)) {
                    return this.currentMethodCache.get(arrayIndex);
                }
                ResultHandle loaded = parameter.doLoad(this, this.currentMethod, this.currentMethod.getMethodParam(1));
                arrayIndex = ((DeferredArrayStoreParameter)parameter).arrayIndex;
                if (arrayIndex < 0) {
                    return loaded;
                }
                if (this.parent.currentMethod == this.currentMethod) {
                    this.currentMethodCache.put(arrayIndex, loaded);
                    return loaded;
                }
                ResultHandle ret = this.currentMethod.readArrayValue(this.currentMethod.getMethodParam(1), arrayIndex);
                this.currentMethodCache.put(arrayIndex, ret);
                return ret;
            }
            return parameter.doLoad(this, this.currentMethod, this.currentMethod.getMethodParam(1));
        }
    }

    static interface SerializationStep {
        public void handle(MethodContext var1, MethodCreator var2, DeferredArrayStoreParameter var3);

        public void prepare(MethodContext var1);
    }
}

