/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem.nativeimage;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.deployment.pkg.steps.GraalVM;
import java.util.Objects;

public final class JPMSExportBuildItem
extends MultiBuildItem {
    private final String moduleName;
    private final String packageName;
    private final GraalVM.Version exportSince;
    private final GraalVM.Version exportBefore;

    public JPMSExportBuildItem(String moduleName, String packageName) {
        this(moduleName, packageName, null, null);
    }

    public JPMSExportBuildItem(String moduleName, String packageName, GraalVM.Version exportSince) {
        this(moduleName, packageName, exportSince, null);
    }

    public JPMSExportBuildItem(String moduleName, String packageName, GraalVM.Version exportSince, GraalVM.Version exportBefore) {
        this.moduleName = moduleName;
        this.packageName = packageName;
        this.exportSince = exportSince;
        this.exportBefore = exportBefore;
    }

    public String getPackage() {
        return this.packageName;
    }

    public String getModule() {
        return this.moduleName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        JPMSExportBuildItem that = (JPMSExportBuildItem)((Object)o);
        return this.moduleName.equals(that.moduleName) && this.packageName.equals(that.packageName);
    }

    public int hashCode() {
        return Objects.hash(this.moduleName, this.packageName);
    }

    public GraalVM.Version getExportSince() {
        return this.exportSince;
    }

    public GraalVM.Version getExportBefore() {
        return this.exportBefore;
    }

    public boolean isRequired(GraalVM.Version current) {
        return !(this.exportSince != null && current.compareTo(this.exportSince) < 0 || this.exportBefore != null && current.compareTo(this.exportBefore) >= 0);
    }
}

