/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.GeneratedNativeImageClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ForceNonWeakReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.JniRuntimeAccessBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourcePatternsBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveFieldBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedPackageBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeReinitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.builditem.nativeimage.UnsafeAccessedFieldBuildItem;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.runtime.ResourceHelper;
import io.quarkus.runtime.graal.WeakReflection;
import java.io.ObjectStreamClass;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.graalvm.home.Version;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

public class NativeImageAutoFeatureStep {
    private static final String GRAAL_AUTOFEATURE = "io.quarkus.runner.AutoFeature";
    private static final MethodDescriptor VERSION_CURRENT = MethodDescriptor.ofMethod(Version.class, (String)"getCurrent", Version.class, (Class[])new Class[0]);
    private static final MethodDescriptor VERSION_COMPARE_TO = MethodDescriptor.ofMethod(Version.class, (String)"compareTo", Integer.TYPE, (Class[])new Class[]{int[].class});
    private static final MethodDescriptor IMAGE_SINGLETONS_LOOKUP = MethodDescriptor.ofMethod(ImageSingletons.class, (String)"lookup", Object.class, (Class[])new Class[]{Class.class});
    private static final MethodDescriptor BUILD_TIME_INITIALIZATION = MethodDescriptor.ofMethod((Object)"org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport", (String)"initializeAtBuildTime", Void.TYPE, (Object[])new Object[]{String.class, String.class});
    private static final MethodDescriptor INITIALIZE_CLASSES_AT_RUN_TIME = MethodDescriptor.ofMethod(RuntimeClassInitialization.class, (String)"initializeAtRunTime", Void.TYPE, (Class[])new Class[]{Class[].class});
    private static final MethodDescriptor INITIALIZE_PACKAGES_AT_RUN_TIME = MethodDescriptor.ofMethod(RuntimeClassInitialization.class, (String)"initializeAtRunTime", Void.TYPE, (Class[])new Class[]{String[].class});
    private static final MethodDescriptor RERUN_INITIALIZATION = MethodDescriptor.ofMethod((Object)"org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport", (String)"rerunInitialization", Void.TYPE, (Object[])new Object[]{Class.class, String.class});
    private static final MethodDescriptor LOOKUP_METHOD = MethodDescriptor.ofMethod((Object)"com.oracle.svm.util.ReflectionUtil", (String)"lookupMethod", Method.class, (Object[])new Object[]{Class.class, String.class, Class[].class});
    private static final MethodDescriptor FOR_NAME = MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class, Boolean.TYPE, ClassLoader.class});
    private static final MethodDescriptor INVOKE = MethodDescriptor.ofMethod(Method.class, (String)"invoke", Object.class, (Class[])new Class[]{Object.class, Object[].class});
    static final String RUNTIME_REFLECTION = RuntimeReflection.class.getName();
    static final String JNI_RUNTIME_ACCESS = "com.oracle.svm.core.jni.JNIRuntimeAccess";
    static final String BEFORE_ANALYSIS_ACCESS = Feature.BeforeAnalysisAccess.class.getName();
    static final String DYNAMIC_PROXY_REGISTRY = "com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry";
    static final String LEGACY_LOCALIZATION_FEATURE = "com.oracle.svm.core.jdk.LocalizationFeature";
    static final String LOCALIZATION_FEATURE = "com.oracle.svm.core.jdk.localization.LocalizationFeature";
    public static final MethodDescriptor WEAK_REFLECTION_REGISTRATION = MethodDescriptor.ofMethod(WeakReflection.class, (String)"register", Void.TYPE, (Class[])new Class[]{Feature.BeforeAnalysisAccess.class, Class.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE});

    @BuildStep
    GeneratedResourceBuildItem generateNativeResourcesList(List<NativeImageResourceBuildItem> resources, BuildProducer<NativeImageResourcePatternsBuildItem> resourcePatternsBuildItemBuildProducer) {
        StringBuilder sb = new StringBuilder();
        for (NativeImageResourceBuildItem i : resources) {
            for (String r : i.getResources()) {
                sb.append(r);
                sb.append("\n");
            }
        }
        resourcePatternsBuildItemBuildProducer.produce(NativeImageResourcePatternsBuildItem.builder().excludePattern("META-INF/quarkus-native-resources.txt").build());
        return new GeneratedResourceBuildItem("META-INF/quarkus-native-resources.txt", sb.toString().getBytes(StandardCharsets.UTF_8));
    }

    /*
     * WARNING - void declaration
     */
    @BuildStep
    void generateFeature(final BuildProducer<GeneratedNativeImageClassBuildItem> nativeImageClass, List<RuntimeInitializedClassBuildItem> runtimeInitializedClassBuildItems, List<RuntimeInitializedPackageBuildItem> runtimeInitializedPackageBuildItems, List<RuntimeReinitializedClassBuildItem> runtimeReinitializedClassBuildItems, List<NativeImageProxyDefinitionBuildItem> proxies, List<NativeImageResourcePatternsBuildItem> resourcePatterns, List<NativeImageResourceBundleBuildItem> resourceBundles, List<ReflectiveMethodBuildItem> reflectiveMethods, List<ReflectiveFieldBuildItem> reflectiveFields, List<ReflectiveClassBuildItem> reflectiveClassBuildItems, List<ForceNonWeakReflectiveClassBuildItem> nonWeakReflectiveClassBuildItems, List<ServiceProviderBuildItem> serviceProviderBuildItems, List<UnsafeAccessedFieldBuildItem> unsafeAccessedFields, List<JniRuntimeAccessBuildItem> jniRuntimeAccessibleClasses) {
        CatchBlockCreator cc;
        BytecodeCreator smallerThan21_3;
        ResultHandle thisClass;
        ClassCreator file = new ClassCreator(new ClassOutput(){

            public void write(String s, byte[] bytes) {
                nativeImageClass.produce(new GeneratedNativeImageClassBuildItem(s, bytes));
            }
        }, GRAAL_AUTOFEATURE, null, Object.class.getName(), new String[]{Feature.class.getName()});
        file.addAnnotation("com.oracle.svm.core.annotate.AutomaticFeature");
        MethodCreator beforeAn = file.getMethodCreator("beforeAnalysis", "V", new String[]{BEFORE_ANALYSIS_ACCESS});
        TryBlock overallCatch = beforeAn.tryBlock();
        ResultHandle beforeAnalysisParam = beforeAn.getMethodParam(0);
        for (UnsafeAccessedFieldBuildItem unsafeAccessedField : unsafeAccessedFields) {
            TryBlock tc = overallCatch.tryBlock();
            ResultHandle declaringClassHandle = tc.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class}), new ResultHandle[]{tc.load(unsafeAccessedField.getDeclaringClass())});
            ResultHandle fieldHandle = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredField", Field.class, (Class[])new Class[]{String.class}), declaringClassHandle, new ResultHandle[]{tc.load(unsafeAccessedField.getFieldName())});
            tc.invokeInterfaceMethod(MethodDescriptor.ofMethod(Feature.BeforeAnalysisAccess.class, (String)"registerAsUnsafeAccessed", Void.TYPE, (Class[])new Class[]{Field.class}), beforeAnalysisParam, new ResultHandle[]{fieldHandle});
            CatchBlockCreator catchBlockCreator = tc.addCatch(Throwable.class);
            catchBlockCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), catchBlockCreator.getCaughtException(), new ResultHandle[0]);
        }
        ResultHandle imageSingleton = overallCatch.invokeStaticMethod(IMAGE_SINGLETONS_LOOKUP, new ResultHandle[]{overallCatch.loadClassFromTCCL("org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport")});
        overallCatch.invokeInterfaceMethod(BUILD_TIME_INITIALIZATION, imageSingleton, new ResultHandle[]{overallCatch.load(""), overallCatch.load("Quarkus build time init default")});
        if (!runtimeInitializedClassBuildItems.isEmpty()) {
            thisClass = overallCatch.loadClassFromTCCL(GRAAL_AUTOFEATURE);
            ResultHandle cl = overallCatch.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getClassLoader", ClassLoader.class, (Class[])new Class[0]), thisClass, new ResultHandle[0]);
            ResultHandle classes = overallCatch.newArray(Class.class, overallCatch.load(runtimeInitializedClassBuildItems.size()));
            for (int i = 0; i < runtimeInitializedClassBuildItems.size(); ++i) {
                TryBlock tryBlock = overallCatch.tryBlock();
                ResultHandle resultHandle = tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class, Boolean.TYPE, ClassLoader.class}), new ResultHandle[]{tryBlock.load(runtimeInitializedClassBuildItems.get(i).getClassName()), tryBlock.load(false), cl});
                tryBlock.writeArrayValue(classes, i, resultHandle);
                CatchBlockCreator cc3 = tryBlock.addCatch(Throwable.class);
                cc3.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), cc3.getCaughtException(), new ResultHandle[0]);
            }
            overallCatch.invokeStaticMethod(INITIALIZE_CLASSES_AT_RUN_TIME, new ResultHandle[]{classes});
        }
        if (!runtimeInitializedPackageBuildItems.isEmpty()) {
            ResultHandle packages = overallCatch.newArray(String.class, overallCatch.load(runtimeInitializedPackageBuildItems.size()));
            for (int i = 0; i < runtimeInitializedPackageBuildItems.size(); ++i) {
                TryBlock tc = overallCatch.tryBlock();
                ResultHandle pkg = tc.load(runtimeInitializedPackageBuildItems.get(i).getPackageName());
                tc.writeArrayValue(packages, i, pkg);
                CatchBlockCreator catchBlockCreator = tc.addCatch(Throwable.class);
                catchBlockCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), catchBlockCreator.getCaughtException(), new ResultHandle[0]);
            }
            overallCatch.invokeStaticMethod(INITIALIZE_PACKAGES_AT_RUN_TIME, new ResultHandle[]{packages});
        }
        if (!runtimeReinitializedClassBuildItems.isEmpty()) {
            thisClass = overallCatch.loadClassFromTCCL(GRAAL_AUTOFEATURE);
            ResultHandle cl = overallCatch.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getClassLoader", ClassLoader.class, (Class[])new Class[0]), thisClass, new ResultHandle[0]);
            ResultHandle quarkus = overallCatch.load("Quarkus");
            for (RuntimeReinitializedClassBuildItem runtimeReinitializedClassBuildItem : runtimeReinitializedClassBuildItems) {
                TryBlock tryBlock = overallCatch.tryBlock();
                ResultHandle clazz = tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class, Boolean.TYPE, ClassLoader.class}), new ResultHandle[]{tryBlock.load(runtimeReinitializedClassBuildItem.getClassName()), tryBlock.load(false), cl});
                tryBlock.invokeInterfaceMethod(RERUN_INITIALIZATION, imageSingleton, new ResultHandle[]{clazz, quarkus});
                CatchBlockCreator cc4 = tryBlock.addCatch(Throwable.class);
                cc4.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), cc4.getCaughtException(), new ResultHandle[0]);
            }
        }
        if (!proxies.isEmpty()) {
            ResultHandle proxySupportClass = overallCatch.loadClassFromTCCL(DYNAMIC_PROXY_REGISTRY);
            ResultHandle proxySupport = overallCatch.invokeStaticMethod(IMAGE_SINGLETONS_LOOKUP, new ResultHandle[]{proxySupportClass});
            for (NativeImageProxyDefinitionBuildItem proxy : proxies) {
                ResultHandle resultHandle = overallCatch.newArray(Class.class, overallCatch.load(proxy.getClasses().size()));
                boolean bl = false;
                for (String p : proxy.getClasses()) {
                    void var25_69;
                    ResultHandle clazz = overallCatch.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class}), new ResultHandle[]{overallCatch.load(p)});
                    overallCatch.writeArrayValue(resultHandle, (int)(++var25_69), clazz);
                }
                overallCatch.invokeInterfaceMethod(MethodDescriptor.ofMethod((Object)DYNAMIC_PROXY_REGISTRY, (String)"addProxyClass", Void.TYPE, (Object[])new Object[]{Class[].class}), proxySupport, new ResultHandle[]{resultHandle});
            }
        }
        if (!resourcePatterns.isEmpty()) {
            ResultHandle resourcesRegistrySingleton = overallCatch.invokeStaticMethod(IMAGE_SINGLETONS_LOOKUP, new ResultHandle[]{overallCatch.loadClassFromTCCL("com.oracle.svm.core.configure.ResourcesRegistry")});
            TryBlock tc = overallCatch.tryBlock();
            ResultHandle currentThread = tc.invokeStaticMethod(MethodDescriptor.ofMethod(Thread.class, (String)"currentThread", Thread.class, (Class[])new Class[0]), new ResultHandle[0]);
            ResultHandle tccl = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Thread.class, (String)"getContextClassLoader", ClassLoader.class, (Class[])new Class[0]), currentThread, new ResultHandle[0]);
            AssignableResultHandle assignableResultHandle = tc.createVariable(Class[].class);
            AssignableResultHandle assignableResultHandle2 = tc.createVariable(Object[].class);
            AssignableResultHandle argsIndex = tc.createVariable(Integer.TYPE);
            BranchResult graalVm21_3Test = tc.ifGreaterEqualZero(tc.invokeVirtualMethod(VERSION_COMPARE_TO, tc.invokeStaticMethod(VERSION_CURRENT, new ResultHandle[0]), new ResultHandle[]{tc.marshalAsArray(Integer.TYPE, new ResultHandle[]{tc.load(21), tc.load(3)})}));
            BytecodeCreator greaterThan21_2 = graalVm21_3Test.trueBranch();
            ResultHandle argTypes = greaterThan21_2.newArray(Class.class, greaterThan21_2.load(2));
            ResultHandle configurationConditionClass = greaterThan21_2.invokeStaticMethod(FOR_NAME, new ResultHandle[]{greaterThan21_2.load("org.graalvm.nativeimage.impl.ConfigurationCondition"), greaterThan21_2.load(false), tccl});
            greaterThan21_2.writeArrayValue(argTypes, 0, configurationConditionClass);
            greaterThan21_2.writeArrayValue(argTypes, 1, greaterThan21_2.loadClassFromTCCL(String.class));
            greaterThan21_2.assign(assignableResultHandle, argTypes);
            Object args = greaterThan21_2.newArray(Object.class, greaterThan21_2.load(2));
            ResultHandle alwaysTrueMethod = greaterThan21_2.invokeStaticMethod(LOOKUP_METHOD, new ResultHandle[]{configurationConditionClass, greaterThan21_2.load("alwaysTrue"), greaterThan21_2.newArray(Class.class, greaterThan21_2.load(0))});
            ResultHandle alwaysTrueResult = greaterThan21_2.invokeVirtualMethod(INVOKE, alwaysTrueMethod, new ResultHandle[]{greaterThan21_2.loadNull(), greaterThan21_2.newArray(Object.class, greaterThan21_2.load(0))});
            greaterThan21_2.writeArrayValue((ResultHandle)args, 0, alwaysTrueResult);
            greaterThan21_2.assign(assignableResultHandle2, (ResultHandle)args);
            greaterThan21_2.assign(argsIndex, greaterThan21_2.load(1));
            smallerThan21_3 = graalVm21_3Test.falseBranch();
            argTypes = smallerThan21_3.newArray(Class.class, smallerThan21_3.load(1));
            smallerThan21_3.writeArrayValue(argTypes, 0, smallerThan21_3.loadClassFromTCCL(String.class));
            smallerThan21_3.assign(assignableResultHandle, argTypes);
            args = smallerThan21_3.newArray(Object.class, smallerThan21_3.load(1));
            smallerThan21_3.assign(assignableResultHandle2, (ResultHandle)args);
            smallerThan21_3.assign(argsIndex, smallerThan21_3.load(0));
            ResultHandle ignoreResourcesMethod = tc.invokeStaticMethod(LOOKUP_METHOD, new ResultHandle[]{tc.loadClassFromTCCL("com.oracle.svm.core.configure.ResourcesRegistry"), tc.load("ignoreResources"), assignableResultHandle});
            Iterator<Object> addResourcesMethod = tc.invokeStaticMethod(LOOKUP_METHOD, new ResultHandle[]{tc.loadClassFromTCCL("com.oracle.svm.core.configure.ResourcesRegistry"), tc.load("addResources"), assignableResultHandle});
            for (NativeImageResourcePatternsBuildItem resourcePatternsItem : resourcePatterns) {
                for (String pattern : resourcePatternsItem.getExcludePatterns()) {
                    tc.writeArrayValue((ResultHandle)assignableResultHandle2, (ResultHandle)argsIndex, tc.load(pattern));
                    tc.invokeVirtualMethod(INVOKE, ignoreResourcesMethod, new ResultHandle[]{resourcesRegistrySingleton, assignableResultHandle2});
                }
                for (String pattern : resourcePatternsItem.getIncludePatterns()) {
                    tc.writeArrayValue((ResultHandle)assignableResultHandle2, (ResultHandle)argsIndex, tc.load(pattern));
                    tc.invokeVirtualMethod(INVOKE, addResourcesMethod, new ResultHandle[]{resourcesRegistrySingleton, assignableResultHandle2});
                }
            }
            cc = tc.addCatch(Throwable.class);
            cc.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), cc.getCaughtException(), new ResultHandle[0]);
        }
        for (ServiceProviderBuildItem i : serviceProviderBuildItems) {
            overallCatch.invokeStaticMethod(MethodDescriptor.ofMethod(ResourceHelper.class, (String)"registerResources", Void.TYPE, (Class[])new Class[]{String.class}), new ResultHandle[]{overallCatch.load(i.serviceDescriptorFile())});
        }
        if (!resourceBundles.isEmpty()) {
            AssignableResultHandle registerMethod = overallCatch.createVariable(Method.class);
            AssignableResultHandle locClass = overallCatch.createVariable(Class.class);
            TryBlock locTryBlock = overallCatch.tryBlock();
            ResultHandle legacyLocClass = locTryBlock.loadClassFromTCCL(LEGACY_LOCALIZATION_FEATURE);
            locTryBlock.assign(locClass, legacyLocClass);
            ResultHandle resultHandle = locTryBlock.marshalAsArray(Class.class, new ResultHandle[]{locTryBlock.loadClassFromTCCL(String.class)});
            ResultHandle resultHandle2 = locTryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredMethod", Method.class, (Class[])new Class[]{String.class, Class[].class}), legacyLocClass, new ResultHandle[]{locTryBlock.load("addBundleToCache"), resultHandle});
            locTryBlock.assign(registerMethod, resultHandle2);
            CatchBlockCreator locCatchBlock = locTryBlock.addCatch(ClassNotFoundException.class);
            ResultHandle newLocClass = locCatchBlock.loadClassFromTCCL(LOCALIZATION_FEATURE);
            locCatchBlock.assign(locClass, newLocClass);
            ResultHandle newParams = locCatchBlock.marshalAsArray(Class.class, new ResultHandle[]{locCatchBlock.loadClassFromTCCL(String.class)});
            ResultHandle newRegisterMethod = locCatchBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredMethod", Method.class, (Class[])new Class[]{String.class, Class[].class}), newLocClass, new ResultHandle[]{locCatchBlock.load("prepareBundle"), newParams});
            locCatchBlock.assign(registerMethod, newRegisterMethod);
            overallCatch.invokeVirtualMethod(MethodDescriptor.ofMethod(AccessibleObject.class, (String)"setAccessible", Void.TYPE, (Class[])new Class[]{Boolean.TYPE}), (ResultHandle)registerMethod, new ResultHandle[]{overallCatch.load(true)});
            ResultHandle locSupport = overallCatch.invokeStaticMethod(IMAGE_SINGLETONS_LOOKUP, new ResultHandle[]{locClass});
            for (NativeImageResourceBundleBuildItem i : resourceBundles) {
                TryBlock et = overallCatch.tryBlock();
                et.invokeVirtualMethod(MethodDescriptor.ofMethod(Method.class, (String)"invoke", Object.class, (Class[])new Class[]{Object.class, Object[].class}), (ResultHandle)registerMethod, new ResultHandle[]{locSupport, et.marshalAsArray(Object.class, new ResultHandle[]{et.load(i.getBundleName())})});
                smallerThan21_3 = et.addCatch(Throwable.class);
            }
        }
        int count = 0;
        LinkedHashMap<String, ReflectionInfo> reflectiveClasses = new LinkedHashMap<String, ReflectionInfo>();
        HashSet<String> forcedNonWeakClasses = new HashSet<String>();
        for (ForceNonWeakReflectiveClassBuildItem forceNonWeakReflectiveClassBuildItem : nonWeakReflectiveClassBuildItems) {
            forcedNonWeakClasses.add(forceNonWeakReflectiveClassBuildItem.getClassName());
        }
        for (ReflectiveClassBuildItem reflectiveClassBuildItem : reflectiveClassBuildItems) {
            this.addReflectiveClass(reflectiveClasses, forcedNonWeakClasses, reflectiveClassBuildItem.isConstructors(), reflectiveClassBuildItem.isMethods(), reflectiveClassBuildItem.isFields(), reflectiveClassBuildItem.areFinalFieldsWritable(), reflectiveClassBuildItem.isWeak(), reflectiveClassBuildItem.isSerialization(), reflectiveClassBuildItem.getClassNames().toArray(new String[0]));
        }
        for (ReflectiveFieldBuildItem reflectiveFieldBuildItem : reflectiveFields) {
            this.addReflectiveField(reflectiveClasses, reflectiveFieldBuildItem);
        }
        for (ReflectiveMethodBuildItem reflectiveMethodBuildItem : reflectiveMethods) {
            this.addReflectiveMethod(reflectiveClasses, reflectiveMethodBuildItem);
        }
        for (ServiceProviderBuildItem serviceProviderBuildItem : serviceProviderBuildItems) {
            this.addReflectiveClass(reflectiveClasses, forcedNonWeakClasses, true, false, false, false, false, false, serviceProviderBuildItem.providers().toArray(new String[0]));
        }
        MethodDescriptor registerSerializationMethod = null;
        for (Map.Entry entry : reflectiveClasses.entrySet()) {
            MethodCreator mv = file.getMethodCreator("registerClass" + count++, Void.TYPE, new Class[]{Feature.BeforeAnalysisAccess.class});
            mv.setModifiers(10);
            overallCatch.invokeStaticMethod(mv.getMethodDescriptor(), new ResultHandle[]{overallCatch.getMethodParam(0)});
            TryBlock tc = mv.tryBlock();
            ResultHandle currentThread = tc.invokeStaticMethod(MethodDescriptor.ofMethod(Thread.class, (String)"currentThread", Thread.class, (Class[])new Class[0]), new ResultHandle[0]);
            ResultHandle tccl = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Thread.class, (String)"getContextClassLoader", ClassLoader.class, (Class[])new Class[0]), currentThread, new ResultHandle[0]);
            ResultHandle clazz = tc.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class, Boolean.TYPE, ClassLoader.class}), new ResultHandle[]{tc.load((String)entry.getKey()), tc.load(false), tccl});
            ResultHandle constructors = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredConstructors", Constructor[].class, (Class[])new Class[0]), clazz, new ResultHandle[0]);
            ResultHandle methods = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredMethods", Method[].class, (Class[])new Class[0]), clazz, new ResultHandle[0]);
            ResultHandle fields = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredFields", Field[].class, (Class[])new Class[0]), clazz, new ResultHandle[0]);
            if (!((ReflectionInfo)entry.getValue()).weak) {
                ResultHandle fhandle;
                String type;
                ResultHandle paramArray;
                ResultHandle farray;
                ResultHandle carray = tc.newArray(Class.class, tc.load(1));
                tc.writeArrayValue(carray, 0, clazz);
                tc.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Class[].class}), new ResultHandle[]{carray});
                if (((ReflectionInfo)entry.getValue()).constructors) {
                    tc.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{constructors});
                } else if (!((ReflectionInfo)entry.getValue()).ctorSet.isEmpty()) {
                    farray = tc.newArray(Constructor.class, tc.load(1));
                    for (ReflectiveMethodBuildItem ctor : ((ReflectionInfo)entry.getValue()).ctorSet) {
                        paramArray = tc.newArray(Class.class, tc.load(ctor.getParams().length));
                        for (int i = 0; i < ctor.getParams().length; ++i) {
                            type = ctor.getParams()[i];
                            tc.writeArrayValue(paramArray, i, tc.loadClassFromTCCL(type));
                        }
                        fhandle = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredConstructor", Constructor.class, (Class[])new Class[]{Class[].class}), clazz, new ResultHandle[]{paramArray});
                        tc.writeArrayValue(farray, 0, fhandle);
                        tc.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{farray});
                    }
                }
                if (((ReflectionInfo)entry.getValue()).methods) {
                    tc.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{methods});
                } else if (!((ReflectionInfo)entry.getValue()).methodSet.isEmpty()) {
                    farray = tc.newArray(Method.class, tc.load(1));
                    for (ReflectiveMethodBuildItem method : ((ReflectionInfo)entry.getValue()).methodSet) {
                        paramArray = tc.newArray(Class.class, tc.load(method.getParams().length));
                        for (int i = 0; i < method.getParams().length; ++i) {
                            type = method.getParams()[i];
                            tc.writeArrayValue(paramArray, i, tc.loadClassFromTCCL(type));
                        }
                        fhandle = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredMethod", Method.class, (Class[])new Class[]{String.class, Class[].class}), clazz, new ResultHandle[]{tc.load(method.getName()), paramArray});
                        tc.writeArrayValue(farray, 0, fhandle);
                        tc.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{farray});
                    }
                }
                if (((ReflectionInfo)entry.getValue()).fields) {
                    tc.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Boolean.TYPE, Boolean.TYPE, Field[].class}), new ResultHandle[]{tc.load(((ReflectionInfo)entry.getValue()).finalFieldsWritable), tc.load(((ReflectionInfo)entry.getValue()).serialization), fields});
                } else if (!((ReflectionInfo)entry.getValue()).fieldSet.isEmpty()) {
                    farray = tc.newArray(Field.class, tc.load(1));
                    for (String field : ((ReflectionInfo)entry.getValue()).fieldSet) {
                        ResultHandle fhandle2 = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredField", Field.class, (Class[])new Class[]{String.class}), clazz, new ResultHandle[]{tc.load(field)});
                        tc.writeArrayValue(farray, 0, fhandle2);
                        tc.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Field[].class}), new ResultHandle[]{farray});
                    }
                }
            } else {
                tc.invokeStaticMethod(WEAK_REFLECTION_REGISTRATION, new ResultHandle[]{tc.getMethodParam(0), clazz, tc.load(((ReflectionInfo)entry.getValue()).constructors), tc.load(((ReflectionInfo)entry.getValue()).methods), tc.load(((ReflectionInfo)entry.getValue()).fields)});
            }
            if (((ReflectionInfo)entry.getValue()).serialization) {
                if (registerSerializationMethod == null) {
                    registerSerializationMethod = this.createRegisterSerializationForClassMethod(file);
                }
                tc.invokeStaticMethod(registerSerializationMethod, new ResultHandle[]{clazz});
            }
            CatchBlockCreator cc5 = tc.addCatch(Throwable.class);
            mv.returnValue(null);
        }
        count = 0;
        for (JniRuntimeAccessBuildItem jniRuntimeAccessBuildItem : jniRuntimeAccessibleClasses) {
            for (String className : jniRuntimeAccessBuildItem.getClassNames()) {
                MethodCreator mv = file.getMethodCreator("registerJniAccessibleClass" + count++, "V", new String[0]);
                mv.setModifiers(10);
                overallCatch.invokeStaticMethod(mv.getMethodDescriptor(), new ResultHandle[0]);
                TryBlock tc = mv.tryBlock();
                ResultHandle currentThread = tc.invokeStaticMethod(MethodDescriptor.ofMethod(Thread.class, (String)"currentThread", Thread.class, (Class[])new Class[0]), new ResultHandle[0]);
                ResultHandle tccl = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Thread.class, (String)"getContextClassLoader", ClassLoader.class, (Class[])new Class[0]), currentThread, new ResultHandle[0]);
                ResultHandle clazz = tc.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class, Boolean.TYPE, ClassLoader.class}), new ResultHandle[]{tc.load(className), tc.load(false), tccl});
                ResultHandle constructors = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredConstructors", Constructor[].class, (Class[])new Class[0]), clazz, new ResultHandle[0]);
                ResultHandle methods = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredMethods", Method[].class, (Class[])new Class[0]), clazz, new ResultHandle[0]);
                ResultHandle fields = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredFields", Field[].class, (Class[])new Class[0]), clazz, new ResultHandle[0]);
                ResultHandle carray = tc.newArray(Class.class, tc.load(1));
                tc.writeArrayValue(carray, 0, clazz);
                tc.invokeStaticMethod(MethodDescriptor.ofMethod((Object)JNI_RUNTIME_ACCESS, (String)"register", Void.TYPE, (Object[])new Object[]{Class[].class}), new ResultHandle[]{carray});
                if (jniRuntimeAccessBuildItem.isConstructors()) {
                    tc.invokeStaticMethod(MethodDescriptor.ofMethod((Object)JNI_RUNTIME_ACCESS, (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{constructors});
                }
                if (jniRuntimeAccessBuildItem.isMethods()) {
                    tc.invokeStaticMethod(MethodDescriptor.ofMethod((Object)JNI_RUNTIME_ACCESS, (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{methods});
                }
                if (jniRuntimeAccessBuildItem.isFields()) {
                    tc.invokeStaticMethod(MethodDescriptor.ofMethod((Object)JNI_RUNTIME_ACCESS, (String)"register", Void.TYPE, (Object[])new Object[]{Boolean.TYPE, Field[].class}), new ResultHandle[]{tc.load(jniRuntimeAccessBuildItem.isFinalFieldsWriteable()), fields});
                }
                cc = tc.addCatch(Throwable.class);
                mv.returnValue(null);
            }
        }
        CatchBlockCreator catchBlockCreator = overallCatch.addCatch(Throwable.class);
        catchBlockCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), catchBlockCreator.getCaughtException(), new ResultHandle[0]);
        beforeAn.loadClassFromTCCL("io.quarkus.runner.ApplicationImpl");
        beforeAn.returnValue(null);
        file.close();
    }

    private MethodDescriptor createRegisterSerializationForClassMethod(ClassCreator file) {
        MethodCreator requiredFeatures = file.getMethodCreator("getRequiredFeatures", "java.util.List", new String[0]);
        TryBlock requiredCatch = requiredFeatures.tryBlock();
        ResultHandle serializationFeatureClass = requiredCatch.loadClassFromTCCL("com.oracle.svm.reflect.serialize.hosted.SerializationFeature");
        ResultHandle requiredFeaturesList = requiredCatch.invokeStaticMethod(MethodDescriptor.ofMethod((Object)"java.util.Collections", (String)"singletonList", List.class, (Object[])new Object[]{Object.class}), new ResultHandle[]{serializationFeatureClass});
        requiredCatch.returnValue(requiredFeaturesList);
        MethodCreator addSerializationForClass = file.getMethodCreator("registerSerializationForClass", (Object)"V", new Object[]{Class.class});
        addSerializationForClass.setModifiers(10);
        ResultHandle clazz = addSerializationForClass.getMethodParam(0);
        TryBlock tc = addSerializationForClass.tryBlock();
        ResultHandle currentThread = tc.invokeStaticMethod(MethodDescriptor.ofMethod(Thread.class, (String)"currentThread", Thread.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle tccl = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Thread.class, (String)"getContextClassLoader", ClassLoader.class, (Class[])new Class[0]), currentThread, new ResultHandle[0]);
        BranchResult graalVm21_3Test = tc.ifGreaterEqualZero(tc.invokeVirtualMethod(VERSION_COMPARE_TO, tc.invokeStaticMethod(VERSION_CURRENT, new ResultHandle[0]), new ResultHandle[]{tc.marshalAsArray(Integer.TYPE, new ResultHandle[]{tc.load(21), tc.load(3)})}));
        BytecodeCreator greaterThan21_3 = graalVm21_3Test.trueBranch();
        ResultHandle runtimeSerializationClass = greaterThan21_3.invokeStaticMethod(FOR_NAME, new ResultHandle[]{greaterThan21_3.load("org.graalvm.nativeimage.hosted.RuntimeSerialization"), greaterThan21_3.load(false), tccl});
        ResultHandle registerArgTypes = greaterThan21_3.newArray(Class.class, greaterThan21_3.load(1));
        greaterThan21_3.writeArrayValue(registerArgTypes, 0, greaterThan21_3.loadClassFromTCCL(Class[].class));
        ResultHandle registerLookupMethod = greaterThan21_3.invokeStaticMethod(LOOKUP_METHOD, new ResultHandle[]{runtimeSerializationClass, greaterThan21_3.load("register"), registerArgTypes});
        ResultHandle registerArgs = greaterThan21_3.newArray(Object.class, greaterThan21_3.load(1));
        ResultHandle classesToRegister = greaterThan21_3.newArray(Class.class, greaterThan21_3.load(1));
        greaterThan21_3.writeArrayValue(classesToRegister, 0, clazz);
        greaterThan21_3.writeArrayValue(registerArgs, 0, classesToRegister);
        greaterThan21_3.invokeVirtualMethod(INVOKE, registerLookupMethod, new ResultHandle[]{greaterThan21_3.loadNull(), registerArgs});
        greaterThan21_3.returnValue(null);
        ResultHandle serializationRegistryClass = tc.invokeStaticMethod(FOR_NAME, new ResultHandle[]{tc.load("com.oracle.svm.core.jdk.serialize.SerializationRegistry"), tc.load(false), tccl});
        ResultHandle addReflectionsClass = tc.invokeStaticMethod(FOR_NAME, new ResultHandle[]{tc.load("com.oracle.svm.reflect.serialize.hosted.SerializationFeature"), tc.load(false), tccl});
        ResultHandle serializationSupport = tc.invokeStaticMethod(IMAGE_SINGLETONS_LOOKUP, new ResultHandle[]{serializationRegistryClass});
        ResultHandle addReflectionsLookupArgs = tc.newArray(Class.class, tc.load(2));
        tc.writeArrayValue(addReflectionsLookupArgs, 0, tc.loadClassFromTCCL(Class.class));
        tc.writeArrayValue(addReflectionsLookupArgs, 1, tc.loadClassFromTCCL(Class.class));
        ResultHandle addReflectionsLookupMethod = tc.invokeStaticMethod(LOOKUP_METHOD, new ResultHandle[]{addReflectionsClass, tc.load("addReflections"), addReflectionsLookupArgs});
        ResultHandle reflectionFactory = tc.invokeStaticMethod(MethodDescriptor.ofMethod((String)"sun.reflect.ReflectionFactory", (String)"getReflectionFactory", (String)"sun.reflect.ReflectionFactory", (String[])new String[0]), new ResultHandle[0]);
        AssignableResultHandle newSerializationConstructor = tc.createVariable(Constructor.class);
        ResultHandle externalizableClass = tc.invokeStaticMethod(FOR_NAME, new ResultHandle[]{tc.load("java.io.Externalizable"), tc.load(false), tccl});
        BranchResult isExternalizable = tc.ifTrue(tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"isAssignableFrom", Boolean.TYPE, (Class[])new Class[]{Class.class}), externalizableClass, new ResultHandle[]{clazz}));
        BytecodeCreator ifIsExternalizable = isExternalizable.trueBranch();
        ResultHandle array1 = ifIsExternalizable.newArray(Class.class, tc.load(1));
        ResultHandle classClass = ifIsExternalizable.invokeStaticMethod(FOR_NAME, new ResultHandle[]{ifIsExternalizable.load("java.lang.Class"), ifIsExternalizable.load(false), tccl});
        ifIsExternalizable.writeArrayValue(array1, 0, classClass);
        ResultHandle externalizableLookupMethod = ifIsExternalizable.invokeStaticMethod(LOOKUP_METHOD, new ResultHandle[]{ifIsExternalizable.loadClassFromTCCL(ObjectStreamClass.class), ifIsExternalizable.load("getExternalizableConstructor"), array1});
        ResultHandle array2 = ifIsExternalizable.newArray(Object.class, tc.load(1));
        ifIsExternalizable.writeArrayValue(array2, 0, clazz);
        ResultHandle externalizableConstructor = ifIsExternalizable.invokeVirtualMethod(INVOKE, externalizableLookupMethod, new ResultHandle[]{ifIsExternalizable.loadNull(), array2});
        ResultHandle externalizableConstructorClass = ifIsExternalizable.invokeVirtualMethod(MethodDescriptor.ofMethod(Constructor.class, (String)"getDeclaringClass", Class.class, (Class[])new Class[0]), externalizableConstructor, new ResultHandle[0]);
        ResultHandle addReflectionsArgs1 = ifIsExternalizable.newArray(Class.class, tc.load(2));
        ifIsExternalizable.writeArrayValue(addReflectionsArgs1, 0, clazz);
        ifIsExternalizable.writeArrayValue(addReflectionsArgs1, 1, externalizableConstructorClass);
        ifIsExternalizable.invokeVirtualMethod(INVOKE, addReflectionsLookupMethod, new ResultHandle[]{ifIsExternalizable.loadNull(), addReflectionsArgs1});
        ifIsExternalizable.returnValue(null);
        ResultHandle clazzModifiers = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getModifiers", Integer.TYPE, (Class[])new Class[0]), clazz, new ResultHandle[0]);
        BranchResult isAbstract = tc.ifTrue(tc.invokeStaticMethod(MethodDescriptor.ofMethod(Modifier.class, (String)"isAbstract", Boolean.TYPE, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{clazzModifiers}));
        BytecodeCreator ifIsAbstract = isAbstract.trueBranch();
        BytecodeCreator ifNotAbstract = isAbstract.falseBranch();
        ResultHandle stubConstructor = ifIsAbstract.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)"sun.reflect.ReflectionFactory", (String)"newConstructorForSerialization", Constructor.class, (Object[])new Object[]{Class.class}), reflectionFactory, new ResultHandle[]{tc.loadClass("com.oracle.svm.reflect.serialize.SerializationSupport$StubForAbstractClass")});
        ifIsAbstract.assign(newSerializationConstructor, stubConstructor);
        ResultHandle classConstructor = ifNotAbstract.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)"sun.reflect.ReflectionFactory", (String)"newConstructorForSerialization", Constructor.class, (Object[])new Object[]{Class.class}), reflectionFactory, new ResultHandle[]{clazz});
        ifNotAbstract.assign(newSerializationConstructor, classConstructor);
        ResultHandle newSerializationConstructorClass = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Constructor.class, (String)"getDeclaringClass", Class.class, (Class[])new Class[0]), (ResultHandle)newSerializationConstructor, new ResultHandle[0]);
        ResultHandle getConstructorAccessor = tc.invokeStaticMethod(LOOKUP_METHOD, new ResultHandle[]{tc.loadClassFromTCCL(Constructor.class), tc.load("getConstructorAccessor"), tc.newArray(Class.class, tc.load(0))});
        ResultHandle accessor2 = tc.invokeVirtualMethod(INVOKE, getConstructorAccessor, new ResultHandle[]{newSerializationConstructor, tc.newArray(Object.class, tc.load(0))});
        tc.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)"com.oracle.svm.reflect.serialize.SerializationSupport", (String)"addConstructorAccessor", Object.class, (Object[])new Object[]{Class.class, Class.class, Object.class}), serializationSupport, new ResultHandle[]{clazz, newSerializationConstructorClass, accessor2});
        ResultHandle addReflectionsArgs2 = tc.newArray(Class.class, tc.load(2));
        tc.writeArrayValue(addReflectionsArgs2, 0, clazz);
        tc.writeArrayValue(addReflectionsArgs2, 1, newSerializationConstructorClass);
        tc.invokeVirtualMethod(INVOKE, addReflectionsLookupMethod, new ResultHandle[]{tc.loadNull(), addReflectionsArgs2});
        addSerializationForClass.returnValue(null);
        return addSerializationForClass.getMethodDescriptor();
    }

    public void addReflectiveMethod(Map<String, ReflectionInfo> reflectiveClasses, ReflectiveMethodBuildItem methodInfo) {
        String cl = methodInfo.getDeclaringClass();
        ReflectionInfo existing = reflectiveClasses.get(cl);
        if (existing == null) {
            existing = new ReflectionInfo(false, false, false, false, false, false);
            reflectiveClasses.put(cl, existing);
        }
        if (methodInfo.getName().equals("<init>")) {
            existing.ctorSet.add(methodInfo);
        } else {
            existing.methodSet.add(methodInfo);
        }
    }

    public void addReflectiveClass(Map<String, ReflectionInfo> reflectiveClasses, Set<String> forcedNonWeakClasses, boolean constructors, boolean method, boolean fields, boolean finalFieldsWritable, boolean weak, boolean serialization, String ... className) {
        for (String cl : className) {
            ReflectionInfo existing = reflectiveClasses.get(cl);
            if (existing == null) {
                reflectiveClasses.put(cl, new ReflectionInfo(constructors, method, fields, finalFieldsWritable, !forcedNonWeakClasses.contains(cl) && weak, serialization));
                continue;
            }
            if (constructors) {
                existing.constructors = true;
            }
            if (method) {
                existing.methods = true;
            }
            if (fields) {
                existing.fields = true;
            }
            if (!serialization) continue;
            existing.serialization = true;
        }
    }

    public void addReflectiveField(Map<String, ReflectionInfo> reflectiveClasses, ReflectiveFieldBuildItem fieldInfo) {
        String cl = fieldInfo.getDeclaringClass();
        ReflectionInfo existing = reflectiveClasses.get(cl);
        if (existing == null) {
            existing = new ReflectionInfo(false, false, false, false, false, false);
            reflectiveClasses.put(cl, existing);
        }
        existing.fieldSet.add(fieldInfo.getName());
    }

    static final class ReflectionInfo {
        boolean constructors;
        boolean methods;
        boolean fields;
        boolean finalFieldsWritable;
        boolean weak;
        boolean serialization;
        Set<String> fieldSet = new HashSet<String>();
        Set<ReflectiveMethodBuildItem> methodSet = new HashSet<ReflectiveMethodBuildItem>();
        Set<ReflectiveMethodBuildItem> ctorSet = new HashSet<ReflectiveMethodBuildItem>();

        private ReflectionInfo(boolean constructors, boolean methods, boolean fields, boolean finalFieldsWritable, boolean weak, boolean serialization) {
            this.methods = methods;
            this.fields = fields;
            this.constructors = constructors;
            this.finalFieldsWritable = finalFieldsWritable;
            this.weak = weak;
            this.serialization = serialization;
        }
    }
}

