/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven.workspace;

import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContextConfig;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.model.Model;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.model.resolution.WorkspaceModelResolver;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;

public class LocalWorkspace
implements WorkspaceModelResolver,
WorkspaceReader {
    private final Map<AppArtifactKey, LocalProject> projects = new HashMap<AppArtifactKey, LocalProject>();
    private final WorkspaceRepository wsRepo = new WorkspaceRepository();
    private AppArtifactKey lastFindVersionsKey;
    private List<String> lastFindVersions;
    private long lastModified;
    private int id = 1;
    private String resolvedVersion;
    private BootstrapMavenContext mvnCtx;
    private LocalProject currentProject;

    protected void addProject(LocalProject project, long lastModified) {
        this.projects.put(project.getKey(), project);
        if (lastModified > this.lastModified) {
            this.lastModified = lastModified;
        }
        this.id = 31 * this.id + (int)(lastModified ^ lastModified >>> 32);
    }

    public LocalProject getProject(String groupId, String artifactId) {
        return this.getProject(new AppArtifactKey(groupId, artifactId));
    }

    public LocalProject getProject(AppArtifactKey key) {
        return this.projects.get(key);
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public int getId() {
        return this.id;
    }

    public Model resolveRawModel(String groupId, String artifactId, String versionConstraint) throws UnresolvableModelException {
        LocalProject project = this.getProject(groupId, artifactId);
        return project != null && (versionConstraint == null || versionConstraint.equals(ModelUtils.getVersion(project.getRawModel()))) ? project.getRawModel() : null;
    }

    public Model resolveEffectiveModel(String groupId, String artifactId, String versionConstraint) throws UnresolvableModelException {
        return null;
    }

    public Map<AppArtifactKey, LocalProject> getProjects() {
        return this.projects;
    }

    public WorkspaceRepository getRepository() {
        return this.wsRepo;
    }

    public File findArtifact(Artifact artifact) {
        File pom;
        LocalProject lp = this.getProject(artifact.getGroupId(), artifact.getArtifactId());
        String findVersion = artifact.getVersion();
        if (!(lp != null && (findVersion.isEmpty() || lp.getVersion().equals(findVersion) || ModelUtils.isUnresolvedVersion(findVersion) && lp.getVersion().equals(this.resolvedVersion)))) {
            return null;
        }
        if (!Objects.equals(artifact.getClassifier(), lp.getAppArtifact().getClassifier())) {
            Path path;
            if ("tests".equals(artifact.getClassifier()) && Files.exists(path = lp.getTestClassesDir(), new LinkOption[0])) {
                return path.toFile();
            }
            return null;
        }
        String type = artifact.getExtension();
        if (type.equals("jar")) {
            Path classesDir = lp.getClassesDir();
            if (Files.exists(classesDir, new LinkOption[0])) {
                return classesDir.toFile();
            }
            Path path = lp.getOutputDir().resolve(LocalWorkspace.getFileName(artifact));
            if (Files.exists(path, new LinkOption[0])) {
                return path.toFile();
            }
            if (!(Files.exists(lp.getSourcesSourcesDir(), new LinkOption[0]) || Files.exists(lp.getResourcesSourcesDir(), new LinkOption[0]) || this.isFoundInLocalRepo(artifact))) {
                try {
                    Files.createDirectories(classesDir, new FileAttribute[0]);
                    return classesDir.toFile();
                }
                catch (IOException iOException) {}
            }
        } else if (type.equals("pom") && (pom = lp.getRawModel().getPomFile()).exists()) {
            return pom;
        }
        return null;
    }

    private boolean isFoundInLocalRepo(Artifact artifact) {
        String localRepo = this.getLocalRepo();
        if (localRepo == null) {
            return false;
        }
        Path p = Paths.get(localRepo, new String[0]);
        for (String s : artifact.getGroupId().split("\\.")) {
            p = p.resolve(s);
        }
        p = p.resolve(artifact.getArtifactId());
        p = p.resolve(artifact.getVersion());
        p = p.resolve(LocalWorkspace.getFileName(artifact));
        return Files.exists(p, new LinkOption[0]);
    }

    private static String getFileName(Artifact artifact) {
        StringBuilder fileName = new StringBuilder();
        fileName.append(artifact.getArtifactId()).append('-').append(artifact.getVersion());
        if (!artifact.getClassifier().isEmpty()) {
            fileName.append('-').append(artifact.getClassifier());
        }
        fileName.append('.').append(artifact.getExtension());
        return fileName.toString();
    }

    private String getLocalRepo() {
        try {
            return (this.mvnCtx == null ? (this.mvnCtx = new BootstrapMavenContext((BootstrapMavenContextConfig<?>)BootstrapMavenContext.config().setCurrentProject(this.currentProject))) : this.mvnCtx).getLocalRepo();
        }
        catch (BootstrapMavenException e) {
            return null;
        }
    }

    public List<String> findVersions(Artifact artifact) {
        if (this.lastFindVersionsKey != null && artifact.getVersion().equals(this.lastFindVersions.get(0)) && this.lastFindVersionsKey.getArtifactId().equals(artifact.getArtifactId()) && this.lastFindVersionsKey.getGroupId().equals(artifact.getGroupId())) {
            return this.lastFindVersions;
        }
        this.lastFindVersionsKey = new AppArtifactKey(artifact.getGroupId(), artifact.getArtifactId());
        LocalProject lp = this.getProject(this.lastFindVersionsKey);
        if (lp == null || !lp.getVersion().equals(artifact.getVersion())) {
            this.lastFindVersionsKey = null;
            return Collections.emptyList();
        }
        this.lastFindVersions = Collections.singletonList(artifact.getVersion());
        return this.lastFindVersions;
    }

    public String getResolvedVersion() {
        return this.resolvedVersion;
    }

    void setResolvedVersion(String resolvedVersion) {
        this.resolvedVersion = resolvedVersion;
    }

    LocalProject getCurrentProject() {
        return this.currentProject;
    }

    void setCurrentProject(LocalProject currentProject) {
        this.currentProject = currentProject;
    }

    void setBootstrapMavenContext(BootstrapMavenContext mvnCtx) {
        this.mvnCtx = mvnCtx;
    }
}

