/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import io.quarkus.bootstrap.model.Mappable;
import io.quarkus.bootstrap.model.MappableCollectionFactory;
import io.quarkus.maven.dependency.ArtifactCoords;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class PlatformReleaseInfo
implements Serializable,
Mappable {
    private static final long serialVersionUID = 7751600738849301644L;
    private final String platformKey;
    private final String stream;
    private final String version;
    private final List<ArtifactCoords> boms;

    static PlatformReleaseInfo fromMap(Map<String, Object> map) {
        Collection bomsStr = (Collection)map.get("boms");
        ArrayList<ArtifactCoords> boms = new ArrayList<ArtifactCoords>(bomsStr.size());
        for (String bomStr : bomsStr) {
            boms.add(ArtifactCoords.fromString(bomStr));
        }
        return new PlatformReleaseInfo((String)map.get("platform-key"), (String)map.get("stream"), (String)map.get("version"), boms);
    }

    private static List<ArtifactCoords> parseArtifactCoords(String boms) {
        String[] bomCoords = boms.split(",");
        ArrayList<ArtifactCoords> result = new ArrayList<ArtifactCoords>(bomCoords.length);
        for (String s : bomCoords) {
            result.add(ArtifactCoords.fromString(s));
        }
        return result;
    }

    public PlatformReleaseInfo(String platformKey, String stream, String version, String boms) {
        this(platformKey, stream, version, PlatformReleaseInfo.parseArtifactCoords(boms));
    }

    public PlatformReleaseInfo(String platformKey, String stream, String version, List<ArtifactCoords> boms) {
        this.platformKey = platformKey;
        this.stream = stream;
        this.version = version;
        this.boms = boms;
    }

    public String getPlatformKey() {
        return this.platformKey;
    }

    public String getStream() {
        return this.stream;
    }

    public String getVersion() {
        return this.version;
    }

    public List<ArtifactCoords> getBoms() {
        return this.boms;
    }

    String getPropertyName() {
        StringBuilder buf = new StringBuilder();
        buf.append("platform.release-info@").append(this.platformKey).append('$').append(this.stream).append('#').append(this.version);
        return buf.toString();
    }

    String getPropertyValue() {
        StringBuilder buf = new StringBuilder();
        List<ArtifactCoords> boms = this.getBoms();
        if (!boms.isEmpty()) {
            buf.append(boms.get(0).toString());
            for (int i = 1; i < boms.size(); ++i) {
                buf.append(',').append(boms.get(i));
            }
        }
        return buf.toString();
    }

    @Override
    public Map<String, Object> asMap(MappableCollectionFactory factory) {
        Map<String, Object> map = factory.newMap(4);
        if (this.platformKey != null) {
            map.put("platform-key", this.platformKey);
        }
        if (this.stream != null) {
            map.put("stream", this.stream);
        }
        if (this.version != null) {
            map.put("version", this.version);
        }
        if (!this.boms.isEmpty()) {
            map.put("boms", Mappable.toStringCollection(this.boms, ArtifactCoords::toGACTVString, factory));
        }
        return map;
    }

    public String toString() {
        return this.getPropertyName() + "=" + this.getPropertyValue();
    }
}

