/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsTest;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.TestAnnotationBuildItem;
import io.quarkus.deployment.builditem.TestClassBeanBuildItem;
import io.quarkus.deployment.builditem.TestProfileBuildItem;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationTransformation;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

public class TestsAsBeansProcessor {
    private static final Logger LOG = Logger.getLogger(TestsAsBeansProcessor.class);
    private static final DotName QUARKUS_TEST_PROFILE = DotName.createSimple((String)"io.quarkus.test.junit.QuarkusTestProfile");
    private static final DotName TEST_PROFILE = DotName.createSimple((String)"io.quarkus.test.junit.TestProfile");
    private static final DotName QUARKUS_TEST = DotName.createSimple((String)"io.quarkus.test.junit.QuarkusTest");
    private static final DotName QUARKUS_INTEGRATION_TEST = DotName.createSimple((String)"io.quarkus.test.junit.QuarkusIntegrationTest");
    private static final DotName QUARKUS_MAIN_TEST = DotName.createSimple((String)"io.quarkus.test.junit.main.QuarkusMainTest");
    private static final DotName NESTED = DotName.createSimple((String)"org.junit.jupiter.api.Nested");

    @BuildStep
    public void testAnnotations(List<TestAnnotationBuildItem> items, BuildProducer<BeanDefiningAnnotationBuildItem> producer) {
        for (TestAnnotationBuildItem item : items) {
            producer.produce((BuildItem)new BeanDefiningAnnotationBuildItem(DotName.createSimple((String)item.getAnnotationClassName())));
        }
    }

    @BuildStep
    public void testClassBeans(List<TestClassBeanBuildItem> items, BuildProducer<AdditionalBeanBuildItem> producer) {
        if (items.isEmpty()) {
            return;
        }
        AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder();
        for (TestClassBeanBuildItem item : items) {
            builder.addBeanClass(item.getTestClassName());
        }
        producer.produce((BuildItem)builder.build());
    }

    @BuildStep(onlyIf={IsTest.class})
    AnnotationsTransformerBuildItem vetoTestClassesNotMatchingTestProfile(Optional<TestProfileBuildItem> testProfile, CombinedIndexBuildItem index, List<TestAnnotationBuildItem> testAnnotationBuildItems) {
        Set additionalTestAnnotationNames = testAnnotationBuildItems.stream().map(TestAnnotationBuildItem::getAnnotationClassName).filter(a -> !a.equals(QUARKUS_TEST.toString())).collect(Collectors.toSet());
        return new AnnotationsTransformerBuildItem(((AnnotationTransformation.ClassBuilder)AnnotationTransformation.forClasses().when(tc -> {
            boolean veto;
            block5: {
                String testProfileClassName;
                ClassInfo maybeTestClass;
                block4: {
                    maybeTestClass = tc.declaration().asClass();
                    veto = false;
                    if (maybeTestClass.hasAnnotation(QUARKUS_TEST) || maybeTestClass.hasAnnotation(QUARKUS_INTEGRATION_TEST) || maybeTestClass.hasAnnotation(QUARKUS_MAIN_TEST)) break block4;
                    if (!additionalTestAnnotationNames.stream().anyMatch(arg_0 -> ((ClassInfo)maybeTestClass).hasAnnotation(arg_0))) break block5;
                }
                boolean bl = veto = !this.matchesProfile(maybeTestClass, testProfileClassName = (String)testProfile.map(TestProfileBuildItem::getTestProfileClassName).orElse(null));
                if (veto && this.hasMatchingNestedTest(maybeTestClass, testProfileClassName, index.getComputingIndex())) {
                    LOG.warnf("Test class [%s] does not match the current test profile [%s] but cannot be vetoed because it declares a matching @Nested test", (Object)maybeTestClass, (Object)testProfileClassName);
                    veto = false;
                }
            }
            return veto;
        })).transform(tc -> tc.add(AnnotationInstance.builder((DotName)DotNames.VETOED).buildWithTarget((AnnotationTarget)tc.declaration()))));
    }

    @BuildStep(onlyIf={IsTest.class})
    AnnotationsTransformerBuildItem vetoTestProfileBeans(Optional<TestProfileBuildItem> testProfile, final CustomScopeAnnotationsBuildItem customScopes, final CombinedIndexBuildItem index) {
        if (index.getIndex().getAllKnownImplementors(QUARKUS_TEST_PROFILE).isEmpty()) {
            return null;
        }
        final Set<DotName> currentTestProfileHierarchy = TestsAsBeansProcessor.initTestProfileHierarchy(testProfile, index.getComputingIndex());
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public void transform(AnnotationsTransformer.TransformationContext context) {
                ClassInfo clazz;
                AnnotationTarget target = context.getTarget();
                if (target.kind() == AnnotationTarget.Kind.METHOD) {
                    this.vetoProducerIfNecessary(target.asMethod().declaringClass(), context);
                } else if (target.kind() == AnnotationTarget.Kind.FIELD) {
                    this.vetoProducerIfNecessary(target.asField().declaringClass(), context);
                } else if (target.kind() == AnnotationTarget.Kind.CLASS && (clazz = target.asClass()).nestingType() == ClassInfo.NestingType.INNER && Modifier.isStatic(clazz.flags())) {
                    ClassInfo enclosing = index.getComputingIndex().getClassByName(clazz.enclosingClass());
                    if (customScopes.isScopeIn(context.getAnnotations()) && TestsAsBeansProcessor.isTestProfileClass(enclosing, index.getComputingIndex()) && !currentTestProfileHierarchy.contains(enclosing.name())) {
                        context.transform().add(DotNames.VETOED, new AnnotationValue[0]).done();
                    }
                }
            }

            private void vetoProducerIfNecessary(ClassInfo declaringClass, AnnotationsTransformer.TransformationContext context) {
                if (Annotations.contains((Collection)context.getAnnotations(), (DotName)DotNames.PRODUCES) && TestsAsBeansProcessor.isTestProfileClass(declaringClass, index.getComputingIndex()) && !currentTestProfileHierarchy.contains(declaringClass.name())) {
                    context.transform().add(DotNames.VETOED_PRODUCER, new AnnotationValue[0]).done();
                }
            }
        });
    }

    private static Set<DotName> initTestProfileHierarchy(Optional<TestProfileBuildItem> testProfile, IndexView index) {
        Set<DotName> ret = Set.of();
        if (testProfile.isPresent()) {
            DotName testProfileClassName = DotName.createSimple((String)testProfile.get().getTestProfileClassName());
            ret = Set.of(testProfileClassName);
            ClassInfo testProfileClass = index.getClassByName(testProfile.get().getTestProfileClassName());
            if (testProfileClass != null && !testProfileClass.superName().equals((Object)DotName.OBJECT_NAME)) {
                ret = new HashSet<DotName>();
                ret.add(testProfileClassName);
                DotName superName = testProfileClass.superName();
                while (superName != null && !superName.equals((Object)DotNames.OBJECT)) {
                    ret.add(superName);
                    ClassInfo superClass = index.getClassByName(superName);
                    if (superClass != null) {
                        superName = superClass.superName();
                        continue;
                    }
                    superName = null;
                }
            }
        }
        return ret;
    }

    private static boolean isTestProfileClass(ClassInfo clazz, IndexView index) {
        if (clazz.interfaceNames().contains(QUARKUS_TEST_PROFILE)) {
            return true;
        }
        DotName superName = clazz.superName();
        while (superName != null && !superName.equals((Object)DotNames.OBJECT)) {
            ClassInfo superClass = index.getClassByName(superName);
            if (superClass != null) {
                if (superClass.interfaceNames().contains(QUARKUS_TEST_PROFILE)) {
                    return true;
                }
                superName = superClass.superName();
                continue;
            }
            superName = null;
        }
        return false;
    }

    private boolean hasMatchingNestedTest(ClassInfo testClass, String testProfileClassName, IndexView index) {
        for (DotName memberClassName : testClass.memberClasses()) {
            ClassInfo memberClass = index.getClassByName(memberClassName);
            if (memberClass == null || !memberClass.hasDeclaredAnnotation(NESTED) || !this.matchesProfile(memberClass, testProfileClassName) && !this.hasMatchingNestedTest(memberClass, testProfileClassName, index)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesProfile(ClassInfo testClass, String testProfileClassName) {
        AnnotationInstance testProfileAnnotation = testClass.declaredAnnotation(TEST_PROFILE);
        if (testProfileClassName == null) {
            return testProfileAnnotation == null;
        }
        if (testProfileAnnotation != null) {
            String annotationProfileClassName = testProfileAnnotation.value().asClass().name().toString();
            return testProfileClassName.equals(annotationProfileClassName);
        }
        return false;
    }
}

