/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.config.ConfigProperties;
import io.quarkus.arc.deployment.ArcDevModeConfig;
import io.quarkus.arc.deployment.ArcTestConfig;
import io.quarkus.deployment.index.IndexDependencyConfig;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@ConfigRoot(phase=ConfigPhase.BUILD_TIME)
public class ArcConfig {
    public static final Set<String> ALLOWED_REMOVE_UNUSED_BEANS_VALUES = Set.of("all", "true", "none", "false", "fwk", "framework");
    @ConfigItem(defaultValue="all")
    public String removeUnusedBeans;
    @ConfigItem(defaultValue="true")
    public boolean autoInjectFields;
    @ConfigItem(defaultValue="true")
    public boolean transformUnproxyableClasses;
    @ConfigItem(defaultValue="false")
    public boolean failOnInterceptedPrivateMethod;
    @ConfigItem(defaultValue="kebab-case")
    public ConfigProperties.NamingStrategy configPropertiesDefaultNamingStrategy;
    @ConfigItem
    public Optional<List<String>> selectedAlternatives;
    @ConfigItem(defaultValue="true")
    public boolean autoProducerMethods;
    @ConfigItem
    public Optional<List<String>> excludeTypes;
    @ConfigItem
    public Optional<List<String>> unremovableTypes;
    @ConfigItem
    Map<String, IndexDependencyConfig> excludeDependency;
    @ConfigItem(defaultValue="true")
    public boolean detectUnusedFalsePositives;
    @ConfigItem(defaultValue="true")
    public boolean detectWrongAnnotations;
    @ConfigItem
    public ArcDevModeConfig devMode;
    @ConfigItem
    public ArcTestConfig test;
    @ConfigItem
    public Optional<List<String>> ignoredSplitPackages;

    public final boolean isRemoveUnusedBeansFieldValid() {
        return ALLOWED_REMOVE_UNUSED_BEANS_VALUES.contains(this.removeUnusedBeans.toLowerCase());
    }

    public final boolean shouldEnableBeanRemoval() {
        String lowerCase = this.removeUnusedBeans.toLowerCase();
        return "all".equals(lowerCase) || "true".equals(lowerCase) || "fwk".equals(lowerCase) || "framework".equals(lowerCase);
    }

    public final boolean shouldOnlyKeepAppBeans() {
        String lowerCase = this.removeUnusedBeans.toLowerCase();
        return "fwk".equals(lowerCase) || "framework".equals(lowerCase);
    }
}

