/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.udp;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.AttributeKey;
import io.netty.util.NetUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.BootstrapHandlers;
import reactor.netty.resources.LoopResources;
import reactor.netty.udp.UdpInbound;
import reactor.netty.udp.UdpOperations;
import reactor.netty.udp.UdpOutbound;
import reactor.netty.udp.UdpServerBind;
import reactor.netty.udp.UdpServerBootstrap;
import reactor.netty.udp.UdpServerDoOn;
import reactor.netty.udp.UdpServerObserve;
import reactor.netty.udp.UdpServerRunOn;
import reactor.util.Logger;
import reactor.util.Loggers;

public abstract class UdpServer {
    static final int DEFAULT_PORT = System.getenv("PORT") != null ? Integer.parseInt(System.getenv("PORT")) : 12012;
    static final Bootstrap DEFAULT_BOOTSTRAP = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)30000)).option(ChannelOption.AUTO_READ, (Object)false)).option(ChannelOption.SO_RCVBUF, (Object)0x100000)).option(ChannelOption.SO_SNDBUF, (Object)0x100000)).localAddress(NetUtil.LOCALHOST, DEFAULT_PORT);
    static final LoggingHandler LOGGING_HANDLER;
    static final Logger log;

    public static UdpServer create() {
        return UdpServerBind.INSTANCE;
    }

    public final UdpServer addressSupplier(Supplier<? extends SocketAddress> bindingAddressSupplier) {
        Objects.requireNonNull(bindingAddressSupplier, "bindingAddressSupplier");
        return this.bootstrap(b -> (Bootstrap)b.localAddress((SocketAddress)bindingAddressSupplier.get()));
    }

    public final <T> UdpServer attr(AttributeKey<T> key, T value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        return this.bootstrap(b -> (Bootstrap)b.attr(key, value));
    }

    public final UdpServer bootstrap(Function<? super Bootstrap, ? extends Bootstrap> bootstrapMapper) {
        return new UdpServerBootstrap(this, bootstrapMapper);
    }

    public final Mono<? extends Connection> bind() {
        Bootstrap b;
        try {
            b = this.configure();
        }
        catch (Throwable t) {
            Exceptions.throwIfJvmFatal((Throwable)t);
            return Mono.error((Throwable)t);
        }
        return this.bind(b);
    }

    public final Connection bindNow(Duration timeout) {
        try {
            return Objects.requireNonNull((Connection)this.bind().block(timeout), "aborted");
        }
        catch (IllegalStateException e) {
            if (e.getMessage().contains("blocking read")) {
                throw new IllegalStateException("UdpServer couldn't be started within " + timeout.toMillis() + "ms");
            }
            throw e;
        }
    }

    public final UdpServer doOnBind(Consumer<? super Bootstrap> doOnBind) {
        Objects.requireNonNull(doOnBind, "doOnBind");
        return new UdpServerDoOn(this, doOnBind, null, null);
    }

    public final UdpServer doOnBound(Consumer<? super Connection> doOnBound) {
        Objects.requireNonNull(doOnBound, "doOnBound");
        return new UdpServerDoOn(this, null, doOnBound, null);
    }

    public final UdpServer doOnUnbound(Consumer<? super Connection> doOnUnbound) {
        Objects.requireNonNull(doOnUnbound, "doOnUnbound");
        return new UdpServerDoOn(this, null, null, doOnUnbound);
    }

    public final UdpServer doOnLifecycle(Consumer<? super Bootstrap> onBind, Consumer<? super Connection> onBound, Consumer<? super Connection> onUnbound) {
        Objects.requireNonNull(onBind, "onBind");
        Objects.requireNonNull(onBound, "onBound");
        Objects.requireNonNull(onUnbound, "onUnbound");
        return new UdpServerDoOn(this, onBind, onBound, onUnbound);
    }

    public final UdpServer handle(BiFunction<? super UdpInbound, ? super UdpOutbound, ? extends Publisher<Void>> handler) {
        Objects.requireNonNull(handler, "handler");
        return this.doOnBound(c -> {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(c.channel(), "Handler is being applied: {}"), new Object[]{handler});
            }
            Mono.fromDirect((Publisher)((Publisher)handler.apply((UdpInbound)((Object)c), (UdpOutbound)((Object)c)))).subscribe(c.disposeSubscriber());
        });
    }

    public final UdpServer host(String host) {
        Objects.requireNonNull(host, "host");
        return this.bootstrap(b -> (Bootstrap)b.localAddress(host, UdpServer.getPort(b)));
    }

    public final UdpServer observe(ConnectionObserver observer) {
        return new UdpServerObserve(this, observer);
    }

    public final <T> UdpServer option(ChannelOption<T> key, T value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        return this.bootstrap(b -> (Bootstrap)b.option(key, value));
    }

    public final UdpServer port(int port) {
        return this.bootstrap(b -> (Bootstrap)b.localAddress(UdpServer.getHost(b), port));
    }

    public final UdpServer runOn(EventLoopGroup eventLoopGroup) {
        Objects.requireNonNull(eventLoopGroup, "eventLoopGroup");
        return this.runOn((boolean preferNative) -> eventLoopGroup);
    }

    public final UdpServer runOn(LoopResources channelResources) {
        return this.runOn(channelResources, LoopResources.DEFAULT_NATIVE);
    }

    public final UdpServer runOn(LoopResources channelResources, boolean preferNative) {
        return new UdpServerRunOn(this, channelResources, preferNative, null);
    }

    public final UdpServer runOn(LoopResources channelResources, InternetProtocolFamily family) {
        return new UdpServerRunOn(this, channelResources, false, family);
    }

    @Deprecated
    public final UdpServer wiretap() {
        return this.bootstrap(b -> BootstrapHandlers.updateLogSupport(b, LOGGING_HANDLER));
    }

    public final UdpServer wiretap(boolean enable) {
        if (enable) {
            return this.bootstrap(b -> BootstrapHandlers.updateLogSupport(b, LOGGING_HANDLER));
        }
        return this.bootstrap(b -> BootstrapHandlers.removeConfiguration(b, "reactor.left.loggingHandler"));
    }

    public final UdpServer wiretap(String category) {
        return this.wiretap(category, LogLevel.DEBUG);
    }

    public final UdpServer wiretap(String category, LogLevel level) {
        Objects.requireNonNull(category, "category");
        Objects.requireNonNull(level, "level");
        return this.bootstrap(b -> BootstrapHandlers.updateLogSupport(b, new LoggingHandler(category, level)));
    }

    protected Bootstrap configure() {
        return DEFAULT_BOOTSTRAP.clone();
    }

    protected abstract Mono<? extends Connection> bind(Bootstrap var1);

    static String getHost(Bootstrap b) {
        if (b.config().localAddress() instanceof InetSocketAddress) {
            return ((InetSocketAddress)b.config().localAddress()).getHostString();
        }
        return NetUtil.LOCALHOST.getHostAddress();
    }

    static int getPort(Bootstrap b) {
        if (b.config().localAddress() instanceof InetSocketAddress) {
            return ((InetSocketAddress)b.config().localAddress()).getPort();
        }
        return DEFAULT_PORT;
    }

    static {
        BootstrapHandlers.channelOperationFactory(DEFAULT_BOOTSTRAP, (ch, c, msg) -> new UdpOperations(ch, c));
        LOGGING_HANDLER = new LoggingHandler(UdpServer.class);
        log = Loggers.getLogger(UdpServer.class);
    }
}

