/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace.export;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.sdk.internal.ComponentId;
import io.opentelemetry.sdk.internal.SemConvAttributes;
import io.opentelemetry.sdk.trace.export.LongCallable;
import io.opentelemetry.sdk.trace.export.SpanProcessorInstrumentation;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.Nullable;

final class SemConvSpanProcessorInstrumentation
implements SpanProcessorInstrumentation {
    private final Object lock = new Object();
    private final AtomicBoolean builtQueueMetrics = new AtomicBoolean(false);
    private final Supplier<MeterProvider> meterProvider;
    private final Attributes standardAttrs;
    private final Attributes droppedAttrs;
    @Nullable
    private Meter meter;
    @Nullable
    private volatile LongCounter processedSpans;

    SemConvSpanProcessorInstrumentation(ComponentId componentId, Supplier<MeterProvider> meterProvider) {
        this.meterProvider = meterProvider;
        this.standardAttrs = Attributes.of((AttributeKey)SemConvAttributes.OTEL_COMPONENT_TYPE, (Object)componentId.getTypeName(), (AttributeKey)SemConvAttributes.OTEL_COMPONENT_NAME, (Object)componentId.getComponentName());
        this.droppedAttrs = Attributes.of((AttributeKey)SemConvAttributes.OTEL_COMPONENT_TYPE, (Object)componentId.getTypeName(), (AttributeKey)SemConvAttributes.OTEL_COMPONENT_NAME, (Object)componentId.getComponentName(), (AttributeKey)SemConvAttributes.ERROR_TYPE, (Object)"queue_full");
    }

    @Override
    public void dropSpans(int count) {
        this.processedSpans().add((long)count, this.droppedAttrs);
    }

    @Override
    public void finishSpans(int count, @Nullable String error) {
        if (error == null) {
            this.processedSpans().add((long)count, this.standardAttrs);
            return;
        }
        Attributes attributes = this.standardAttrs.toBuilder().put(SemConvAttributes.ERROR_TYPE, (Object)error).build();
        this.processedSpans().add((long)count, attributes);
    }

    @Override
    public void buildQueueMetricsOnce(long capacity, LongCallable getSize) {
        if (!this.builtQueueMetrics.compareAndSet(false, true)) {
            return;
        }
        this.meter().upDownCounterBuilder("otel.sdk.processor.span.queue.capacity").setUnit("span").setDescription("The maximum number of spans the queue of a given instance of an SDK span processor can hold. ").buildWithCallback(m -> m.record(capacity, this.standardAttrs));
        this.meter().upDownCounterBuilder("otel.sdk.processor.span.queue.size").setUnit("span").setDescription("The number of spans in the queue of a given instance of an SDK span processor.").buildWithCallback(m -> m.record(getSize.get(), this.standardAttrs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LongCounter processedSpans() {
        LongCounter processedSpans = this.processedSpans;
        if (processedSpans == null) {
            Object object = this.lock;
            synchronized (object) {
                processedSpans = this.processedSpans;
                if (processedSpans == null) {
                    this.processedSpans = processedSpans = this.meter().counterBuilder("otel.sdk.processor.span.processed").setUnit("span").setDescription("The number of spans for which the processing has finished, either successful or failed.").build();
                }
            }
        }
        return processedSpans;
    }

    private Meter meter() {
        if (this.meter == null) {
            this.meter = this.meterProvider.get().get("io.opentelemetry.sdk.trace");
        }
        return this.meter;
    }
}

