/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.htmx.spring.boot.mvc;

import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxLocationRedirectView;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxRedirectView;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxRefreshView;
import java.util.Locale;
import org.springframework.core.Ordered;
import org.springframework.lang.Nullable;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

public class HtmxViewResolver
extends WebApplicationObjectSupport
implements ViewResolver,
Ordered {
    public static final String REDIRECT_URL_PREFIX = "redirect:htmx:";
    public static final String LOCATION_URL_PREFIX = "redirect:htmx:location:";
    public static final String REFRESH_VIEW_NAME = "refresh:htmx";
    private int order = Integer.MAX_VALUE;
    private boolean redirectContextRelative = true;
    @Nullable
    private String[] redirectHosts;

    public int getOrder() {
        return this.order;
    }

    @Nullable
    public String[] getRedirectHosts() {
        return this.redirectHosts;
    }

    public View resolveViewName(String viewName, Locale locale) throws Exception {
        if (viewName.equals(REFRESH_VIEW_NAME)) {
            return new HtmxRefreshView();
        }
        if (viewName.startsWith(LOCATION_URL_PREFIX)) {
            String redirectUrl = viewName.substring(LOCATION_URL_PREFIX.length());
            HtmxLocationRedirectView view = new HtmxLocationRedirectView(redirectUrl, this.isRedirectContextRelative());
            String[] hosts = this.getRedirectHosts();
            if (hosts != null) {
                view.setHosts(hosts);
            }
            return view;
        }
        if (viewName.startsWith(REDIRECT_URL_PREFIX)) {
            String redirectUrl = viewName.substring(REDIRECT_URL_PREFIX.length());
            HtmxRedirectView view = new HtmxRedirectView(redirectUrl, this.isRedirectContextRelative());
            String[] hosts = this.getRedirectHosts();
            if (hosts != null) {
                view.setHosts(hosts);
            }
            return view;
        }
        return null;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setRedirectContextRelative(boolean redirectContextRelative) {
        this.redirectContextRelative = redirectContextRelative;
    }

    public void setRedirectHosts(String ... redirectHosts) {
        this.redirectHosts = redirectHosts;
    }

    protected boolean isRedirectContextRelative() {
        return this.redirectContextRelative;
    }
}

