/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.io.netcdf;

import io.github.msdk.MSDKRuntimeException;
import io.github.msdk.datamodel.MsSpectrumType;
import io.github.msdk.datamodel.SimpleMsScan;
import io.github.msdk.spectra.centroidprofiledetection.SpectrumTypeDetectionAlgorithm;
import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Variable;

public class NetCDFMsScan
extends SimpleMsScan {
    private int[] scanStartPositions;
    private float[] scanRetentionTimes;
    private Variable massValueVariable;
    private Variable intensityValueVariable;
    private double massValueScaleFactor;
    private double intensityValueScaleFactor;
    private double[] preLoadedMzValues;
    private float[] preLoadedIntensityValues;
    private Integer numOfDataPoints;
    private MsSpectrumType spectrumType;

    public NetCDFMsScan(Integer scanNumber, int[] scanStartPositions, float[] scanRetentionTimes, Variable massValueVariable, Variable intensityValueVariable, double massValueScaleFactor, double intensityValueScaleFactor) {
        super(scanNumber);
        this.scanStartPositions = scanStartPositions;
        this.scanRetentionTimes = scanRetentionTimes;
        this.massValueVariable = massValueVariable;
        this.intensityValueVariable = intensityValueVariable;
        this.massValueScaleFactor = massValueScaleFactor;
        this.intensityValueScaleFactor = intensityValueScaleFactor;
        this.preLoadedMzValues = null;
        this.preLoadedIntensityValues = null;
        this.spectrumType = null;
    }

    public float[] getIntensityValues(float[] intensityValues) {
        if (this.preLoadedIntensityValues == null) {
            Integer scanIndex = this.getScanIndex();
            this.numOfDataPoints = this.getNumberOfDataPoints();
            try {
                int[] scanStartPosition = new int[]{this.scanStartPositions[scanIndex]};
                int[] scanLength = new int[]{this.scanStartPositions[scanIndex + 1] - this.scanStartPositions[scanIndex]};
                Array intensityValueArray = this.intensityValueVariable.read(scanStartPosition, scanLength);
                Index intensityValuesIndex = intensityValueArray.getIndex();
                if (intensityValues == null || intensityValues.length < this.numOfDataPoints) {
                    intensityValues = new float[this.numOfDataPoints.intValue()];
                }
                for (int i = 0; i < this.numOfDataPoints; ++i) {
                    Index intensityIndex0 = intensityValuesIndex.set0(i);
                    intensityValues[i] = (float)(intensityValueArray.getDouble(intensityIndex0) * this.intensityValueScaleFactor);
                }
            }
            catch (IOException | InvalidRangeException e) {
                throw new MSDKRuntimeException(e);
            }
        } else {
            if (intensityValues == null || intensityValues.length < this.numOfDataPoints) {
                intensityValues = new float[this.numOfDataPoints.intValue()];
            }
            for (int i = 0; i < this.preLoadedIntensityValues.length; ++i) {
                intensityValues[i] = this.preLoadedIntensityValues[i];
            }
        }
        return intensityValues;
    }

    public double[] getMzValues(double[] mzValues) {
        if (this.preLoadedMzValues == null) {
            Integer scanIndex = this.getScanIndex();
            this.numOfDataPoints = this.getNumberOfDataPoints();
            try {
                int[] scanStartPosition = new int[]{this.scanStartPositions[scanIndex]};
                int[] scanLength = new int[]{this.scanStartPositions[scanIndex + 1] - this.scanStartPositions[scanIndex]};
                Array massValueArray = this.massValueVariable.read(scanStartPosition, scanLength);
                Index massValuesIndex = massValueArray.getIndex();
                if (mzValues == null || mzValues.length < this.numOfDataPoints) {
                    mzValues = new double[this.numOfDataPoints.intValue()];
                }
                for (int i = 0; i < this.numOfDataPoints; ++i) {
                    Index massIndex0 = massValuesIndex.set0(i);
                    mzValues[i] = massValueArray.getDouble(massIndex0) * this.massValueScaleFactor;
                }
            }
            catch (IOException | InvalidRangeException e) {
                throw new MSDKRuntimeException(e);
            }
        } else {
            if (mzValues == null || mzValues.length < this.numOfDataPoints) {
                mzValues = new double[this.numOfDataPoints.intValue()];
            }
            for (int i = 0; i < this.preLoadedMzValues.length; ++i) {
                mzValues[i] = this.preLoadedMzValues[i];
            }
        }
        return mzValues;
    }

    public Integer getNumberOfDataPoints() {
        if (this.numOfDataPoints == null) {
            Integer scanIndex = this.getScanIndex();
            this.numOfDataPoints = this.scanStartPositions[scanIndex + 1] - this.scanStartPositions[scanIndex];
        }
        return this.numOfDataPoints;
    }

    public Float getRetentionTime() {
        return Float.valueOf(this.scanRetentionTimes[this.getScanIndex()]);
    }

    public MsSpectrumType getSpectrumType() {
        if (this.spectrumType == null) {
            this.spectrumType = SpectrumTypeDetectionAlgorithm.detectSpectrumType((double[])this.getMzValues(), (float[])this.getIntensityValues(), (Integer)this.getNumberOfDataPoints());
        }
        return this.spectrumType;
    }

    public Integer getScanIndex() {
        return this.getScanNumber() - 1;
    }

    public void parseScan() throws IOException, InvalidRangeException {
        this.preLoadedMzValues = this.getMzValues();
        this.preLoadedIntensityValues = this.getIntensityValues();
        this.numOfDataPoints = this.getNumberOfDataPoints();
        this.setDataPoints(this.preLoadedMzValues, this.preLoadedIntensityValues, this.numOfDataPoints);
        this.spectrumType = SpectrumTypeDetectionAlgorithm.detectSpectrumType((double[])this.preLoadedMzValues, (float[])this.preLoadedIntensityValues, (Integer)this.numOfDataPoints);
    }
}

