/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.io.netcdf;

import io.github.msdk.MSDKException;
import io.github.msdk.MSDKMethod;
import io.github.msdk.datamodel.MsScan;
import io.github.msdk.datamodel.RawDataFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Variable;

public class NetCDFFileExportMethod
implements MSDKMethod<Void> {
    @Nonnull
    private final RawDataFile rawDataFile;
    @Nonnull
    private final File target;
    @Nonnull
    private final double massValueScaleFactor;
    @Nonnull
    private final double intensityValueScaleFactor;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean canceled = false;
    private int totalScans = 0;
    private float progress = 0.0f;
    private int lastLoggedProgress = 0;
    private List<MsScan> scans;
    private int[] scanStartPositions;
    private NetcdfFileWriter writer;

    public NetCDFFileExportMethod(@Nonnull RawDataFile rawDataFile, @Nonnull File target) {
        this(rawDataFile, target, 1.0, 1.0);
    }

    public NetCDFFileExportMethod(@Nonnull RawDataFile rawDataFile, @Nonnull File target, double massValueScaleFactor, double intensityValueScaleFactor) {
        this.rawDataFile = rawDataFile;
        this.target = target;
        this.massValueScaleFactor = massValueScaleFactor;
        this.intensityValueScaleFactor = intensityValueScaleFactor;
    }

    public Void execute() throws MSDKException {
        this.logger.info("Started export of " + this.rawDataFile.getName() + " to " + this.target);
        this.scans = this.rawDataFile.getScans();
        this.totalScans = this.scans.size();
        this.scanStartPositions = new int[this.totalScans + 1];
        try {
            this.writer = NetcdfFileWriter.createNew((NetcdfFileWriter.Version)NetcdfFileWriter.Version.netcdf3, (String)this.target.getAbsolutePath());
            Array scanIndexArray = this.getScanIndexArray();
            Array scanTimeArray = this.getScanTimeArray();
            if (scanIndexArray == null) {
                return null;
            }
            List<Dimension> scanIndexDims = this.getScanIndexDims();
            Variable scanIndexVariable = this.writer.addVariable(null, "scan_index", DataType.INT, scanIndexDims);
            Variable scanTimeVariable = this.writer.addVariable(null, "scan_acquisition_time", DataType.FLOAT, scanIndexDims);
            this.progress = 0.2f;
            List<Dimension> pointNumValDims = this.getPointValDims();
            Variable massValueVariable = this.getMassValueVariable(pointNumValDims);
            Variable intensityValueVariable = this.getIntensityValueVariable(pointNumValDims);
            Array massValueArray = Array.factory(Double.TYPE, (int[])new int[]{this.scanStartPositions[this.totalScans]});
            Array intensityValueArray = Array.factory(Double.TYPE, (int[])new int[]{this.scanStartPositions[this.totalScans]});
            int idx = 0;
            double[] mzValues = new double[10000];
            float[] intensityValues = new float[10000];
            for (MsScan scan : this.scans) {
                mzValues = scan.getMzValues(mzValues);
                intensityValues = scan.getIntensityValues(intensityValues);
                if (this.canceled) {
                    this.writer.close();
                    return null;
                }
                for (int i = 0; i < scan.getNumberOfDataPoints(); ++i) {
                    massValueArray.setDouble(idx, mzValues[i]);
                    intensityValueArray.setDouble(idx, (double)intensityValues[i]);
                    ++idx;
                }
                this.progress = 0.2f + 0.6f * ((float)idx / (float)this.scanStartPositions[this.totalScans]);
                if ((int)(this.progress * 100.0f) < this.lastLoggedProgress + 10) continue;
                this.lastLoggedProgress = (int)(this.progress * 10.0f) * 10;
                this.logger.debug("Exporting in progress... " + this.lastLoggedProgress + "% completed");
            }
            this.writer.create();
            this.writer.write(scanIndexVariable, scanIndexArray);
            this.writer.write(massValueVariable, massValueArray);
            this.writer.write(intensityValueVariable, intensityValueArray);
            this.writer.write(scanTimeVariable, scanTimeArray);
            this.writer.close();
            this.progress = 1.0f;
        }
        catch (IOException | InvalidRangeException e) {
            new MSDKException(e);
        }
        return null;
    }

    private Array getScanIndexArray() throws IOException {
        Array scanIndexArray = Array.factory(Integer.TYPE, (int[])new int[]{this.totalScans});
        int idx = 0;
        for (MsScan scan : this.scans) {
            if (this.canceled) {
                this.writer.close();
                return null;
            }
            this.scanStartPositions[idx + 1] = this.scanStartPositions[idx] + scan.getNumberOfDataPoints();
            ++idx;
        }
        for (int i = 0; i < this.scanStartPositions.length - 1; ++i) {
            scanIndexArray.setInt(i, this.scanStartPositions[i]);
        }
        return scanIndexArray;
    }

    private List<Dimension> getScanIndexDims() {
        Dimension scanNumberDim = this.writer.addDimension(null, "scan_number", this.totalScans);
        ArrayList<Dimension> scanIndexDims = new ArrayList<Dimension>();
        scanIndexDims.add(scanNumberDim);
        return scanIndexDims;
    }

    private List<Dimension> getPointValDims() {
        Dimension pointNumDim = this.writer.addDimension(null, "point_number", this.scanStartPositions[this.totalScans]);
        ArrayList<Dimension> pointNumValDims = new ArrayList<Dimension>();
        pointNumValDims.add(pointNumDim);
        return pointNumValDims;
    }

    private Array getScanTimeArray() {
        Array scanTimeArray = Array.factory(Float.TYPE, (int[])new int[]{this.totalScans});
        int idx = 0;
        for (MsScan scan : this.scans) {
            scanTimeArray.setFloat(idx++, scan.getRetentionTime().floatValue());
        }
        return scanTimeArray;
    }

    private Variable getMassValueVariable(List<Dimension> pointNumValDims) {
        Variable massValueVariable = this.writer.addVariable(null, "mass_values", DataType.FLOAT, pointNumValDims);
        massValueVariable.addAttribute(new Attribute("units", "M/Z"));
        massValueVariable.addAttribute(new Attribute("scale_factor", (Number)this.massValueScaleFactor));
        return massValueVariable;
    }

    private Variable getIntensityValueVariable(List<Dimension> pointNumValDims) {
        Variable intensityValueVariable = this.writer.addVariable(null, "intensity_values", DataType.FLOAT, pointNumValDims);
        intensityValueVariable.addAttribute(new Attribute("units", "Arbitrary Intensity Units"));
        intensityValueVariable.addAttribute(new Attribute("scale_factor", (Number)this.intensityValueScaleFactor));
        return intensityValueVariable;
    }

    public Float getFinishedPercentage() {
        return Float.valueOf(this.progress);
    }

    public Void getResult() {
        return null;
    }

    public void cancel() {
        this.canceled = true;
    }
}

