/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.org.plumelib.util;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.errorprone.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.errorprone.checker.calledmethods.qual.CalledMethodsBottom;
import org.checkerframework.errorprone.checker.formatter.qual.FormatBottom;
import org.checkerframework.errorprone.checker.formatter.qual.UnknownFormat;
import org.checkerframework.errorprone.checker.index.qual.GTENegativeOne;
import org.checkerframework.errorprone.checker.index.qual.IndexOrHigh;
import org.checkerframework.errorprone.checker.index.qual.LTEqLengthOf;
import org.checkerframework.errorprone.checker.index.qual.LessThan;
import org.checkerframework.errorprone.checker.index.qual.LessThanBottom;
import org.checkerframework.errorprone.checker.index.qual.LessThanUnknown;
import org.checkerframework.errorprone.checker.index.qual.LowerBoundBottom;
import org.checkerframework.errorprone.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.errorprone.checker.index.qual.NonNegative;
import org.checkerframework.errorprone.checker.index.qual.SameLenBottom;
import org.checkerframework.errorprone.checker.index.qual.SameLenUnknown;
import org.checkerframework.errorprone.checker.index.qual.SearchIndexBottom;
import org.checkerframework.errorprone.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.errorprone.checker.index.qual.SubstringIndexBottom;
import org.checkerframework.errorprone.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.errorprone.checker.index.qual.UpperBoundBottom;
import org.checkerframework.errorprone.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.errorprone.checker.initialization.qual.Initialized;
import org.checkerframework.errorprone.checker.interning.qual.Interned;
import org.checkerframework.errorprone.checker.interning.qual.InternedDistinct;
import org.checkerframework.errorprone.checker.interning.qual.UnknownInterned;
import org.checkerframework.errorprone.checker.lock.qual.GuardSatisfied;
import org.checkerframework.errorprone.checker.lock.qual.GuardedBy;
import org.checkerframework.errorprone.checker.lock.qual.GuardedByBottom;
import org.checkerframework.errorprone.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.errorprone.checker.mustcall.qual.MustCall;
import org.checkerframework.errorprone.checker.mustcall.qual.MustCallUnknown;
import org.checkerframework.errorprone.checker.nullness.qual.KeyForBottom;
import org.checkerframework.errorprone.checker.nullness.qual.NonNull;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.errorprone.checker.regex.qual.RegexBottom;
import org.checkerframework.errorprone.checker.regex.qual.UnknownRegex;
import org.checkerframework.errorprone.checker.signature.qual.SignatureBottom;
import org.checkerframework.errorprone.checker.signature.qual.SignatureUnknown;
import org.checkerframework.errorprone.checker.signedness.qual.Signed;
import org.checkerframework.errorprone.checker.signedness.qual.SignednessBottom;
import org.checkerframework.errorprone.checker.signedness.qual.UnknownSignedness;
import org.checkerframework.errorprone.common.initializedfields.qual.InitializedFields;
import org.checkerframework.errorprone.common.initializedfields.qual.InitializedFieldsBottom;
import org.checkerframework.errorprone.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.errorprone.common.value.qual.BottomVal;
import org.checkerframework.errorprone.common.value.qual.UnknownVal;

public class IdentityArraySet<@FormatBottom E>
extends AbstractSet<E> {
    private @Nullable E @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) [] values;
    private @NonNegative @LessThan(value={"values.length + 1"}) @IndexOrHigh(value={"values"}) @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThan(value={"this.values.length + 1"}) @LTEqLengthOf(value={"this.values"}) @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) int size = 0;
    transient @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) int sizeModificationCount = 0;

    @SideEffectFree
    public IdentityArraySet(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        this.values = initialCapacity == 0 ? null : new Object[initialCapacity];
    }

    @SideEffectFree
    public IdentityArraySet() {
        this(4);
    }

    @SideEffectFree
    private IdentityArraySet(E @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) [] values, @LTEqLengthOf(value={"values"}) @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) int size) {
        this.values = values;
        this.size = size;
    }

    @SideEffectFree
    public IdentityArraySet(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) Collection<@FormatBottom @SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @InternedDistinct @LockPossiblyHeld @GuardedByBottom @KeyForBottom @NonNull @Initialized @RegexBottom @UnknownThis @MustCall(value={}) @CalledMethodsBottom @SignatureBottom @SignednessBottom @InitializedFieldsBottom ? extends E> m4) {
        this(m4.size());
        this.addAll(m4);
    }

    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) boolean add(@GTENegativeOne @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) int index, E value) {
        if (index != -1) {
            return false;
        }
        if (this.size == 0 && this.values == null || this.size == this.values.length) {
            this.grow();
        }
        this.values[this.size] = value;
        ++this.size;
        ++this.sizeModificationCount;
        return true;
    }

    private void grow() {
        if (this.values == null) {
            this.values = new Object[4];
        } else {
            int newCapacity = 2 * this.values.length;
            this.values = Arrays.copyOf(this.values, newCapacity);
        }
    }

    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) boolean removeIndex(@GTENegativeOne @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) int index) {
        if (index == -1) {
            return false;
        }
        System.arraycopy(this.values, index + 1, this.values, index, this.size - index - 1);
        --this.size;
        ++this.sizeModificationCount;
        return true;
    }

    @Override
    @Pure
    public @NonNegative @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) int size() {
        return this.size;
    }

    @Override
    @Pure
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) boolean isEmpty() {
        return this.size == 0;
    }

    @Pure
    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) int indexOf(@GuardSatisfied @Nullable @UnknownSignedness @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @InitializedFields(value={}) Object value) {
        if (this.values == null) {
            return -1;
        }
        for (int i = 0; i < this.size; ++i) {
            if (value != this.values[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    @Pure
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) boolean contains(@GuardSatisfied @Nullable @UnknownSignedness @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @InitializedFields(value={}) Object value) {
        return this.indexOf(value) != -1;
    }

    @Override
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) boolean add(E value) {
        int index = this.indexOf(value);
        return this.add(index, value);
    }

    @Override
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) boolean remove(@GuardSatisfied @Nullable @UnknownSignedness @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @InitializedFields(value={}) Object value) {
        int index = this.indexOf(value);
        return this.removeIndex(index);
    }

    @Override
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) boolean addAll(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) Collection<@FormatBottom @SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @InternedDistinct @LockPossiblyHeld @GuardedByBottom @KeyForBottom @NonNull @Initialized @RegexBottom @UnknownThis @MustCall(value={}) @CalledMethodsBottom @SignatureBottom @SignednessBottom @InitializedFieldsBottom ? extends E> c) {
        if (c.isEmpty()) {
            return false;
        }
        return super.addAll(c);
    }

    @Override
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) boolean removeAll(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) Collection<@UnknownFormat @FormatBottom @SubstringIndexUnknown @SubstringIndexBottom @UnknownVal @BottomVal @SearchIndexUnknown @SearchIndexBottom @SameLenUnknown @SameLenBottom @LessThanUnknown @LessThanBottom @LowerBoundUnknown @LowerBoundBottom @UpperBoundUnknown @UpperBoundBottom @UnknownInterned @InternedDistinct @LockPossiblyHeld @GuardedBy(value={}) @LockPossiblyHeld @GuardedByBottom @UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized @UnknownRegex @RegexBottom @UnknownThis @UnknownThis @MustCallUnknown @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @SignatureUnknown @SignatureBottom @UnknownSignedness @SignednessBottom @InitializedFields(value={}) @InitializedFieldsBottom ?> c) {
        if (c.isEmpty()) {
            return false;
        }
        return super.removeAll(c);
    }

    @Override
    public void clear() {
        if (this.size != 0) {
            this.size = 0;
            ++this.sizeModificationCount;
        }
    }

    @Override
    @SideEffectFree
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) Iterator<E> iterator() {
        return new ArraySetIterator();
    }

    @Override
    public void forEach(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) Consumer<@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Nullable @Initialized @UnknownRegex @UnknownThis @MustCallUnknown @CalledMethods(value={}) @SignatureUnknown @UnknownSignedness @InitializedFields(value={}) ? super E> action) {
        Objects.requireNonNull(action);
        if (this.values == null) {
            return;
        }
        int oldSizeModificationCount = this.sizeModificationCount;
        for (int index = 0; index < this.size; ++index) {
            E e;
            try {
                e = this.values[index];
            }
            catch (IndexOutOfBoundsException exc) {
                throw new ConcurrentModificationException(exc);
            }
            action.accept(e);
        }
        if (oldSizeModificationCount != this.sizeModificationCount) {
            throw new ConcurrentModificationException();
        }
    }

    @SideEffectFree
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) IdentityArraySet<E> clone() {
        return new IdentityArraySet<E>(Arrays.copyOf(this.values, this.size), this.size);
    }

    @SideEffectFree
    @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) String repr() {
        return String.format("size=%d capacity=%s %s", this.size, this.values == null ? 0 : this.values.length, Arrays.toString(this.values));
    }

    private class ArraySetIterator
    implements Iterator<E> {
        @NonNegative @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) int index = 0;
        @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) boolean removed = true;
        @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) int initialSizeModificationCount;

        @SideEffectFree
        ArraySetIterator() {
            this.initialSizeModificationCount = IdentityArraySet.this.sizeModificationCount;
        }

        @Override
        @Pure
        public final @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) boolean hasNext() {
            return this.index < IdentityArraySet.this.size();
        }

        @Override
        public final E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.removed = false;
            return IdentityArraySet.this.values[this.index++];
        }

        @Override
        public final void remove() {
            int newIndex;
            if (this.removed) {
                throw new IllegalStateException("Called remove() on ArraySetIterator without calling next() first.");
            }
            if (this.initialSizeModificationCount != IdentityArraySet.this.sizeModificationCount) {
                throw new ConcurrentModificationException();
            }
            this.index = newIndex = this.index - 1;
            IdentityArraySet.this.removeIndex(this.index);
            this.initialSizeModificationCount = IdentityArraySet.this.sizeModificationCount;
            this.removed = true;
        }
    }
}

